/*
 * usecase_edit.h
 */
#include "math.h"

#include "usecase.h"
#include "usecase_edit.h"
#include "usecase_draw.h"

extern GdkPixmap *g_usecase_pixmap;
extern GdkGC *black_gc;
extern GdkGC *white_gc;
extern GdkGC *erase_gc;
extern GdkFont *g_font;

//GList *nlist;
//GList *alist;

UsecaseNodeStruct   usecaseNodeDat[USECASE_MAX_NODE];
UsecaseArcStruct    usecaseArcDat[USECASE_MAX_ARC];
UsecaseSystemStruct usecaseSystemDat[USECASE_MAX_SYSTEM];

int usecase_node_count;
int usecase_node_seq;
int usecase_selected_node;
int usecase_last_selected_node;

int usecase_system_count;
int usecase_system_seq;
int usecase_selected_system;
int usecase_last_selected_system;

int usecase_selected_system;
int usecase_last_selected_system;

int usecase_arc_count;
int usecase_arc_seq;
int usecase_arc_start_node;
int usecase_last_selected_arc;

int lastX, lastY;

/*
 * usecase_get_m (local)
 */
gint usecase_get_m(int start, int end)
{
  int result;

  result = (start+end)/2;

  return result;
}

/*
 * usecase_get_node_mx (local)
 */
gint usecase_get_node_mx(UsecaseNodeStruct *n_ptr)
{
  int result;

  result = n_ptr->rect.x + n_ptr->rect.width / 2;

  return result;
}

/*
 * usecase_get_node_my (local)
 */
gint usecase_get_node_my(UsecaseNodeStruct *n_ptr)
{
  int result;

  result = n_ptr->rect.y + n_ptr->rect.height / 2;

  return result;
}

/*
 * usecase_selection_judge_node (local)
 */
gint usecase_selection_judge_node(UsecaseNodeStruct *n_ptr, int x, int y)
{
  int x1, x2, y1, y2;
  
  x1 = n_ptr->rect.x;
  x2 = x1 + n_ptr->rect.width;
  y1 = n_ptr->rect.y;
  y2 = y1 + n_ptr->rect.height;

  if( x1<x && x<x2 && y1<y && y<y2 )
    return TRUE;

  return FALSE;
}

/*
 * usecase_selection_judge_system (local)
 */
gint usecase_selection_judge_system(UsecaseSystemStruct *s_ptr, int x, int y)
{
  int x1, x2, y1, y2;
  
  x1 = s_ptr->rect.x;
  x2 = x1 + s_ptr->rect.width;
  y1 = s_ptr->rect.y;
  y2 = y1 + s_ptr->rect.height;

  if( x1<=x && x<=x2 && y1<=y && y<=y2 ) {
    /**
    if( x1-3<=x && x<=x1+3 ) {
      s_ptr->select_mode = usecase_first;
      g_print("usecase_first\n"); //debug;
    } else {
      s_ptr->select_mode = usecase_select;
      g_print("usecase_select\n"); //debug;
    }
    **/
    if( x1-3<=x && x<=x1+3 )
      s_ptr->select_mode = usecase_first;
    else if( y2-3<=y && y<=y2+3 )
      s_ptr->select_mode = usecase_second;
    else if( x2-3<=x && x<=x2+3 )
      s_ptr->select_mode = usecase_third;
    else if( y1-3<=y && y<=y1+3 )
      s_ptr->select_mode = usecase_forth;
    else
      s_ptr->select_mode = usecase_select;

    
    return TRUE;
  }
  return FALSE;
}

/*
 * usecase_selection_judge_arc (local)
 */
gint usecase_selection_judge_arc(UsecaseArcStruct *a_ptr, int x, int y)
{
  double arc_x, arc_y, arc_theta;
  double cursor_x, cursor_y, cursor_theta;
  
  arc_x = a_ptr->start_x - a_ptr->end_x;
  arc_y = a_ptr->start_y - a_ptr->end_y;
  arc_theta = atan2(arc_x, arc_y);

  cursor_x = a_ptr->start_x - x;
  cursor_y = a_ptr->start_y - y;
  cursor_theta = atan2(cursor_x, cursor_y);

  if((int)((arc_theta*100)-2) < (int)(cursor_theta*100) &&
     (int)(cursor_theta*100) < (int)((arc_theta*100)+2)){

    if(a_ptr->start_x < x && x < a_ptr->end_x &&
       a_ptr->start_y < y && y < a_ptr->end_y)
      return TRUE;
    else if(a_ptr->end_x < x && x < a_ptr->start_x &&
	     a_ptr->end_y < y && y < a_ptr->start_y)
      return TRUE;
    else if(a_ptr->start_x < x && x < a_ptr->end_x &&
	     a_ptr->end_y < y && y < a_ptr->start_y)
      return TRUE;
    else if(a_ptr->end_x < x && x < a_ptr->start_x &&
	     a_ptr->start_y < y && y < a_ptr->end_y)
      return TRUE;
  }

  return FALSE;
}

/*
 * usecase_selection
 */
void usecase_selection(int x, int y, GdkEventButton *event)
{
  int i, j;
  int x1, x2, y1, y2;
  int sx1, sx2, sy1, sy2;

  //g_print("usecase_selection ... 0\n"); //debug

  usecase_select_init_node();
  usecase_select_init_arc();
  usecase_select_init_system();

  /* redraw last selection node by black */
  if(usecase_last_selected_node != 9999) {
    j = usecase_last_selected_node;
    usecase_draw_selected_node(g_usecase_pixmap, white_gc, &usecaseNodeDat[j]);
  }
  if(usecase_last_selected_system != 9999) {
    j = usecase_last_selected_system;
    usecase_draw_selected_system(g_usecase_pixmap, white_gc, &usecaseSystemDat[j]);
  }

  //g_print("usecase_selection ... 1\n"); //debug

  for(i=0; i<usecase_node_count; i++){
    switch(usecaseNodeDat[i].type){
    case usecase_actor_enum:
      if(usecase_selection_judge_node(&usecaseNodeDat[i], x, y)) {
	usecase_draw_selected_node(g_usecase_pixmap, black_gc,
				   &usecaseNodeDat[i]);
	usecase_selected_node = i;
	usecaseNodeDat[i].select_mode = TRUE;
	if(event->type == 5){
	  usecase_last_selected_node = usecase_selected_node;
	  usecase_selected_node = 9999;
	  usecase_open_actor_dialog(i);
	}
	return;
      }      
      break;
    case usecase_usecase_enum:
      if(usecase_selection_judge_node(&usecaseNodeDat[i], x, y)) {
	usecase_draw_selected_node(g_usecase_pixmap, black_gc,
				   &usecaseNodeDat[i]);
	usecase_selected_node = i;
	usecaseNodeDat[i].select_mode = TRUE;
	if(event->type == 5){
	  usecase_last_selected_node = usecase_selected_node;
	  usecase_selected_node = 9999;
	  usecase_open_usecase_dialog(i);
	}
	return;
      }      
      break;
    }
  }

  //g_print("usecase_selection ... 2\n"); //debug

  for(i=0; i<usecase_arc_count; i++){
    if(usecase_selection_judge_arc(&usecaseArcDat[i], x, y)) {
      usecase_draw_selected_arc(g_usecase_pixmap, &usecaseArcDat[i]);
      usecaseArcDat[i].select_mode = TRUE;
      usecase_last_selected_arc = i;
      if(event->type == 5){
      	usecase_open_arc_dialog(i);
      }
      return;
    }
  }

  //g_print("usecase_selection ... 3\n"); //debug

  for(i=0; i<usecase_system_count; i++){
    if(usecase_selection_judge_system(&usecaseSystemDat[i], x, y)) {
      usecase_draw_selected_system(g_usecase_pixmap, black_gc,
				   &usecaseSystemDat[i]);
      usecase_selected_system = i;
      /**
      usecaseSystemDat[i].select_mode = usecase_select;
      if(usecaseSystemDat[i].rect.x-3 < x < usecaseSystemDat[i].rect.x+3 )
	usecaseSystemDat[i].select_mode = usecase_edge;
      **/
      return;
    }      
  }

  //g_print("usecase_selection ... last\n"); //debug
}

/*
 * usecase_move (global)
 */
void usecase_move(int x, int y, int i)
{
  int dx, dy;

  switch(usecaseNodeDat[i].type){
  case usecase_actor_enum:
    usecase_draw_actor(g_usecase_pixmap, white_gc, &usecaseNodeDat[i]);
    break;
  case usecase_usecase_enum:
    usecase_draw_usecase(g_usecase_pixmap, white_gc, &usecaseNodeDat[i]);
    break;
  }
  usecase_draw_selected_node(g_usecase_pixmap, white_gc, &usecaseNodeDat[i]);
  usecase_draw_selected_str(g_usecase_pixmap, white_gc,
			    &usecaseNodeDat[i].str_rect);

  dx = x - lastX;
  dy = y - lastY;

  {
    int j;

    for(j=0; j<usecase_arc_count; j++){
      if(usecaseNodeDat[i].id == usecaseArcDat[j].start_node_id){
	usecase_draw_arc(g_usecase_pixmap, white_gc, &usecaseArcDat[j]);
	usecaseArcDat[j].start_x += dx;
	usecaseArcDat[j].start_y += dy;
	/**
	usecaseArcDat[j].str_rect.x =
	  usecase_get_m(usecaseArcDat[j].start_x, usecaseArcDat[j].end_x);
	usecaseArcDat[j].str_rect.y =
	  usecase_get_m(usecaseArcDat[j].start_y, usecaseArcDat[j].end_y);
	**/
	usecase_get_arc_str_rect(&usecaseArcDat[j]);
	usecase_draw_arc(g_usecase_pixmap, black_gc, &usecaseArcDat[j]);
      }
      if(usecaseNodeDat[i].id == usecaseArcDat[j].end_node_id){
	usecase_draw_arc(g_usecase_pixmap, white_gc, &usecaseArcDat[j]);
	usecaseArcDat[j].end_x += dx;
	usecaseArcDat[j].end_y += dy;
	/**
	usecaseArcDat[j].str_rect.x =
	  usecase_get_m(usecaseArcDat[j].start_x, usecaseArcDat[j].end_x);
	usecaseArcDat[j].str_rect.y =
	  usecase_get_m(usecaseArcDat[j].start_y, usecaseArcDat[j].end_y);
	**/
	usecase_get_arc_str_rect(&usecaseArcDat[j]);
	usecase_draw_arc(g_usecase_pixmap, black_gc, &usecaseArcDat[j]);
      }
    }
  }

  usecaseNodeDat[i].rect.x += dx;
  usecaseNodeDat[i].rect.y += dy;
  usecaseNodeDat[i].str_rect.x += dx;
  usecaseNodeDat[i].str_rect.y += dy;
  
  switch(usecaseNodeDat[i].type){
  case usecase_actor_enum:
    usecase_draw_actor(g_usecase_pixmap, black_gc, &usecaseNodeDat[i]);
    break;
  case usecase_usecase_enum:
    usecase_draw_usecase(g_usecase_pixmap, black_gc, &usecaseNodeDat[i]);
    break;
  }
  usecase_draw_selected_node(g_usecase_pixmap, black_gc, &usecaseNodeDat[i]);

  lastX = x;
  lastY = y;
}

/*
 * usecase_mod_system
 */
void usecase_mod_system(int x, int y, int i)
{
  int dx, dy;

  usecase_draw_selected_system(g_usecase_pixmap, white_gc,
			       &usecaseSystemDat[i]);
  usecase_draw_system(g_usecase_pixmap, white_gc, &usecaseSystemDat[i]);

  dx = x - lastX;
  dy = y - lastY;

  usecaseSystemDat[i].rect.x += dx;
  usecaseSystemDat[i].rect.y += dy;
  usecaseSystemDat[i].str_rect.x += dx;
  usecaseSystemDat[i].str_rect.y += dy;
  
  usecase_draw_selected_system(g_usecase_pixmap, black_gc,
			       &usecaseSystemDat[i]);

  usecase_draw_system(g_usecase_pixmap, black_gc, &usecaseSystemDat[i]);

  lastX = x;
  lastY = y;
}

/*
 * usecase_resize_system
 */
void usecase_resize_system(int x, int y, int i)
{
  int dx, dy;

  usecase_draw_selected_system(g_usecase_pixmap, white_gc,
			       &usecaseSystemDat[i]);
  usecase_draw_system(g_usecase_pixmap, white_gc, &usecaseSystemDat[i]);

  dx = x - lastX;
  dy = y - lastY;

  switch(usecaseSystemDat[i].select_mode){
  case usecase_first:
    usecaseSystemDat[i].rect.x = x;
    usecaseSystemDat[i].rect.width -= dx;
    break;
  case usecase_second:
    usecaseSystemDat[i].rect.height += dy;
    break;
  case usecase_third:
    usecaseSystemDat[i].rect.width += dx;
    break;
  case usecase_forth:
    usecaseSystemDat[i].rect.y = y;
    usecaseSystemDat[i].rect.height -= dy;
    break;
  }
  
  usecase_draw_selected_system(g_usecase_pixmap, black_gc,
			       &usecaseSystemDat[i]);

  usecase_draw_system(g_usecase_pixmap, black_gc, &usecaseSystemDat[i]);

  lastX = x;
  lastY = y;
}

/*
 * usecase_add_actor (global)
 */
void usecase_add_actor(int x, int y)
{
  int i = usecase_node_count;

  usecaseNodeDat[i].id = usecase_node_seq;

  usecaseNodeDat[i].rect.x = x;
  usecaseNodeDat[i].rect.y = y;
  usecaseNodeDat[i].rect.width = 50;
  usecaseNodeDat[i].rect.height = 90;
  usecaseNodeDat[i].type = usecase_actor_enum;
  sprintf(usecaseNodeDat[i].name, "Actor");

  usecaseNodeDat[i].select_mode = FALSE;

  usecase_get_str_rect(&usecaseNodeDat[i]);
  usecase_draw_actor(g_usecase_pixmap, black_gc, &usecaseNodeDat[i]);

  usecase_node_count++;
  usecase_node_seq++;
}

/*
 * usecase_add_usecase (global)
 */
void usecase_add_usecase(int x, int y)
{
  int i = usecase_node_count;

  usecaseNodeDat[i].id = usecase_node_seq;

  usecaseNodeDat[i].rect.x = x;
  usecaseNodeDat[i].rect.y = y;
  usecaseNodeDat[i].rect.width = 100;
  usecaseNodeDat[i].rect.height = 60;
  usecaseNodeDat[i].type = usecase_usecase_enum;
  sprintf(usecaseNodeDat[i].name, "Usecase");

  usecaseNodeDat[i].select_mode = FALSE;

  usecase_get_str_rect(&usecaseNodeDat[i]);
  usecase_draw_usecase(g_usecase_pixmap, black_gc, &usecaseNodeDat[i]);

  usecase_node_count++;
  usecase_node_seq++;
}

/*
 * usecase_add_system (global)
 */
void usecase_add_system(int x, int y)
{
  int i = usecase_system_count;

  usecaseSystemDat[i].id = usecase_node_seq;

  usecaseSystemDat[i].rect.x = x;
  usecaseSystemDat[i].rect.y = y;
  usecaseSystemDat[i].rect.width = 300;
  usecaseSystemDat[i].rect.height = 450;
  usecaseSystemDat[i].type = usecase_system_enum;
  sprintf(usecaseSystemDat[i].name, "System");

  usecaseSystemDat[i].select_mode = usecase_false;

  usecase_draw_system(g_usecase_pixmap, black_gc, &usecaseSystemDat[i]);

  usecase_system_count++;
  usecase_system_seq++;
}

/*
 * usecase_copy_node (local)
 */
void usecase_copy_node(int dst, int src)
{
  usecaseNodeDat[dst].id = usecaseNodeDat[src].id;
  sprintf(usecaseNodeDat[dst].name, "%s", usecaseNodeDat[src].name);
  
  usecaseNodeDat[dst].rect.x = usecaseNodeDat[src].rect.x;
  usecaseNodeDat[dst].rect.y = usecaseNodeDat[src].rect.y;
  usecaseNodeDat[dst].rect.width = usecaseNodeDat[src].rect.width;
  usecaseNodeDat[dst].rect.height = usecaseNodeDat[src].rect.height;

  usecaseNodeDat[dst].str_rect.x = usecaseNodeDat[src].str_rect.x;
  usecaseNodeDat[dst].str_rect.y = usecaseNodeDat[src].str_rect.y;
  usecaseNodeDat[dst].str_rect.width = usecaseNodeDat[src].str_rect.width;
  usecaseNodeDat[dst].str_rect.height = usecaseNodeDat[src].str_rect.height;

  usecaseNodeDat[dst].type = usecaseNodeDat[src].type;
  usecaseNodeDat[dst].select_mode = usecaseNodeDat[src].select_mode;
}

/*
 * usecase_copy_system
 */
void usecase_copy_system(int dst, int src)
{
  sprintf(usecaseSystemDat[dst].name, "%s", usecaseSystemDat[src].name);
  
  usecaseSystemDat[dst].id              = usecaseSystemDat[src].id;

  usecaseSystemDat[dst].rect.x          = usecaseSystemDat[src].rect.x;
  usecaseSystemDat[dst].rect.y          = usecaseSystemDat[src].rect.y;
  usecaseSystemDat[dst].rect.width      = usecaseSystemDat[src].rect.width;
  usecaseSystemDat[dst].rect.height     = usecaseSystemDat[src].rect.height;

  usecaseSystemDat[dst].str_rect.x      = usecaseSystemDat[src].str_rect.x;
  usecaseSystemDat[dst].str_rect.y      = usecaseSystemDat[src].str_rect.y;
  usecaseSystemDat[dst].str_rect.width  = usecaseSystemDat[src].str_rect.width;
  usecaseSystemDat[dst].str_rect.height = usecaseSystemDat[src].str_rect.height;

  usecaseSystemDat[dst].type            = usecaseSystemDat[src].type;
  usecaseSystemDat[dst].select_mode     = usecaseSystemDat[src].select_mode;
}

/*
 * usecase_get_str_rect (global)
 */
void usecase_get_str_rect(UsecaseNodeStruct *n_ptr)
{
  int x,y,w,h;

  w = gdk_string_width(g_font, n_ptr->name);
  h = gdk_string_height(g_font, n_ptr->name);

  x = n_ptr->rect.x + (n_ptr->rect.width/2 - w/2);

  switch(n_ptr->type){
  case usecase_actor_enum:
    y = n_ptr->rect.y + n_ptr->rect.height;
    break;
  case usecase_usecase_enum:
    y = n_ptr->rect.y + n_ptr->rect.height/2 + 5;
    break;
  }
    
  n_ptr->str_rect.x = x;
  n_ptr->str_rect.y = y;
  n_ptr->str_rect.width = w;
  n_ptr->str_rect.height = h;
}

/*
 * usecase_get_arc_str_rect (global)
 */
void usecase_get_arc_str_rect(UsecaseArcStruct *a_ptr)
{
  int mx,my;
  int sw,sh;

  sw = gdk_string_width(g_font, a_ptr->name);
  sh = gdk_string_height(g_font, a_ptr->name);

  /**
  mx = (a_ptr->start_x + a_ptr->end_x) / 2;
  my = (a_ptr->start_y + a_ptr->end_y) / 2;
  **/
  mx = usecase_get_m(a_ptr->start_x, a_ptr->end_x);
  my = usecase_get_m(a_ptr->start_y, a_ptr->end_y);

  a_ptr->str_rect.x = mx - sw / 2;
  a_ptr->str_rect.y = my - sh;
  a_ptr->str_rect.width = sw;
  a_ptr->str_rect.height = sh;
}

/*
 * usecase_add_arc_start (global)
 */
void usecase_add_arc_start(int x, int y)
{
  int i, j, k;

  usecase_arc_start_node = 9999;
  j = usecase_arc_count;

  for(i=0; i<usecase_node_count; i++){
    if(usecase_selection_judge_node(&usecaseNodeDat[i], x, y)) {
      usecase_arc_start_node = i;
      usecaseArcDat[j].id = usecase_arc_seq;

      sprintf(usecaseArcDat[j].name,"");

      usecaseArcDat[j].start_node_id = usecaseNodeDat[i].id;
      usecaseArcDat[j].start_x = usecase_get_node_mx(&usecaseNodeDat[i]);
      usecaseArcDat[j].start_y = usecase_get_node_my(&usecaseNodeDat[i]);

      return;
    }
  }
}

/*
 * usecase_add_arc_end (global)
 */
void usecase_add_arc_end(int x, int y)
{
  int i, j, k, l, m, n;

  if(usecase_arc_start_node == 9999)
    return;

  j = usecase_arc_count;
  k = usecase_arc_start_node;

  for(i=0; i<usecase_node_count; i++){
    if(usecase_selection_judge_node(&usecaseNodeDat[i], x, y)) {
      if(k == i){
	g_print("Cannot Create Arc for own node\n");
	return;
      }
      for(m=0; m<usecase_arc_count; m++){
	if((usecaseArcDat[m].start_node_id == usecaseNodeDat[k].id &&
	    usecaseArcDat[m].end_node_id == usecaseNodeDat[i].id)){
	  g_print("already exist\n");
	  return;
	}else if((usecaseArcDat[m].end_node_id == usecaseNodeDat[k].id &&
		  usecaseArcDat[m].start_node_id == usecaseNodeDat[i].id)) {
	  g_print("already exist (reverse arc)\n");
	  return;
	}
      }

      usecaseArcDat[j].select_mode = FALSE;

      usecaseArcDat[j].end_node_id = usecaseNodeDat[i].id;
      usecaseArcDat[j].end_x = usecase_get_node_mx(&usecaseNodeDat[i]);
      usecaseArcDat[j].end_y = usecase_get_node_my(&usecaseNodeDat[i]);

      usecase_get_arc_str_rect(&usecaseArcDat[j]);

      usecase_arc_count++;
      usecase_arc_seq++;

      usecase_draw_arc(g_usecase_pixmap, black_gc, &usecaseArcDat[j]);
      usecase_draw_white_node(g_usecase_pixmap, &usecaseNodeDat[k]);
      usecase_draw_white_node(g_usecase_pixmap, &usecaseNodeDat[i]);
      usecase_draw_node(g_usecase_pixmap, black_gc, &usecaseNodeDat[k]);
      usecase_draw_node(g_usecase_pixmap, black_gc, &usecaseNodeDat[i]);

      return;
    }
  }
}

/*
 * usecase_copy_arc (local)
 */
void usecase_copy_arc(int dst, int src)
{
  usecaseArcDat[dst].id = usecaseArcDat[src].id;
  sprintf(usecaseArcDat[dst].name, "%s", usecaseArcDat[src].name);
  
  usecaseArcDat[dst].str_rect.x = usecaseArcDat[src].str_rect.x;
  usecaseArcDat[dst].str_rect.y = usecaseArcDat[src].str_rect.y;
  usecaseArcDat[dst].str_rect.width = usecaseArcDat[src].str_rect.width;
  usecaseArcDat[dst].str_rect.height = usecaseArcDat[src].str_rect.height;

  usecaseArcDat[dst].start_x = usecaseArcDat[src].start_x;
  usecaseArcDat[dst].start_y = usecaseArcDat[src].start_y;
  usecaseArcDat[dst].start_node_id = usecaseArcDat[src].start_node_id;
  
  usecaseArcDat[dst].end_x = usecaseArcDat[src].end_x;
  usecaseArcDat[dst].end_y = usecaseArcDat[src].end_y;
  usecaseArcDat[dst].end_node_id = usecaseArcDat[src].end_node_id;

  usecaseArcDat[dst].select_mode = usecaseArcDat[src].select_mode;
}

/*
 * usecase_delete_arc (global)
 */
void usecase_delete_arc()
{
  int i,j,m;
  j = usecase_arc_count-1;

  i = 9999;
  for(m=0; m<usecase_arc_count; m++){
    if(usecaseArcDat[m].select_mode == TRUE)
      i = m;
  }

  if(i == 9999) {
    //g_print("No Arc Selected\n");
    return;
  }

  usecase_draw_arc(g_usecase_pixmap, erase_gc, &usecaseArcDat[i]);

  if(i < j)
    usecase_copy_arc(i, j);

  usecase_last_selected_arc == 9999;
  usecase_arc_count--;
}

/*
 * usecase_delete_node (global)
 */
void usecase_delete_node()
{
  int i,j,m;
  j = usecase_node_count-1;

  i = 9999;
  for(m=0; m<usecase_node_count; m++){
    if(usecaseNodeDat[m].select_mode == TRUE)
      i = m;
  }

  if(i == 9999) {
    //g_print("No Node selected\n");
    return;
  }

  {
    int o, q;

    q = usecase_arc_count-1;
    for(o=q; o>=0; o--){
      if(usecaseArcDat[o].start_node_id == usecaseNodeDat[i].id ||
	 usecaseArcDat[o].end_node_id == usecaseNodeDat[i].id){
	usecaseArcDat[o].select_mode = TRUE;
	usecase_delete_arc();
      }
    }

  }

  usecase_draw_node(g_usecase_pixmap, white_gc, &usecaseNodeDat[i]);
  usecase_draw_selected_node(g_usecase_pixmap, white_gc, &usecaseNodeDat[i]);

  if(i < j)
    usecase_copy_node(i, j);

  usecase_selected_node == 9999;
  usecase_last_selected_node == 9999;
  usecase_node_count--;
}  

/*
 * usecase_delete_system
 */
gboolean usecase_delete_system()
{
  int i,j,m;
  j = usecase_system_count-1;

  i = 9999;
  for(m=0; m<usecase_system_count; m++){
    if(usecaseSystemDat[m].select_mode == usecase_select)
      i = m;
  }

  if(i == 9999) {
    //g_print("No Node selected\n");
    return FALSE;
  }

  usecase_draw_system(g_usecase_pixmap, white_gc, &usecaseSystemDat[i]);
  usecase_draw_selected_system(g_usecase_pixmap, white_gc, &usecaseSystemDat[i]);

  if(i < j)
    usecase_copy_system(i, j);

  usecase_selected_system == 9999;
  usecase_last_selected_system == 9999;
  usecase_system_count--;

  return TRUE;
}  

/*
 * usecase_select_init_node
 */
void usecase_select_init_node()
{
  int i;

  for(i=0; i<USECASE_MAX_NODE; i++)
    usecaseNodeDat[i].select_mode = FALSE;
}

/*
 * usecase_select_init_arc
 */
void usecase_select_init_arc()
{
  int i;

  for(i=0; i<USECASE_MAX_ARC; i++)
    usecaseArcDat[i].select_mode = FALSE;
}

/*
 * usecase_select_init_system
 */
void usecase_select_init_system()
{
  int i;

  for(i=0; i<USECASE_MAX_SYSTEM; i++)
    usecaseSystemDat[i].select_mode = usecase_false;
}
