/*
 * usecase_dialog.c
 */
#include <gtk/gtk.h>

#include "def_tenko.h"
#include "usecase_edit.h"
#include "usecase_dialog.h"
#include "usecase_draw.h"

extern UsecaseNodeStruct usecaseNodeDat[USECASE_MAX_NODE];
extern UsecaseArcStruct usecaseArcDat[USECASE_MAX_ARC];

extern GdkPixmap *g_usecase_pixmap;
extern GtkWidget *g_usecase_canvas;

extern GdkGC *black_gc;

ActorDialog *at;
UsecaseDialog *uc;
ArcDialog *ac;

gchar *g_usecase_filename;

/////////////////////// actor dialog ///////////////////////////////////////
/*
 * usecase_actor_dialog_destroy (local)
 */
void usecase_actor_dialog_destroy(GtkWidget *widget)
{
  g_free(at);
}

/*
 * usecase_actor_dialog_apply_button (local)
 */
void usecase_actor_dialog_apply_button(GtkWidget *widget, int *i)
{
  gchar *str;

  str = gtk_entry_get_text((GtkEntry*)at->entry);

  sprintf(usecaseNodeDat[*i].name, "%s", str);

  usecase_draw_white_node(g_usecase_pixmap, &usecaseNodeDat[*i]);
  gtk_widget_draw(g_usecase_canvas, &usecaseNodeDat[*i].str_rect);

  usecase_get_str_rect(&usecaseNodeDat[*i]);

  usecase_draw_node(g_usecase_pixmap, black_gc, &usecaseNodeDat[*i]);

  gtk_widget_draw(g_usecase_canvas, &usecaseNodeDat[*i].str_rect);
  gtk_widget_draw(g_usecase_canvas, &usecaseNodeDat[*i].rect);
}
  
/*
 * usecase_actor_dialog_close_button (local)
 */
void usecase_actor_dialog_close_button(GtkWidget *widget)
{
  gtk_widget_hide(at->window);

  g_free(at);
}
  
/*
 * usecase_actor_dialog_ok_button (local)
 */
void usecase_actor_dialog_ok_button(GtkWidget *widget, int *i)
{
  usecase_actor_dialog_apply_button(widget, i);
  usecase_actor_dialog_close_button(widget);
}
  
/*
 * usecase_actor_dialog_new (local)
 */
ActorDialog* usecase_actor_dialog_new()
{
  ActorDialog *at = g_new(ActorDialog, 1);

  at->window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_modal((GtkWindow*)at->window, TRUE);
  gtk_container_border_width (GTK_CONTAINER (at->window), 10);

  gtk_signal_connect(GTK_OBJECT(at->window), "destroy",
		     (GtkSignalFunc)usecase_actor_dialog_destroy, NULL);
  
  gtk_widget_show (at->window);

  at->vbox = gtk_vbox_new(FALSE, 5);
  at->hbox = gtk_hbox_new(FALSE, 5);
  at->hbox2 = gtk_hbox_new(FALSE, 5);

  gtk_container_set_border_width (GTK_CONTAINER (at->hbox), 10);

  at->entry = gtk_entry_new();
  gtk_entry_set_max_length(GTK_ENTRY(at->entry), 20);  

  gtk_box_pack_start (GTK_BOX (at->hbox), at->entry, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (at->vbox), at->hbox, FALSE, TRUE, 0);

  at->ok_button = gtk_button_new_with_label ("OK");
  gtk_box_pack_start (GTK_BOX (at->hbox2), at->ok_button, FALSE, TRUE, 0);
		      
  at->apply_button = gtk_button_new_with_label ("Apply");
  gtk_box_pack_start (GTK_BOX (at->hbox2), at->apply_button, FALSE, TRUE, 0);
		      
  at->close_button = gtk_button_new_with_label ("Close");
  gtk_box_pack_start (GTK_BOX (at->hbox2), at->close_button, FALSE, TRUE, 0);

  gtk_box_pack_start (GTK_BOX (at->vbox), at->hbox2, FALSE, TRUE, 0);
  gtk_container_add (GTK_CONTAINER (at->window), at->vbox);

  gtk_widget_show_all (at->vbox);

  return at;
}

/*
 * usecase_open_actor_dialog (global)
 */
void usecase_open_actor_dialog(int i)
{
  at = usecase_actor_dialog_new();

  gtk_entry_set_text((GtkEntry*)at->entry, usecaseNodeDat[i].name);

  gtk_signal_connect (GTK_OBJECT (at->ok_button), "clicked",
		      GTK_SIGNAL_FUNC (usecase_actor_dialog_ok_button),
		      (gpointer)&i);

  gtk_signal_connect (GTK_OBJECT (at->apply_button), "clicked",
		      GTK_SIGNAL_FUNC (usecase_actor_dialog_apply_button),
		      (gpointer)&i);

  gtk_signal_connect (GTK_OBJECT (at->close_button), "clicked",
		      GTK_SIGNAL_FUNC (usecase_actor_dialog_close_button),
		      NULL);

  gtk_main();
}

/////////////////////// usecase dialog ///////////////////////////////////////
/*
 * usecase_usecase_dialog_destroy (local)
 */
void usecase_usecase_dialog_destroy(GtkWidget *widget)
{
  g_free(uc);
}

/*
 * usecase_usecase_dialog_apply_button (local)
 */
void usecase_usecase_dialog_apply_button(GtkWidget *widget, int *i)
{
  gchar *str;

  str = gtk_entry_get_text((GtkEntry*)uc->entry);

  sprintf(usecaseNodeDat[*i].name, "%s", str);

  usecase_draw_white_node(g_usecase_pixmap, &usecaseNodeDat[*i]);
  gtk_widget_draw(g_usecase_canvas, &usecaseNodeDat[*i].str_rect);

  usecase_get_str_rect(&usecaseNodeDat[*i]);

  usecase_draw_node(g_usecase_pixmap, black_gc, &usecaseNodeDat[*i]);

  gtk_widget_draw(g_usecase_canvas, &usecaseNodeDat[*i].str_rect);
  gtk_widget_draw(g_usecase_canvas, &usecaseNodeDat[*i].rect);
}
  
/*
 * usecase_usecase_dialog_close_button (local)
 */
void usecase_usecase_dialog_close_button(GtkWidget *widget)
{
  gtk_widget_hide(uc->window);

  g_free(uc);
}
  
/*
 * usecase_usecase_dialog_ok_button (local)
 */
void usecase_usecase_dialog_ok_button(GtkWidget *widget, int *i)
{
  usecase_usecase_dialog_apply_button(widget, i);
  usecase_usecase_dialog_close_button(widget);
}
  
/*
 * usecase_usecase_dialog_new (local)
 */
UsecaseDialog* usecase_usecase_dialog_new()
{
  UsecaseDialog *uc = g_new(UsecaseDialog, 1);

  uc->window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_modal((GtkWindow*)uc->window, TRUE);
  gtk_container_border_width (GTK_CONTAINER (uc->window), 10);

  gtk_signal_connect(GTK_OBJECT(uc->window), "destroy",
		     (GtkSignalFunc)usecase_usecase_dialog_destroy, NULL);
  
  gtk_widget_show (uc->window);

  uc->vbox = gtk_vbox_new(FALSE, 5);
  uc->hbox = gtk_hbox_new(FALSE, 5);
  uc->hbox2 = gtk_hbox_new(FALSE, 5);

  gtk_container_set_border_width (GTK_CONTAINER (uc->hbox), 10);

  uc->entry = gtk_entry_new();
  gtk_entry_set_max_length(GTK_ENTRY(uc->entry), 20);  

  gtk_box_pack_start (GTK_BOX (uc->hbox), uc->entry, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (uc->vbox), uc->hbox, FALSE, TRUE, 0);

  uc->ok_button = gtk_button_new_with_label ("OK");
  gtk_box_pack_start (GTK_BOX (uc->hbox2), uc->ok_button, FALSE, TRUE, 0);
		      
  uc->apply_button = gtk_button_new_with_label ("Apply");
  gtk_box_pack_start (GTK_BOX (uc->hbox2), uc->apply_button, FALSE, TRUE, 0);
		      
  uc->close_button = gtk_button_new_with_label ("Close");
  gtk_box_pack_start (GTK_BOX (uc->hbox2), uc->close_button, FALSE, TRUE, 0);

  gtk_box_pack_start (GTK_BOX (uc->vbox), uc->hbox2, FALSE, TRUE, 0);
  gtk_container_add (GTK_CONTAINER (uc->window), uc->vbox);

  gtk_widget_show_all (uc->vbox);

  return uc;
}

/*
 * usecase_open_usecase_dialog (global)
 */
void usecase_open_usecase_dialog(int i)
{
  uc = usecase_usecase_dialog_new();

  gtk_entry_set_text((GtkEntry*)uc->entry, usecaseNodeDat[i].name);

  gtk_signal_connect (GTK_OBJECT (uc->ok_button), "clicked",
		      GTK_SIGNAL_FUNC (usecase_usecase_dialog_ok_button),
		      (gpointer)&i);

  gtk_signal_connect (GTK_OBJECT (uc->apply_button), "clicked",
		      GTK_SIGNAL_FUNC (usecase_usecase_dialog_apply_button),
		      (gpointer)&i);

  gtk_signal_connect (GTK_OBJECT (uc->close_button), "clicked",
		      GTK_SIGNAL_FUNC (usecase_usecase_dialog_close_button),
		      NULL);

  gtk_main();
}

/////////////////////////// arc dialog ///////////////////////////////////////
/*
 * usecase_arc_dialog_destroy (local)
 */
void usecase_arc_dialog_destroy(GtkWidget *widget)
{
  g_free(ac);
}

/*
 * usecase_arc_dialog_apply_button (local)
 */
void usecase_arc_dialog_apply_button(GtkWidget *widget, int *i)
{
  gchar *str;
  GdkRectangle update_rect;

  str = gtk_entry_get_text((GtkEntry*)ac->entry);

  sprintf(usecaseArcDat[*i].name, "%s", str);

  usecase_get_arc_str_rect(&usecaseArcDat[*i]);

  usecase_draw_arc(g_usecase_pixmap, black_gc, &usecaseArcDat[*i]);

  update_rect.x = 0;
  update_rect.y = 0;
  update_rect.width = USECASE_PICTURE_WIDTH;
  update_rect.height = USECASE_PICTURE_HEIGHT;

  gtk_widget_draw(g_usecase_canvas, &update_rect);
}
  
/*
 * usecase_arc_dialog_close_button (local)
 */
void usecase_arc_dialog_close_button(GtkWidget *widget)
{
  gtk_widget_hide(ac->window);

  g_free(ac);
}
  
/*
 * usecase_arc_dialog_ok_button (local)
 */
void usecase_arc_dialog_ok_button(GtkWidget *widget, int *i)
{
  usecase_arc_dialog_apply_button(widget, i);
  usecase_arc_dialog_close_button(widget);
}
  
/*
 * usecase_arc_dialog_new (local)
 */
ArcDialog* usecase_arc_dialog_new()
{
  ArcDialog *ac = g_new(ArcDialog, 1);

  ac->window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_modal((GtkWindow*)ac->window, TRUE);
  gtk_container_border_width (GTK_CONTAINER (ac->window), 10);

  gtk_signal_connect(GTK_OBJECT(ac->window), "destroy",
		     (GtkSignalFunc)usecase_arc_dialog_destroy, NULL);
  
  gtk_widget_show (ac->window);

  ac->vbox = gtk_vbox_new(FALSE, 5);
  ac->hbox = gtk_hbox_new(FALSE, 5);
  ac->hbox2 = gtk_hbox_new(FALSE, 5);

  gtk_container_set_border_width (GTK_CONTAINER (ac->hbox), 10);

  ac->entry = gtk_entry_new();
  gtk_entry_set_max_length(GTK_ENTRY(ac->entry), 20);  

  gtk_box_pack_start (GTK_BOX (ac->hbox), ac->entry, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (ac->vbox), ac->hbox, FALSE, TRUE, 0);

  ac->ok_button = gtk_button_new_with_label ("OK");
  gtk_box_pack_start (GTK_BOX (ac->hbox2), ac->ok_button, FALSE, TRUE, 0);
		      
  ac->apply_button = gtk_button_new_with_label ("Apply");
  gtk_box_pack_start (GTK_BOX (ac->hbox2), ac->apply_button, FALSE, TRUE, 0);
		      
  ac->close_button = gtk_button_new_with_label ("Close");
  gtk_box_pack_start (GTK_BOX (ac->hbox2), ac->close_button, FALSE, TRUE, 0);

  gtk_box_pack_start (GTK_BOX (ac->vbox), ac->hbox2, FALSE, TRUE, 0);
  gtk_container_add (GTK_CONTAINER (ac->window), ac->vbox);

  gtk_widget_show_all (ac->vbox);

  return ac;
}

/*
 * usecase_open_arc_dialog (global)
 */
void usecase_open_arc_dialog(int i)
{
  ac = usecase_arc_dialog_new();

  gtk_entry_set_text((GtkEntry*)ac->entry, usecaseArcDat[i].name);

  gtk_signal_connect (GTK_OBJECT (ac->ok_button), "clicked",
		      GTK_SIGNAL_FUNC (usecase_arc_dialog_ok_button),
		      (gpointer)&i);

  gtk_signal_connect (GTK_OBJECT (ac->apply_button), "clicked",
		      GTK_SIGNAL_FUNC (usecase_arc_dialog_apply_button),
		      (gpointer)&i);

  gtk_signal_connect (GTK_OBJECT (ac->close_button), "clicked",
		      GTK_SIGNAL_FUNC (usecase_arc_dialog_close_button),
		      NULL);

  gtk_main();
}

////////////////////////// file selection dialog /////////////////////////////
/*
 * usecase_file_selection_ok_button
 */
void usecase_file_selection_ok_button(GtkWidget *w, GtkFileSelection *fs)
{
  if(g_usecase_filename)
    free(g_usecase_filename);

  g_usecase_filename =
    (gchar*)strdup(gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs)));

  gtk_widget_destroy(GTK_WIDGET(fs));

  gtk_main_quit();
}

/*
 * usecase_open_file_selection_dialog
 */
void usecase_open_file_selection_dialog()
{
  GtkWidget *fd;

  fd = gtk_file_selection_new(NULL);

  gtk_signal_connect(GTK_OBJECT(fd), "destroy",
		     (GtkSignalFunc)gtk_widget_destroy, fd);

  gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(fd)->ok_button), "clicked",
		     (GtkSignalFunc)usecase_file_selection_ok_button,
		     fd);

  gtk_signal_connect_object(GTK_OBJECT(GTK_FILE_SELECTION(fd)->cancel_button),
			    "clicked",
			    (GtkSignalFunc)gtk_widget_destroy,
			    GTK_OBJECT(fd));

  gtk_file_selection_set_filename(GTK_FILE_SELECTION(fd), "newfile.uc");

  gtk_widget_show(fd);

  gtk_window_set_modal((GtkWindow*)fd, TRUE);

  gtk_main();
}
