/*
 * usecase_commands.c
 */
#include <stdio.h>

#include <gtk/gtk.h>

#include "def_tenko.h"
#include "usecase.h"
#include "usecase_dialog.h"
#include "usecase_commands.h"
#include "usecase_draw.h"
#include "usecase_util.h"
#include "usecase_io.h"

extern UsecaseNodeStruct usecaseNodeDat[USECASE_MAX_NODE];

extern GdkPixmap *g_usecase_pixmap;
extern GtkWidget *g_usecase_canvas;

extern int usecase_node_count;
extern int usecase_last_selected_arc;

extern gchar *g_usecase_filename;

//////////////////////// file menu commands //////////////////////////////////
/*
 * usecase_new_file
 */
void usecase_new_file()
{
  GdkRectangle update_rect;

  if(g_usecase_filename) {
    g_free(g_usecase_filename);
    g_usecase_filename = NULL;
  }

  usecase_init_counters();
  usecase_init_nodes();
  usecase_init_systems();
  usecase_init_arcs();

  update_rect.x = 0;
  update_rect.y = 0;
  update_rect.width = USECASE_PICTURE_WIDTH;
  update_rect.height = USECASE_PICTURE_HEIGHT;

  usecase_draw_canvas_init();
  gtk_widget_draw(g_usecase_canvas, &update_rect);
}

/*
 * usecase_load_file
 */
void usecase_load_file()
{
  GdkRectangle update_rect;

  if(g_usecase_filename) {
    g_free(g_usecase_filename);
    g_usecase_filename = NULL;
  }

  usecase_open_file_selection_dialog();

  if(!g_usecase_filename){
    g_print("Cannot get filename\n");
    return;
  }

  usecase_init_counters();
  usecase_init_nodes();
  usecase_init_systems();
  usecase_init_arcs();

  if(!usecase_load()){
    g_print("Cannot load file\n");
    return;
  }

  update_rect.x = 0;
  update_rect.y = 0;
  update_rect.width = USECASE_PICTURE_WIDTH;
  update_rect.height = USECASE_PICTURE_HEIGHT;

  usecase_draw_canvas_init();
  usecase_draw_refresh_all();
  gtk_widget_draw(g_usecase_canvas, &update_rect);
}

/*
 * usecase_save_file
 */
void usecase_save_file()
{
  if(!g_usecase_filename)
    usecase_open_file_selection_dialog();

  if(!g_usecase_filename){
    g_print("Cannot get filename\n");
    return;
  }

  usecase_save();
}

/*
 * usecase_save_file_as
 */
void usecase_save_file_as()
{
  usecase_open_file_selection_dialog();

  if(!g_usecase_filename){
    g_print("Cannot get filename\n");
    return;
  }

  usecase_save();
}

/*
 * usecase_export_file
void usecase_export_file()
{
  g_print("usecase_export_file\n"); //debug
}
 */

/*
 * usecase_export_jpg
 */
void usecase_export_jpg()
{
  if(!g_usecase_filename){
    g_print("Cannot get filename\n");
    return;
  }

  usecase_export(JPG);
}

/*
 * usecase_export_png
 */
void usecase_export_png()
{
  if(!g_usecase_filename){
    g_print("Cannot get filename\n");
    return;
  }

  usecase_export(PNG);
}

/*
 * usecase_export_eps
 */
void usecase_export_eps()
{
  if(!g_usecase_filename){
    g_print("Cannot get filename\n");
    return;
  }

  usecase_export(EPS);
}

/*
 * usecase_quit
 */
void usecase_quit()
{
  gtk_exit(0);
}

//////////////////////// edit menu commands //////////////////////////////////
/*
 * usecase_delete_element
 */
void usecase_delete_element()
{
  GdkRectangle update_rect;

  if(usecase_delete_system()) {
    update_rect.x = 0;
    update_rect.y = 0;
    update_rect.width = USECASE_PICTURE_WIDTH;
    update_rect.height = USECASE_PICTURE_HEIGHT;

    gtk_widget_draw(g_usecase_canvas, &update_rect);

    return;
  }

  usecase_delete_arc();
  usecase_delete_node();

  update_rect.x = 0;
  update_rect.y = 0;
  update_rect.width = USECASE_PICTURE_WIDTH;
  update_rect.height = USECASE_PICTURE_HEIGHT;

  gtk_widget_draw(g_usecase_canvas, &update_rect);
}

/////////////////////////// display menu commands /////////////////////////////
/*
 * usecase_display_refresh
 */
void usecase_display_refresh()
{
  GdkRectangle update_rect;

  update_rect.x = 0;
  update_rect.y = 0;
  update_rect.width = USECASE_PICTURE_WIDTH;
  update_rect.height = USECASE_PICTURE_HEIGHT;

  usecase_draw_canvas_init();
  usecase_draw_refresh_all();
  gtk_widget_draw(g_usecase_canvas, &update_rect);
}
