/* cdedit2 -- class diagram creation/manipulation program
 * Copyright (C) 2001 Touge Kamisimo
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include <math.h>
#include "cd_define.h"
#include "cd_util.h"
#include "cd_canvas.h"

/*
 * cd_util_init
 */
void cd_util_init()
{
  cd_node_init();
  cd_arc_init();
}

/*
 * cd_util_select_rect
 */
gboolean cd_util_select_rect(GdkRectangle *rect, int x, int y)
{
  int x1, x2, y1, y2;
  
  x1 = rect->x;
  x2 = x1 + rect->width;
  y1 = rect->y;
  y2 = y1 + rect->height;

  if( x1<x && x<x2 && y1<y && y<y2 )
    return TRUE;

  return FALSE;
}

/*
 * cd_util_select_line
 */
gboolean cd_util_select_line(GdkPoint *start, GdkPoint *end, int x, int y)
{
  double arc_x, arc_y, arc_theta;
  double cursor_x, cursor_y, cursor_theta;
  
  arc_x = start->x - end->x;
  arc_y = start->y - end->y;
  arc_theta = atan2(arc_x, arc_y);

  cursor_x = start->x - x;
  cursor_y = start->y - y;
  cursor_theta = atan2(cursor_x, cursor_y);

  if((int)((arc_theta*100)-2) < (int)(cursor_theta*100) &&
     (int)(cursor_theta*100) < (int)((arc_theta*100)+2)){

    if(start->x <= x && x <= end->x && start->y <= y && y <= end->y)
      return TRUE;
    else if(end->x <= x && x <= start->x && end->y <= y && y <= start->y)
      return TRUE;
    else if(start->x <= x && x <= end->x && end->y <= y && y <= start->y)
      return TRUE;
    else if(end->x <= x && x <= start->x && start->y <= y && y <= end->y)
      return TRUE;
  }

  return FALSE;
}

/*
 * cd_util_get_theta
 */
double cd_util_get_theta(double x1, double y1, double x2, double y2)
{
  double x = x1 - x2;
  double y = y1 - y2;

  return atan2(x, y);
}

/*
 * cd_util_get_rect_corner
 */
void cd_util_get_rect_corner(GdkRectangle *rect, RectCorner *cn)
{
  cn->p1.x = rect->x;
  cn->p1.y = rect->y;

  cn->p2.x = rect->x;
  cn->p2.y = rect->y + rect->height;

  cn->p3.x = rect->x + rect->width;
  cn->p3.y = rect->y + rect->height;

  cn->p4.x = rect->x + rect->width;
  cn->p4.y = rect->y;
}

/*
 * cd_util_rotate
 */
void cd_util_rotate(Matrix mx, double theta)
{
  double cos_theta = cos(theta);
  double sin_theta = sin(theta);

  mx[1][0] -= mx[0][0];
  mx[1][1] -= mx[0][1];

  mx[2][0] = cos_theta * mx[1][0] - sin_theta * mx[1][1] + mx[0][0];
    
  mx[2][1] = sin_theta * mx[1][0] + cos_theta * mx[1][1] + mx[0][1];
    
  mx[1][0] += mx[0][0];
  mx[1][1] += mx[0][1];
}

/*
 * cd_util_load_hear
 */
int cd_util_load_header(FILE *fp)
{
  char line[BUFSIZ];

  fgets(line, BUFSIZ, fp);
  if(strcmp(line, CD_IO_AU)){
    printf(CD_IO_MESSAGE3);
    return FALSE;
  }
  fgets(line, BUFSIZ, fp);
  if(strcmp(line, CD_IO_HD)){
    printf(CD_IO_MESSAGE3);
    return FALSE;
  }
  fgets(line, BUFSIZ, fp);
  if(strcmp(line, CD_IO_AU)){
    printf(CD_IO_MESSAGE3);
    return FALSE;
  }

  return TRUE;
}
  

/*
 * cd_util_save_header
 */
void cd_util_save_header(FILE *fp)
{
  fprintf(fp, CD_IO_AU);
  fprintf(fp, CD_IO_HD);
  fprintf(fp, CD_IO_AU);
}	  
