/* cdedit2 -- class diagram creation/manipulation program
 * Copyright (C) 2001 Touge Kamisimo
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include "cd_define.h"
#include "cd_tool_set_dialog.h"

/*
 * cd_tool_set_dialog_apply
 */
void cd_tool_set_dialog_apply(GtkWidget *widget, ToolSetDialog *tsd)
{
  int width, height;

  width = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(tsd->spin_width));
  height = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(tsd->spin_height));

  cd_canvas_set_size(width, height);
}

/*
 * cd_tool_set_dialog_reset
 */
void cd_tool_set_dialog_reset(GtkWidget *widget, ToolSetDialog *tsd)
{
  gfloat width, height;

  width = CD_CANVAS_WIDTH_DEFAULT;
  height = CD_CANVAS_HEIGHT_DEFAULT;

  gtk_spin_button_set_value(GTK_SPIN_BUTTON(tsd->spin_width), width);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(tsd->spin_height), height);
}

/*
 * cd_tool_set_dialog_max
 */
void cd_tool_set_dialog_max(GtkWidget *widget, ToolSetDialog *tsd)
{
  gfloat width, height;

  width = CD_CANVAS_WIDTH_MAX;
  height = CD_CANVAS_HEIGHT_MAX;

  gtk_spin_button_set_value(GTK_SPIN_BUTTON(tsd->spin_width), width);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(tsd->spin_height), height);
}

/*
 * cd_tool_set_dialog_min
 */
void cd_tool_set_dialog_min(GtkWidget *widget, ToolSetDialog *tsd)
{
  gfloat width, height;

  width = CD_CANVAS_WIDTH_MIN;
  height = CD_CANVAS_HEIGHT_MIN;

  gtk_spin_button_set_value(GTK_SPIN_BUTTON(tsd->spin_width), width);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(tsd->spin_height), height);
}

/*
 * cd_tool_set_dialog_close
 */
void cd_tool_set_dialog_close(GtkWidget *widget, ToolSetDialog *tsd)
{
  gtk_widget_destroy(tsd->window);
}

/*
 * cd_tool_set_dialog_ok
 */
void cd_tool_set_dialog_ok(GtkWidget *widget, ToolSetDialog *tsd)
{
  cd_tool_set_dialog_apply(widget, tsd);
  cd_tool_set_dialog_close(widget, tsd);
}

/*
 * cd_tool_set_dialog_entrys_new
 */
void cd_tool_set_dialog_entrys_new(ToolSetDialog *tsd)
{
  int width, height;
  GtkAdjustment *adj_width, *adj_height;

  cd_canvas_get_size(&width, &height);

  tsd->hbox1 = gtk_hbox_new(FALSE, 5);
  tsd->label_width = gtk_label_new (CD_WIDTH_LABEL);
  gtk_box_pack_start(GTK_BOX (tsd->hbox1), tsd->label_width, TRUE, TRUE, 0);

  adj_width = (GtkAdjustment *) gtk_adjustment_new (width,
						    CD_CANVAS_WIDTH_MIN,
						    CD_CANVAS_WIDTH_MAX,
						    CD_CANVAS_WIDTH_STEP,
						    5.0, 0.0);
  tsd->spin_width = gtk_spin_button_new (adj_width, 0, 0);
  gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (tsd->spin_width), TRUE);
  gtk_spin_button_set_shadow_type (GTK_SPIN_BUTTON (tsd->spin_width),
				   GTK_SHADOW_ETCHED_IN);
  gtk_box_pack_start(GTK_BOX (tsd->hbox1), tsd->spin_width, TRUE, TRUE, 0);

  gtk_box_pack_start(GTK_BOX (tsd->vbox),  tsd->hbox1, FALSE, TRUE, 0);

  tsd->hbox2 = gtk_hbox_new(FALSE, 5);
  tsd->label_height = gtk_label_new (CD_HEIGHT_LABEL);
  gtk_box_pack_start(GTK_BOX (tsd->hbox2), tsd->label_height, TRUE, TRUE, 0);

  adj_height = (GtkAdjustment *) gtk_adjustment_new (height,
						    CD_CANVAS_HEIGHT_MIN,
						    CD_CANVAS_HEIGHT_MAX,
						    CD_CANVAS_HEIGHT_STEP,
						    5.0, 0.0);
  tsd->spin_height = gtk_spin_button_new (adj_height, 0, 0);
  gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (tsd->spin_height), TRUE);
  gtk_spin_button_set_shadow_type (GTK_SPIN_BUTTON (tsd->spin_height),
				   GTK_SHADOW_ETCHED_IN);
  gtk_box_pack_start(GTK_BOX (tsd->hbox2), tsd->spin_height, TRUE, TRUE, 0);

  gtk_box_pack_start(GTK_BOX (tsd->vbox), tsd->hbox2, FALSE, TRUE, 0);
}

/*
 * cd_tool_set_dialog_bottom_new
 */
void cd_tool_set_dialog_bottom_new(ToolSetDialog *tsd)
{
  tsd->hbox_bottom = gtk_hbox_new(FALSE, 5);

  tsd->ok_button = gtk_button_new_with_label (CD_OK_LABEL);
  gtk_box_pack_start (GTK_BOX (tsd->hbox_bottom),
		      tsd->ok_button, FALSE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (tsd->ok_button), "clicked",
		      GTK_SIGNAL_FUNC (cd_tool_set_dialog_ok),
		      (gpointer)tsd);
		      
  tsd->apply_button = gtk_button_new_with_label (CD_APPLY_LABEL);
  gtk_box_pack_start (GTK_BOX (tsd->hbox_bottom),
		      tsd->apply_button, FALSE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (tsd->apply_button), "clicked",
		      GTK_SIGNAL_FUNC (cd_tool_set_dialog_apply),
		      (gpointer)tsd);
		      
  tsd->reset_button = gtk_button_new_with_label (CD_RESET_LABEL);
  gtk_box_pack_start (GTK_BOX (tsd->hbox_bottom),
		      tsd->reset_button, FALSE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (tsd->reset_button), "clicked",
		      GTK_SIGNAL_FUNC (cd_tool_set_dialog_reset),
		      (gpointer)tsd);
		      
  tsd->max_button = gtk_button_new_with_label (CD_MAX_LABEL);
  gtk_box_pack_start (GTK_BOX (tsd->hbox_bottom),
		      tsd->max_button, FALSE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (tsd->max_button), "clicked",
		      GTK_SIGNAL_FUNC (cd_tool_set_dialog_max),
		      (gpointer)tsd);
		      
  tsd->min_button = gtk_button_new_with_label (CD_MIN_LABEL);
  gtk_box_pack_start (GTK_BOX (tsd->hbox_bottom),
		      tsd->min_button, FALSE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (tsd->min_button), "clicked",
		      GTK_SIGNAL_FUNC (cd_tool_set_dialog_min),
		      (gpointer)tsd);
		      
  tsd->close_button = gtk_button_new_with_label (CD_CLOSE_LABEL);
  gtk_box_pack_start (GTK_BOX (tsd->hbox_bottom),
		      tsd->close_button, FALSE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (tsd->close_button), "clicked",
		      GTK_SIGNAL_FUNC (cd_tool_set_dialog_close),
		      (gpointer)tsd);

  gtk_box_pack_start (GTK_BOX (tsd->vbox), tsd->hbox_bottom, FALSE, TRUE, 0);
}

/*
 * cd_tool_set_dialog_open
 */
void cd_tool_set_dialog_open()
{
  ToolSetDialog tsd;

  tsd.window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_modal((GtkWindow*)tsd.window, TRUE);
  gtk_signal_connect(GTK_OBJECT(tsd.window), "destroy", NULL, NULL);
  tsd.vbox = gtk_vbox_new(FALSE, 5);
  gtk_container_set_border_width(GTK_CONTAINER(tsd.vbox), 10);
  
  cd_tool_set_dialog_entrys_new(&tsd);
  cd_tool_set_dialog_bottom_new(&tsd);

  gtk_container_add (GTK_CONTAINER (tsd.window), tsd.vbox);
  gtk_widget_show_all (tsd.vbox);
  gtk_widget_show (tsd.window);

  gtk_main();
}
