/* cdedit2 -- class diagram creation/manipulation program
 * Copyright (C) 2001 Touge Kamisimo
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include "cd_define.h"
#include "cd_node.h"
#include "cd_node_dialog.h"

extern Node cd_node;

/*
 * cd_node_dialog_sort_type_swap
 */
GtkSortType cd_node_dialog_sort_type_swap(GtkSortType type)
{
  if(type == GTK_SORT_ASCENDING)
    return GTK_SORT_DESCENDING;
  else
    return GTK_SORT_ASCENDING;
}

/*
 * cd_node_dialog_at_set_funcs
 */
void cd_node_dialog_at_set_private(GtkWidget *widget, NodeDialog *nd)
{
  nd->at_vis = vis_private;
}
void cd_node_dialog_at_set_protected(GtkWidget *widget, NodeDialog *nd)
{
  nd->at_vis = vis_protected;
}
void cd_node_dialog_at_set_public(GtkWidget *widget, NodeDialog *nd)
{
  nd->at_vis = vis_public;
}

/*
 * cd_node_dialog_at_list_select
 */
void cd_node_dialog_at_list_select(GtkWidget *clist, gint row, gint column,
				   GdkEventButton *event, NodeDialog *nd)
{
  gchar *vis, *name;
  
  nd->at_select = row;

  gtk_clist_get_text((GtkCList*)nd->at_list, row, 0, &vis);
  gtk_clist_get_text((GtkCList*)nd->at_list, row, 1, &name);

  switch(*vis){
  case CD_VIS_PRIVATE:
    gtk_option_menu_set_history(GTK_OPTION_MENU (nd->at_opt), 1);
    cd_node_dialog_at_set_private(clist, nd);    
    break;
  case CD_VIS_PROTECTED:
    gtk_option_menu_set_history(GTK_OPTION_MENU (nd->at_opt), 2);
    cd_node_dialog_at_set_protected(clist, nd);    
    break;
  case CD_VIS_PUBLIC:
    gtk_option_menu_set_history(GTK_OPTION_MENU (nd->at_opt), 3);
    cd_node_dialog_at_set_public(clist, nd);    
    break;
  }

  gtk_entry_set_text((GtkEntry*)nd->at_entry, name); 
  gtk_widget_set_sensitive(nd->at_apply_button, TRUE);
  gtk_widget_set_sensitive(nd->at_delete_button, TRUE);
  gtk_widget_set_sensitive(nd->at_up_button, TRUE);
  gtk_widget_set_sensitive(nd->at_down_button, TRUE);
}
 
/*
 * cd_node_dialog_at_add
 */
void cd_node_dialog_at_add(GtkWidget *widget, NodeDialog *nd)
{
  gchar *dat[2] = {CD_VIS_PRIVATE_DQ, CD_ATTR_STRING};

  gtk_option_menu_set_history(GTK_OPTION_MENU (nd->at_opt), 0);
  gtk_clist_append( (GtkCList *)nd->at_list, dat);

  gtk_clist_unselect_all((GtkCList *)nd->at_list);
  gtk_entry_set_text((GtkEntry*)nd->at_entry, ""); 
}

/*
 * cd_node_dialog_at_apply
 */
void cd_node_dialog_at_apply(GtkWidget *widget, NodeDialog *nd)
{
  int row = nd->at_select;
  gchar *name;

  name = gtk_entry_get_text((GtkEntry*)nd->at_entry);
  gtk_clist_set_text((GtkCList*)nd->at_list, row, 1, name);

  switch(nd->at_vis){
  case vis_private:
    gtk_clist_set_text((GtkCList*)nd->at_list, row, 0, CD_VIS_PRIVATE_DQ);
    break;
  case vis_protected:
    gtk_clist_set_text((GtkCList*)nd->at_list, row, 0, CD_VIS_PROTECTED_DQ);
    break;
  case vis_public:
    gtk_clist_set_text((GtkCList*)nd->at_list, row, 0, CD_VIS_PUBLIC_DQ);
    break;
  }
}

/*
 * cd_node_dialog_at_delete
 */
void cd_node_dialog_at_delete(GtkWidget *widget, NodeDialog *nd)
{
  if(nd->at_select == CD_SELECTING_CLEAR || nd->at_select < 0)
    return;
  
  gtk_clist_remove((GtkCList *)nd->at_list, nd->at_select);

  gtk_entry_set_text((GtkEntry*)nd->at_entry, ""); 

  gtk_widget_set_sensitive(nd->at_apply_button, FALSE);
  gtk_widget_set_sensitive(nd->at_delete_button, FALSE);
  gtk_widget_set_sensitive(nd->at_up_button, FALSE);
  gtk_widget_set_sensitive(nd->at_down_button, FALSE);
  
  nd->at_select = CD_SELECTING_CLEAR;
}

/*
 * cd_node_dialog_at_up
 */
void cd_node_dialog_at_up(GtkWidget *widget, NodeDialog *nd)
{
  if(nd->at_select == CD_SELECTING_CLEAR || nd->at_select < 0)
    return;
  
  gtk_clist_row_move((GtkCList *)nd->at_list, nd->at_select, nd->at_select-1);
  nd->at_select--;
}

/*
 * cd_node_dialog_at_down
 */
void cd_node_dialog_at_down(GtkWidget *widget, NodeDialog *nd)
{
  if(nd->at_select == CD_SELECTING_CLEAR || nd->at_select < 0)
    return;
  
  gtk_clist_row_move((GtkCList *)nd->at_list, nd->at_select, nd->at_select+1);
  nd->at_select++;
}

/*
 * cd_node_dialog_attribute_list_init
 */
void cd_node_dialog_attribute_list_init(NodeDialog *nd)
{
  Attribute *attr;
  int i = nd->item_index;
  int j;
  gchar *dat[2];

  for(j=0; j<g_list_length(cd_node.item[i].attributes); j++){
    attr = g_list_nth_data(cd_node.item[i].attributes, j);
    switch(attr->vis){
    case vis_private:
      dat[0] = CD_VIS_PRIVATE_DQ;
      break;
    case vis_protected:
      dat[0] = CD_VIS_PROTECTED_DQ;
      break;
    case vis_public:
      dat[0] = CD_VIS_PUBLIC_DQ;
      break;
    }
    dat[1] = attr->name;
    gtk_clist_append( (GtkCList *)nd->at_list, dat);
  }
}

/*
 * cd_node_dialog_at_click_colum
 */
void cd_node_dialog_at_click_colum(GtkCList *list, gint column, NodeDialog *nd)
{
  GtkSortType  sort_type;

  if(column == 0){
    sort_type = nd->at_sort_type0;
    nd->at_sort_type0 = cd_node_dialog_sort_type_swap(nd->at_sort_type0);
  }else if(column == 1){
    sort_type = nd->at_sort_type1;
    nd->at_sort_type1 = cd_node_dialog_sort_type_swap(nd->at_sort_type1);
  }

  gtk_clist_set_sort_type(list, sort_type);
  gtk_clist_set_sort_column(list, column);
  gtk_clist_sort(list);

  gtk_clist_unselect_all((GtkCList *)nd->at_list);
  gtk_entry_set_text((GtkEntry*)nd->at_entry, ""); 
  gtk_option_menu_set_history(GTK_OPTION_MENU (nd->at_opt), 0);

  gtk_widget_set_sensitive(nd->at_apply_button, FALSE);
  gtk_widget_set_sensitive(nd->at_delete_button, FALSE);
  gtk_widget_set_sensitive(nd->at_up_button, FALSE);
  gtk_widget_set_sensitive(nd->at_down_button, FALSE);
  
  nd->at_select = CD_SELECTING_CLEAR;
}

/*
 * cd_node_dialog_attribute_new
 */
void cd_node_dialog_attribute_new(NodeDialog *nd)
{
  gchar *titles[2] = { CD_VIS_LABEL, CD_NAME_LABEL };

  nd->at_select = CD_SELECTING_CLEAR;
  nd->at_sort_type0 = GTK_SORT_ASCENDING;
  nd->at_sort_type1 = GTK_SORT_ASCENDING;

  /* attribute list */
  nd->at_hbox1 = gtk_hbox_new(FALSE, 5);
  nd->at_scrolled_win = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (nd->at_scrolled_win),
				  GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_widget_set_usize(nd->at_scrolled_win, 100, 120);
  gtk_box_pack_start (GTK_BOX (nd->vbox), nd->at_scrolled_win, TRUE, TRUE, 0);
  gtk_widget_show (nd->at_scrolled_win);
  nd->at_list = gtk_clist_new_with_titles(2, titles);
  gtk_scrolled_window_add_with_viewport
    (GTK_SCROLLED_WINDOW (nd->at_scrolled_win), nd->at_list);
  gtk_signal_connect (GTK_OBJECT (nd->at_list), "select_row",
		      (GtkSignalFunc)cd_node_dialog_at_list_select,
		      (gpointer)nd);
  gtk_signal_connect (GTK_OBJECT (nd->at_list), "click_column",
		      (GtkSignalFunc)cd_node_dialog_at_click_colum,
		      (gpointer)nd);
  gtk_box_pack_start (GTK_BOX (nd->vbox), nd->at_hbox1, FALSE, TRUE, 0);

  /* attribute entry */
  nd->at_hbox2 = gtk_hbox_new(FALSE, 5);
  nd->at_opt = gtk_option_menu_new();
  nd->at_opt_menu = gtk_menu_new();

  nd->at_opt_menu_item = gtk_menu_item_new_with_label("");
  gtk_widget_show(GTK_WIDGET(nd->at_opt_menu_item));
  gtk_menu_append (GTK_MENU (nd->at_opt_menu), nd->at_opt_menu_item);

  nd->at_opt_menu_item = gtk_menu_item_new_with_label(CD_VIS_PRIVATE_DQ);
  gtk_signal_connect(GTK_OBJECT (nd->at_opt_menu_item), "activate",
		     GTK_SIGNAL_FUNC(cd_node_dialog_at_set_private),
		      (gpointer)nd);
  gtk_widget_show(GTK_WIDGET(nd->at_opt_menu_item));
  gtk_menu_append (GTK_MENU (nd->at_opt_menu), nd->at_opt_menu_item);

  nd->at_opt_menu_item = gtk_menu_item_new_with_label(CD_VIS_PROTECTED_DQ);
  gtk_signal_connect(GTK_OBJECT (nd->at_opt_menu_item), "activate",
		     GTK_SIGNAL_FUNC(cd_node_dialog_at_set_protected),
		      (gpointer)nd);
  gtk_widget_show(GTK_WIDGET(nd->at_opt_menu_item));
  gtk_menu_append (GTK_MENU (nd->at_opt_menu), nd->at_opt_menu_item);

  nd->at_opt_menu_item = gtk_menu_item_new_with_label(CD_VIS_PUBLIC_DQ);
  gtk_signal_connect(GTK_OBJECT (nd->at_opt_menu_item), "activate",
		     GTK_SIGNAL_FUNC(cd_node_dialog_at_set_public),
		      (gpointer)nd);
  gtk_widget_show(GTK_WIDGET(nd->at_opt_menu_item));
  gtk_menu_append (GTK_MENU (nd->at_opt_menu), nd->at_opt_menu_item);

  gtk_option_menu_set_menu (GTK_OPTION_MENU (nd->at_opt), nd->at_opt_menu);
  gtk_box_pack_start (GTK_BOX (nd->at_hbox2), nd->at_opt, TRUE, TRUE, 0);
  gtk_widget_show (nd->at_opt);
    
  nd->at_entry = gtk_entry_new();
  gtk_box_pack_start (GTK_BOX (nd->at_hbox2), nd->at_entry, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (nd->vbox), nd->at_hbox2, FALSE, TRUE, 0);

  cd_node_dialog_attribute_list_init(nd);

  /* add button */
  nd->at_hbox3 = gtk_hbox_new(FALSE, 5);
  nd->at_add_button = gtk_button_new_with_label (CD_ADD_LABEL);
  gtk_signal_connect(GTK_OBJECT(nd->at_add_button), "clicked",
		     (GtkSignalFunc)cd_node_dialog_at_add,
		     (gpointer)nd);
  gtk_box_pack_start (GTK_BOX (nd->at_hbox3),
		      nd->at_add_button, FALSE, TRUE, 0);

  /* apply button */
  nd->at_apply_button = gtk_button_new_with_label (CD_APPLY_LABEL);
  gtk_signal_connect(GTK_OBJECT(nd->at_apply_button), "clicked",
		     (GtkSignalFunc)cd_node_dialog_at_apply,
		     (gpointer)nd);
  gtk_box_pack_start (GTK_BOX (nd->at_hbox3),
		      nd->at_apply_button, FALSE, TRUE, 0);
  gtk_widget_set_sensitive(nd->at_apply_button, FALSE);

  /* delete button */
  nd->at_delete_button = gtk_button_new_with_label (CD_DELETE_LABEL);
  gtk_signal_connect(GTK_OBJECT(nd->at_delete_button), "clicked",
		     (GtkSignalFunc)cd_node_dialog_at_delete,
		     (gpointer)nd);
  gtk_box_pack_start (GTK_BOX (nd->at_hbox3),
		      nd->at_delete_button, FALSE, TRUE, 0);
  gtk_widget_set_sensitive(nd->at_delete_button, FALSE);

  /* up button */
  nd->at_up_button = gtk_button_new_with_label (CD_UP_LABEL);
  gtk_signal_connect(GTK_OBJECT(nd->at_up_button), "clicked",
		     (GtkSignalFunc)cd_node_dialog_at_up,
		     (gpointer)nd);
  gtk_box_pack_start (GTK_BOX (nd->at_hbox3),
		      nd->at_up_button, FALSE, TRUE, 0);
  gtk_widget_set_sensitive(nd->at_up_button, FALSE);

  /* down button */
  nd->at_down_button = gtk_button_new_with_label (CD_DOWN_LABEL);
  gtk_signal_connect(GTK_OBJECT(nd->at_down_button), "clicked",
		     (GtkSignalFunc)cd_node_dialog_at_down,
		     (gpointer)nd);
  gtk_box_pack_start (GTK_BOX (nd->at_hbox3),
		      nd->at_down_button, FALSE, TRUE, 0);
  gtk_widget_set_sensitive(nd->at_down_button, FALSE);

  gtk_box_pack_start (GTK_BOX (nd->vbox), nd->at_hbox3, FALSE, TRUE, 0);
}

/*
 * cd_node_dialog_op_set_func
 */
void cd_node_dialog_op_set_private(GtkWidget *widget, NodeDialog *nd)
{
  nd->op_vis = vis_private;
}
void cd_node_dialog_op_set_protected(GtkWidget *widget, NodeDialog *nd)
{
  nd->op_vis = vis_protected;
}
void cd_node_dialog_op_set_public(GtkWidget *widget, NodeDialog *nd)
{
  nd->op_vis = vis_public;
}

/*
 * cd_node_dialog_op_list_select
 */
void cd_node_dialog_op_list_select(GtkWidget *clist, gint row, gint column,
				   GdkEventButton *event, NodeDialog *nd)
{
  gchar *vis, *name;
  
  nd->op_select = row;

  gtk_clist_get_text((GtkCList*)nd->op_list, row, 0, &vis);
  gtk_clist_get_text((GtkCList*)nd->op_list, row, 1, &name);

  switch(*vis){
  case CD_VIS_PRIVATE:
    gtk_option_menu_set_history(GTK_OPTION_MENU (nd->op_opt), 1);
    cd_node_dialog_op_set_private(clist, nd);    
    break;
  case CD_VIS_PROTECTED:
    gtk_option_menu_set_history(GTK_OPTION_MENU (nd->op_opt), 2);
    cd_node_dialog_op_set_protected(clist, nd);    
    break;
  case CD_VIS_PUBLIC:
    gtk_option_menu_set_history(GTK_OPTION_MENU (nd->op_opt), 3);
    cd_node_dialog_op_set_public(clist, nd);    
    break;
  }

  gtk_entry_set_text((GtkEntry*)nd->op_entry, name); 
  gtk_widget_set_sensitive(nd->op_apply_button, TRUE);
  gtk_widget_set_sensitive(nd->op_delete_button, TRUE);
  gtk_widget_set_sensitive(nd->op_up_button, TRUE);
  gtk_widget_set_sensitive(nd->op_down_button, TRUE);
}
 
/*
 * cd_node_dialog_op_add
 */
void cd_node_dialog_op_add(GtkWidget *widget, NodeDialog *nd)
{
  gchar *dat[2] = {CD_VIS_PUBLIC_DQ, CD_OP_STRING};

  gtk_option_menu_set_history(GTK_OPTION_MENU (nd->op_opt), 0);
  gtk_clist_append( (GtkCList *)nd->op_list, dat);

  gtk_clist_unselect_all((GtkCList *)nd->op_list);
  gtk_entry_set_text((GtkEntry*)nd->op_entry, ""); 
}

/*
 * cd_node_dialog_op_apply
 */
void cd_node_dialog_op_apply(GtkWidget *widget, NodeDialog *nd)
{
  int row = nd->op_select;
  gchar *name;

  name = gtk_entry_get_text((GtkEntry*)nd->op_entry);
  gtk_clist_set_text((GtkCList*)nd->op_list, row, 1, name);

  switch(nd->op_vis){
  case vis_private:
    gtk_clist_set_text((GtkCList*)nd->op_list, row, 0, CD_VIS_PRIVATE_DQ);
    break;
  case vis_protected:
    gtk_clist_set_text((GtkCList*)nd->op_list, row, 0, CD_VIS_PROTECTED_DQ);
    break;
  case vis_public:
    gtk_clist_set_text((GtkCList*)nd->op_list, row, 0, CD_VIS_PUBLIC_DQ);
    break;
  }
}

/*
 * cd_node_dialog_op_delete
 */
void cd_node_dialog_op_delete(GtkWidget *widget, NodeDialog *nd)
{
  if(nd->op_select == CD_SELECTING_CLEAR || nd->op_select < 0)
    return;
  
  gtk_clist_remove((GtkCList *)nd->op_list, nd->op_select);

  gtk_entry_set_text((GtkEntry*)nd->op_entry, ""); 

  gtk_widget_set_sensitive(nd->op_apply_button, FALSE);
  gtk_widget_set_sensitive(nd->op_delete_button, FALSE);
  gtk_widget_set_sensitive(nd->op_up_button, FALSE);
  gtk_widget_set_sensitive(nd->op_down_button, FALSE);
  
  nd->op_select = CD_SELECTING_CLEAR;
}

/*
 * cd_node_dialog_op_up
 */
void cd_node_dialog_op_up(GtkWidget *widget, NodeDialog *nd)
{
  if(nd->op_select == CD_SELECTING_CLEAR || nd->op_select < 0)
    return;
  
  gtk_clist_row_move((GtkCList *)nd->op_list, nd->op_select, nd->op_select-1);
  nd->op_select--;
}

/*
 * cd_node_dialog_op_down
 */
void cd_node_dialog_op_down(GtkWidget *widget, NodeDialog *nd)
{
  if(nd->op_select == CD_SELECTING_CLEAR || nd->op_select < 0)
    return;
  
  gtk_clist_row_move((GtkCList *)nd->op_list, nd->op_select, nd->op_select+1);
  nd->op_select++;
}

/*
 * cd_node_dialog_operation_list_init
 */
void cd_node_dialog_operation_list_init(NodeDialog *nd)
{
  Operation *op;
  int i = nd->item_index;
  int j;
  gchar *dat[2];

  for(j=0; j<g_list_length(cd_node.item[i].operations); j++){
    op = g_list_nth_data(cd_node.item[i].operations, j);
    switch(op->vis){
    case vis_private:
      dat[0] = CD_VIS_PRIVATE_DQ;
      break;
    case vis_protected:
      dat[0] = CD_VIS_PROTECTED_DQ;
      break;
    case vis_public:
      dat[0] = CD_VIS_PUBLIC_DQ;
      break;
    }
    dat[1] = op->name;
    gtk_clist_append( (GtkCList *)nd->op_list, dat);
  }
}

/*
 * cd_node_dialog_op_click_colum
 */
void cd_node_dialog_op_click_colum(GtkCList *list, gint column, NodeDialog *nd)
{
  GtkSortType  sort_type;

  if(column == 0){
    sort_type = nd->op_sort_type0;
    nd->op_sort_type0 = cd_node_dialog_sort_type_swap(nd->op_sort_type0);
  }else if(column == 1){
    sort_type = nd->op_sort_type1;
    nd->op_sort_type1 = cd_node_dialog_sort_type_swap(nd->op_sort_type1);
  }

  gtk_clist_set_sort_type(list, sort_type);
  gtk_clist_set_sort_column(list, column);
  gtk_clist_sort(list);

  gtk_clist_unselect_all((GtkCList *)nd->op_list);
  gtk_entry_set_text((GtkEntry*)nd->op_entry, ""); 
  gtk_option_menu_set_history(GTK_OPTION_MENU (nd->op_opt), 0);

  gtk_widget_set_sensitive(nd->op_apply_button, FALSE);
  gtk_widget_set_sensitive(nd->op_delete_button, FALSE);
  gtk_widget_set_sensitive(nd->op_up_button, FALSE);
  gtk_widget_set_sensitive(nd->op_down_button, FALSE);
  
  nd->op_select = CD_SELECTING_CLEAR;
}

/*
 * cd_node_dialog_operation_new
 */
void cd_node_dialog_operation_new(NodeDialog *nd)
{
  gchar *titles[2] = { CD_VIS_LABEL, CD_NAME_LABEL };

  nd->op_select = CD_SELECTING_CLEAR;
  nd->op_sort_type0 = GTK_SORT_ASCENDING;
  nd->op_sort_type1 = GTK_SORT_ASCENDING;

  /* operation list */
  nd->op_hbox1 = gtk_hbox_new(FALSE, 5);
  nd->op_scrolled_win = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (nd->op_scrolled_win),
				  GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_widget_set_usize(nd->op_scrolled_win, 100, 120);
  gtk_box_pack_start (GTK_BOX (nd->vbox), nd->op_scrolled_win, TRUE, TRUE, 0);
  gtk_widget_show (nd->op_scrolled_win);
  nd->op_list = gtk_clist_new_with_titles(2, titles);
  gtk_scrolled_window_add_with_viewport
    (GTK_SCROLLED_WINDOW (nd->op_scrolled_win), nd->op_list);
  gtk_signal_connect (GTK_OBJECT (nd->op_list), "select_row",
		      (GtkSignalFunc)cd_node_dialog_op_list_select,
		      (gpointer)nd);
  gtk_signal_connect (GTK_OBJECT (nd->op_list), "click_column",
		      (GtkSignalFunc)cd_node_dialog_op_click_colum,
		      (gpointer)nd);
  gtk_box_pack_start (GTK_BOX (nd->vbox), nd->op_hbox1, FALSE, TRUE, 0);

  /* operation entry */
  nd->op_hbox2 = gtk_hbox_new(FALSE, 5);
  nd->op_opt = gtk_option_menu_new();
  nd->op_opt_menu = gtk_menu_new();

  nd->op_opt_menu_item = gtk_menu_item_new_with_label("");
  gtk_widget_show(GTK_WIDGET(nd->op_opt_menu_item));
  gtk_menu_append (GTK_MENU (nd->op_opt_menu), nd->op_opt_menu_item);

  nd->op_opt_menu_item = gtk_menu_item_new_with_label(CD_VIS_PRIVATE_DQ);
  gtk_signal_connect(GTK_OBJECT (nd->op_opt_menu_item), "activate",
		     GTK_SIGNAL_FUNC(cd_node_dialog_op_set_private),
		      (gpointer)nd);
  gtk_widget_show(GTK_WIDGET(nd->op_opt_menu_item));
  gtk_menu_append (GTK_MENU (nd->op_opt_menu), nd->op_opt_menu_item);

  nd->op_opt_menu_item = gtk_menu_item_new_with_label(CD_VIS_PROTECTED_DQ);
  gtk_signal_connect(GTK_OBJECT (nd->op_opt_menu_item), "activate",
		     GTK_SIGNAL_FUNC(cd_node_dialog_op_set_protected),
		      (gpointer)nd);
  gtk_widget_show(GTK_WIDGET(nd->op_opt_menu_item));
  gtk_menu_append (GTK_MENU (nd->op_opt_menu), nd->op_opt_menu_item);

  nd->op_opt_menu_item = gtk_menu_item_new_with_label(CD_VIS_PUBLIC_DQ);
  gtk_signal_connect(GTK_OBJECT (nd->op_opt_menu_item), "activate",
		     GTK_SIGNAL_FUNC(cd_node_dialog_op_set_public),
		      (gpointer)nd);
  gtk_widget_show(GTK_WIDGET(nd->op_opt_menu_item));
  gtk_menu_append (GTK_MENU (nd->op_opt_menu), nd->op_opt_menu_item);

  gtk_option_menu_set_menu (GTK_OPTION_MENU (nd->op_opt), nd->op_opt_menu);
  gtk_box_pack_start (GTK_BOX (nd->op_hbox2), nd->op_opt, TRUE, TRUE, 0);
  gtk_widget_show (nd->op_opt);
    
  nd->op_entry = gtk_entry_new();
  gtk_box_pack_start (GTK_BOX (nd->op_hbox2), nd->op_entry, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (nd->vbox), nd->op_hbox2, FALSE, TRUE, 0);

  cd_node_dialog_operation_list_init(nd);

  /* add button */
  nd->op_hbox3 = gtk_hbox_new(FALSE, 5);
  nd->op_add_button = gtk_button_new_with_label (CD_ADD_LABEL);
  gtk_signal_connect(GTK_OBJECT(nd->op_add_button), "clicked",
		     (GtkSignalFunc)cd_node_dialog_op_add,
		     (gpointer)nd);
  gtk_box_pack_start (GTK_BOX (nd->op_hbox3),
		      nd->op_add_button, FALSE, TRUE, 0);

  /* apply button */
  nd->op_apply_button = gtk_button_new_with_label (CD_APPLY_LABEL);
  gtk_signal_connect(GTK_OBJECT(nd->op_apply_button), "clicked",
		     (GtkSignalFunc)cd_node_dialog_op_apply,
		     (gpointer)nd);
  gtk_box_pack_start (GTK_BOX (nd->op_hbox3),
		      nd->op_apply_button, FALSE, TRUE, 0);
  gtk_widget_set_sensitive(nd->op_apply_button, FALSE);

  /* delete button */
  nd->op_delete_button = gtk_button_new_with_label (CD_DELETE_LABEL);
  gtk_signal_connect(GTK_OBJECT(nd->op_delete_button), "clicked",
		     (GtkSignalFunc)cd_node_dialog_op_delete,
		     (gpointer)nd);
  gtk_box_pack_start (GTK_BOX (nd->op_hbox3),
		      nd->op_delete_button, FALSE, TRUE, 0);
  gtk_widget_set_sensitive(nd->op_delete_button, FALSE);

  /* up button */
  nd->op_up_button = gtk_button_new_with_label (CD_UP_LABEL);
  gtk_signal_connect(GTK_OBJECT(nd->op_up_button), "clicked",
		     (GtkSignalFunc)cd_node_dialog_op_up,
		     (gpointer)nd);
  gtk_box_pack_start (GTK_BOX (nd->op_hbox3),
		      nd->op_up_button, FALSE, TRUE, 0);
  gtk_widget_set_sensitive(nd->op_up_button, FALSE);

  /* down button */
  nd->op_down_button = gtk_button_new_with_label (CD_DOWN_LABEL);
  gtk_signal_connect(GTK_OBJECT(nd->op_down_button), "clicked",
		     (GtkSignalFunc)cd_node_dialog_op_down,
		     (gpointer)nd);
  gtk_box_pack_start (GTK_BOX (nd->op_hbox3),
		      nd->op_down_button, FALSE, TRUE, 0);
  gtk_widget_set_sensitive(nd->op_down_button, FALSE);

  gtk_box_pack_start (GTK_BOX (nd->vbox), nd->op_hbox3, FALSE, TRUE, 0);
}

/*
 * cd_node_dialog_apply
 */
void cd_node_dialog_apply(GtkWidget *widget, NodeDialog *nd)
{
  gchar *cl_name;

  Attribute *attr;
  gchar *at_vis, *at_name;
  Operation *op;
  gchar *op_vis, *op_name;
  int j,k;

  int i = nd->item_index;

  cl_name = gtk_entry_get_text((GtkEntry*)nd->cl_entry);
  sprintf(cd_node.item[i].name, "%s", cl_name);

  if(cd_node.item[i].attributes != NULL){
    g_list_free(cd_node.item[i].attributes);
    cd_node.item[i].attributes = NULL;
  }

  if(cd_node.item[i].operations != NULL){
    g_list_free(cd_node.item[i].operations);
    cd_node.item[i].operations = NULL;
  }

  j = 0;
  while(gtk_clist_get_cell_type((GtkCList*)nd->at_list, j, 0) != -1){
    gtk_clist_get_text((GtkCList*)nd->at_list, j, 0, &at_vis);
    gtk_clist_get_text((GtkCList*)nd->at_list, j, 1, &at_name);

    attr = g_new(Attribute, 1);
    sprintf(attr->name, "%s", at_name);

    switch(*at_vis){
    case CD_VIS_PRIVATE:
      attr->vis = vis_private;
      break;
    case CD_VIS_PROTECTED:
      attr->vis = vis_protected;
      break;
    case CD_VIS_PUBLIC:
      attr->vis = vis_public;
      break;
    }
    
    cd_node.item[i].attributes =
      g_list_append(cd_node.item[i].attributes, attr);
    
    j++;
  }

  j = 0;
  while(gtk_clist_get_cell_type((GtkCList*)nd->op_list, j, 0) != -1){
    gtk_clist_get_text((GtkCList*)nd->op_list, j, 0, &op_vis);
    gtk_clist_get_text((GtkCList*)nd->op_list, j, 1, &op_name);

    op = g_new(Operation, 1);
    sprintf(op->name, "%s", op_name);

    switch(*op_vis){
    case CD_VIS_PRIVATE:
      op->vis = vis_private;
      break;
    case CD_VIS_PROTECTED:
      op->vis = vis_protected;
      break;
    case CD_VIS_PUBLIC:
      op->vis = vis_public;
      break;
    }
    
    cd_node.item[i].operations =
      g_list_append(cd_node.item[i].operations, op);
    
    j++;
  }

  cd_control_node_dialog_apply(i);

}

/*
 * cd_node_dialog_close
 */
void cd_node_dialog_close(GtkWidget *widget, NodeDialog *nd)
{
  gtk_widget_destroy(nd->window);
}

/*
 * cd_node_dialog_ok
 */
void cd_node_dialog_ok(GtkWidget *widget, NodeDialog *nd)
{
  cd_node_dialog_apply(widget, nd);
  cd_node_dialog_close(widget, nd);
}

/*
 * cd_node_dialog_bottom_new
 */
void cd_node_dialog_bottom_new(NodeDialog *nd)
{
  nd->bottom_hbox = gtk_hbox_new(FALSE, 5);

  nd->ok_button = gtk_button_new_with_label (CD_OK_LABEL);
  gtk_signal_connect(GTK_OBJECT(nd->ok_button), "clicked",
		     (GtkSignalFunc)cd_node_dialog_ok,
		     (gpointer)nd);
  gtk_box_pack_start (GTK_BOX (nd->bottom_hbox),
		      nd->ok_button, FALSE, TRUE, 0);

  nd->apply_button = gtk_button_new_with_label (CD_APPLY_LABEL);
  gtk_signal_connect(GTK_OBJECT(nd->apply_button), "clicked",
		     (GtkSignalFunc)cd_node_dialog_apply,
		     (gpointer)nd);
  gtk_box_pack_start (GTK_BOX (nd->bottom_hbox),
		      nd->apply_button, FALSE, TRUE, 0);

  nd->close_button = gtk_button_new_with_label (CD_CLOSE_LABEL);
  gtk_signal_connect(GTK_OBJECT(nd->close_button), "clicked",
		     (GtkSignalFunc)cd_node_dialog_close,
		     (gpointer)nd);
  gtk_box_pack_start (GTK_BOX (nd->bottom_hbox),
		      nd->close_button, FALSE, TRUE, 0);

  gtk_box_pack_start (GTK_BOX (nd->vbox), nd->bottom_hbox, FALSE, TRUE, 0);
}

/*
 * cd_node_dialog_open
 */
void cd_node_dialog_open(int i)
{
  NodeDialog nd;

  nd.item_index = i;

  /* top window */
  nd.window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_modal((GtkWindow*)nd.window, TRUE);
  gtk_container_border_width (GTK_CONTAINER (nd.window), 10);
  gtk_signal_connect(GTK_OBJECT(nd.window), "destroy", NULL, NULL);
  nd.vbox = gtk_vbox_new(FALSE, 5);
  gtk_container_set_border_width (GTK_CONTAINER (nd.vbox), 10);
  
  /* class entry */
  nd.cl_label = gtk_label_new (CD_CLASS_STRING);
  nd.cl_hbox = gtk_hbox_new(FALSE, 5);
  gtk_box_pack_start (GTK_BOX (nd.cl_hbox), nd.cl_label, FALSE, TRUE, 0);
		     
  nd.cl_entry = gtk_entry_new();
  gtk_entry_set_text((GtkEntry*)nd.cl_entry, cd_node.item[i].name); 
  gtk_box_pack_start (GTK_BOX (nd.cl_hbox), nd.cl_entry, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (nd.vbox), nd.cl_hbox, FALSE, TRUE, 0);

  cd_node_dialog_attribute_new(&nd);
  cd_node_dialog_operation_new(&nd);
  cd_node_dialog_bottom_new(&nd);

  gtk_container_add (GTK_CONTAINER (nd.window), nd.vbox);
  
  gtk_widget_show_all (nd.vbox);
  gtk_widget_show (nd.window);

  gtk_main();
}
