/* cdedit2 -- class diagram creation/manipulation program
 * Copyright (C) 2001 Touge Kamisimo
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef CD_CONTROL_H
#define CD_CONTROL_H

#include "cd_define.h"

void cd_control_selection(int x, int y, int event_type);
void cd_control_selection_end();
void cd_control_motion(int x, int y);
gboolean cd_control_selecting();
void cd_control_selecting_clear();
void cd_control_mode_change_from_select();

void cd_control_node_add(int x, int y);

void cd_control_arc_add_start(int x, int y, CdToolType type);
void cd_control_arc_add_end(int x, int y, CdToolType type);

void cd_control_draw_all();
void cd_control_draw_node_all();

void cd_control_delete();
void cd_control_delete_arc_with_node();

void cd_control_save();

void cd_control_node_dialog_apply(int i);
void cd_control_arc_dialog_apply0(int i);
void cd_control_arc_dialog_apply(int i);

void cd_control_tool_set_dialog_open();
gint cd_control_calc_effective_rect(GdkRectangle *rect);

#endif
