#!/usr/bin/env bash

set -e

eval `ultrapossum-config init`
trap "eval `ultrapossum-config term`" 0

cat <<EOF
#
# LDAP Defaults for $ORGANIZATION
#

# See ldap.conf(5) for details
# This file should be world readable but not world writable.

BASE	$SUFFIX
HOST	$LDAPHOSTS
EOF

if test "x$LDAPLISTENPORT" != "x"; then
  echo "PORT	$LDAPLISTENPORT"
fi

for d in LDAPSIZELIMIT LDAPTIMELIMIT LDAPDEREF LDAPSASL_SECPROPS \
	LDAPTLS_CACERTDIR LDAPTLS_REQCERT
do
  if test "x${!d}" != "x"; then
    echo -n "`echo $d | sed 's/^LDAP//'`"
    echo "	${!d}"
  fi
done

