Summary: Utility to administer the Linux Virtual Server
Name: ipvsadm
Version: 1.24
Release: 6
License: GPL
URL: http://www.LinuxVirtualServer.org/
Group: Applications/System
Buildroot: %{_tmppath}/%{name}-%{PACKAGE_VERSION}-buildroot
Provides: %{name}-%{version}
#ExcludeArch: ppc
Conflicts: piranha <= 0.4.14


Source0: http://www.LinuxVirtualServer.org/software/ipvsadm-%{version}.tar.gz
patch0: ipvsadm-1.24-kernhdr-1.2.0.patch
#patch1: ipvsadm-1.21-desc.patch
#patch2: ipvsadm-1.21-restore.patch
#patch3: ipvsadm-1.21-sort.patch
#patch4: ipvsadm-1.21-sched.patch
#patch5: ipvsadm-1.21-spelling.patch
#patch6: ipvsadm-1.21-fmt.patch


%description
ipvsadm is a utility to administer the IP Virtual Server services
offered by the Linux kernel.


%prep
%setup -n %{name}-%{version}
%patch0 -p1
#%patch1 -p1
#%patch2 -p1
#%patch3 -p1
#%patch4 -p1
#%patch5 -p1
#%patch6 -p1


%build
CFLAGS="${RPM_OPT_FLAGS}" make


%install
rm -rf $RPM_BUILD_ROOT
mkdir -p ${RPM_BUILD_ROOT}/{sbin,%{_mandir}/man8,etc/rc.d/init.d}
make install BUILD_ROOT=${RPM_BUILD_ROOT} MANDIR=%{_mandir}


%files
%defattr(-,root,root)
%doc README
%config /etc/rc.d/init.d/ipvsadm
/sbin/ipvsadm*
%{_mandir}/man8/ipvsadm*


%post
/sbin/chkconfig --add ipvsadm


%preun
/sbin/chkconfig --del ipvsadm


%clean
rm -rf $RPM_BUILD_DIR/%{name}
rm -rf $RPM_BUILD_ROOT


%changelog
* Wed Jan 12 2005 Chris Feist <cfeist@redhat.com>
- Rebuilt for cluster.

* Tue Jun 15 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Tue Mar 16 2004 Mike McLean <mikem@redhat.com> 1.24-4.2.ipvs120
- bump release

* Tue Mar 02 2004 Mike McLean <mikem@redhat.com> 1.24-4.1.ipvs120
- update to new version for 2.6 kernel

* Thu Jan 08 2004 Mike McLean <mikem@redhat.com> 1.21-10.ipvs108
- fixing a minor bug/typo in output format processing

* Wed Aug 06 2003 Mike McLean <mikem@redhat.com> 1.21-9.ipvs108
- Dropping kernel-source BuildRequires and including a local copy of 
  net/ip_vs.h to compensate.
- Incorporating some upstream changes, most notably the --sort option.

* Fri Jun 13 2003 Mike McLean <mikem@redhat.com> 1.21-8
- dropping ppc from excluded arches

* Thu Apr 4 2003 Mike McLean <mikem@redhat.com> 1.21-7
- changing %%ExcludeArch

* Thu Apr 4 2003 Mike McLean <mikem@redhat.com> 1.21-6
- added BuildRequires: kernel-source
- escaped all %% characters in %%changelog

* Mon Dec 2 2002 Mike McLean <mikem@redhat.com> 1.21-5
- Improved the description in the ipvsadm initscript.
- fixed Buildroot to use _tmppath

* Wed Aug 21 2002 Philip Copeland <bryce@redhat.com> 1.21-4
- Argh,.. %%docdir was defined which overrode what I'd
  intended to happen

* Tue Aug 1 2002 Philip Copeland <bryce@redhat.com>
- Ah... the manuals were being pushed into /usr/man
  instead of /usr/share/man. Fixed.

* Tue Jul 16 2002 Philip Copeland <bryce@redhat.com>
- Minor Makefile tweak so that we do a minimal hunt for to find
  the ip_vs.h file location

* Thu Dec 16 2001 Wensong Zhang <wensong@linuxvirtualserver.org>
- Changed to install ipvsadm man pages according to the %%{_mandir}

* Thu Dec 30 2000 Wensong Zhang <wensong@linuxvirtualserver.org>
- update the %%file section

* Thu Dec 17 2000 Wensong Zhang <wensong@linuxvirtualserver.org>
- Added a if-condition to keep both new or old rpm utility building
  the package happily.

* Tue Dec 12 2000 P.opeland <bryce@redhat.com>
- Small modifications to make the compiler happy in RH7 and the Alpha
- Fixed the documentation file that got missed off in building
  the rpm
- Made a number of -pedantic mods though popt will not compile with
  -pedantic

* Wed Aug 9 2000 Horms <horms@vergenet.net>
- Removed Obseletes tag as ipvsadm is back in /sbin where it belongs 
  as it is more or less analogous to both route and ipchains both of
  which reside in /sbin.
- Create directory to install init script into. Init scripts won't install
  into build directory unless this is done

* Thu Jul  6 2000 Wensong Zhang <wensong@linuxvirtualserver.org>
- Changed to build rpms on the ipvsadm tar ball directly

* Wed Jun 21 2000 P.Copeland <copeland@redhat.com>
- fixed silly install permission settings

* Mon Jun 19 2000 P.Copeland <copeland@redhat.com>
- Added 'dist' and 'rpms' to the Makefile
- Added Obsoletes tag since there were early versions
  of ipvsadm-*.rpm that installed in /sbin
- Obsolete tag was a bit vicious re: piranha

* Mon Apr 10 2000 Horms <horms@vergenet.net>
- created for version 1.9
