/*
 * Decompiled with CFR 0.152.
 */
package org.ultramonkey.l7.controller;

import java.io.File;
import java.util.Date;
import org.apache.log4j.Logger;
import org.ultramonkey.l7.controller.ClusterController;
import org.ultramonkey.l7.controller.ClusterData;
import org.ultramonkey.l7.controller.DirectorController;
import org.ultramonkey.l7.controller.DirectorData;
import org.ultramonkey.l7.controller.L7vsAdmController;
import org.ultramonkey.l7.controller.L7vsAdmData;
import org.ultramonkey.l7.controller.L7vsConfController;
import org.ultramonkey.l7.controller.L7vsConfData;
import org.ultramonkey.l7.controller.LogData;
import org.ultramonkey.l7.controller.LogFileData;
import org.ultramonkey.l7.controller.LogSet;
import org.ultramonkey.l7.model.FileNotReadException;

public class L7vsLogController {
    private Logger ioFileLogger = Logger.getLogger((String)"l7gui_I/O.File");
    private static String GUI_LOG = "/var/log/l7vs/l7gui.log";
    private static String SYNC_LOG = "/var/log/l7vs/l7sync.log";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogData getData() {
        if (this.ioFileLogger.isDebugEnabled()) {
            this.ioFileLogger.debug((Object)"11504 L7vsLogController::getData() in");
        }
        L7vsLogController l7vsLogController = this;
        synchronized (l7vsLogController) {
            L7vsConfController confController = new L7vsConfController();
            DirectorController direController = new DirectorController();
            ClusterController haController = new ClusterController();
            L7vsAdmController admController = new L7vsAdmController();
            L7vsConfData cf = null;
            DirectorData dd = null;
            ClusterData cd = null;
            L7vsAdmData ad = null;
            LogData logData = new LogData();
            try {
                cf = confController.getConfData();
                dd = direController.getDirectorData();
                cd = haController.getData();
                ad = admController.getData();
                logData.admLog = this.setLogfile(cf.logger.admLog);
                logData.lbLog = this.setLogfile(cf.logger.lbLog);
                logData.lbLog.logLevel = ad.l7vsdLogLevel;
                logData.snmpLog = this.setLogfile(cf.logger.snmpLog);
                logData.snmpLog.logLevel = ad.snmpLogLevel;
                cf.logger.directorLog.fileName = dd.logfile.replaceAll("\"", "");
                logData.directorLog = this.setLogfile(cf.logger.directorLog);
                cf.logger.guiLog.fileName = GUI_LOG;
                logData.guiLog = this.setLogfile(cf.logger.guiLog);
                cf.logger.haLog.fileName = cd.logFileName;
                logData.haLog = this.setLogfile(cf.logger.haLog);
                cf.logger.syncLog.fileName = SYNC_LOG;
                logData.syncLog = this.setLogfile(cf.logger.syncLog);
            }
            catch (FileNotReadException e) {
                this.ioFileLogger.error((Object)("41216 Exception occured: " + e.getMessage()));
                logData = null;
            }
            catch (Exception e) {
                this.ioFileLogger.error((Object)("41217 Exception occured: " + e.getMessage()));
                logData = null;
            }
            if (this.ioFileLogger.isDebugEnabled()) {
                this.ioFileLogger.debug((Object)("11505 L7vsLogController::getData() out return=(" + logData + ")"));
            }
            return logData;
        }
    }

    protected LogSet setLogfile(LogSet logSet) {
        if (this.ioFileLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("L7vsLogController::setLogfile(LogSet logSet) in ");
            buf.append("cfLogSet=(" + logSet + ")");
            this.ioFileLogger.debug((Object)("11506 " + buf.toString()));
        }
        int suffix = 0;
        while (true) {
            String path = logSet.fileName;
            if (suffix > 0) {
                path = String.valueOf(path) + "." + suffix;
            }
            try {
                File log = new File(path);
                if (!log.isFile()) break;
                logSet.logFiles.add(new LogFileData(log.getName(), log.getAbsolutePath(), log.length(), new Date(log.lastModified())));
            }
            catch (NullPointerException e) {
                this.ioFileLogger.error((Object)("41218 Exception occured: " + e.getMessage()));
            }
            catch (Exception e) {
                this.ioFileLogger.error((Object)("41219 Exception occured: " + e.getMessage()));
            }
            ++suffix;
        }
        if (this.ioFileLogger.isDebugEnabled()) {
            this.ioFileLogger.debug((Object)("11507 L7vsLogController::setLogfile() out return=(" + logSet + ")"));
        }
        return logSet;
    }
}

