#ifndef __PARAMETER_H__
#define __PARAMETER_H__

#include <iostream>
#include "parameter_enum.h"

namespace l7vs
{
	class ParameterImpl;
	class Parameter
	{
	private:
		static Parameter instance;
		
	protected:
		Parameter();
		Parameter( const Parameter& );
		Parameter&	operator=( const Parameter& );
		~Parameter();
		
	public:
		bool	rereadFile(const PARAMETER_COMPONENT_TAG);
	
		static	Parameter& getInstance(){
			return	instance;
		}
		bool	isIntExist(const PARAMETER_COMPONENT_TAG, const std::string&);
		bool	isStringExist(const PARAMETER_COMPONENT_TAG, const std::string&);
		int	getIntValue(const PARAMETER_COMPONENT_TAG, const std::string&);
		std::string	getStringValue(const PARAMETER_COMPONENT_TAG, const std::string&);
		void	registerFunctionPointer(const PARAMETER_COMPONENT_TAG, void(*)());
	};
}
	
#endif	//__PARAMETER_H__
