%define prefix   /usr

#Uncomment these if they are not defined by your rpm macros file
%define _sysconfdir             /etc
%define _localstatedir          /var

Summary: The Layer-7 Virtual Server
Name: ultramonkey-l7
Version: 2.0.0
Release: 0
License: LGPL
Packager: Shinya TAKEBAYASHI
Group: Network
Source0: %{name}-%{version}-%{release}.tar.gz
BuildRoot: /var/tmp/%{name}-%{version}-root
Docdir: %{prefix}/doc
Provides: %{name}-%{version}-%{release}
BuildPrereq: automake autoconf libtool
#Requires:

%description
Layer-7 load balancer daemon that works with TCP splicing

%prep
rm -rf ${RPM_BUILD_ROOT}
%setup

%build

# I am providing my own configure macro replacement. Hopefully this
# will result in fewer portability problems than using the one supplied
# by various vendours. I fear that I hope in vein.
CFLAGS="${CFLAGS:-%optflags}" ; export CFLAGS
if [ -f confgure.in ]; then
	aclocal
	libtoolize --force --copy
	automake
	autoconf
fi
./configure %{_target_platform} \
	--prefix=%{_prefix} \
	--exec-prefix=%{_exec_prefix} \
	--bindir=%{_bindir} \
	--sbindir=%{_sbindir} \
	--sysconfdir=%{_sysconfdir} \
	--datadir=%{_datadir} \
	--includedir=%{_includedir} \
	--libdir=%{_libdir} \
	--libexecdir=%{_libexecdir} \
	--localstatedir=%{_localstatedir} \
	--sharedstatedir=%{_sharedstatedir} \
	--mandir=%{_mandir} \
	--infodir=%{_infodir} \
	--with-l7vs-moddir=%{_libdir}/l7vs

make -j2

%install
# rm -rf ${RPM_BUILD_ROOT}

# Manually install init script
#mkdir -p ${RPM_BUILD_ROOT}/etc/init.d/
#install -c -m 755 \
#        ${RPM_BUILD_DIR}/%{name}-%{version}/etc/init.d/l7vs.rh \
#               ${RPM_BUILD_ROOT}/etc/init.d/l7vs

# Install eveything else
#make DESTDIR=$RPM_BUILD_ROOT install

mkdir -p $RPM_BUILD_ROOT%{_sbindir}
mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}
mkdir -p $RPM_BUILD_ROOT%{_libdir}/l7vs
mkdir -p $RPM_BUILD_ROOT/var/run/l7vs
mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/init.d
mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/l7vs
mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/ha.d/conf

install -c -m 755 -D src/l7vsd src/l7vsadm $RPM_BUILD_ROOT%{_sbindir}
cp module/protocol/.libs/libprotomod_cinsert.so module/protocol/.libs/protomod_cinsert.so
cp module/protocol/.libs/libprotomod_sslid.so module/protocol/.libs/protomod_sslid.so
cp module/protocol/.libs/libprotomod_url.so module/protocol/.libs/protomod_url.so
cp module/protocol/.libs/libprotomod_sessionless.so module/protocol/.libs/protomod_sessionless.so
install -c -m 755 -D module/protocol/.libs/protomod_cinsert.so module/protocol/.libs/protomod_sslid.so module/protocol/.libs/protomod_url.so module/protocol/.libs/protomod_sessionless.so $RPM_BUILD_ROOT%{_libdir}/l7vs

cp module/schedule/.libs/libsched_lc.so module/schedule/.libs/sched_lc.so
cp module/schedule/.libs/libsched_rr.so module/schedule/.libs/sched_rr.so
cp module/schedule/.libs/libsched_wrr.so module/schedule/.libs/sched_wrr.so
install -c -m 755 -D module/schedule/.libs/sched_lc.so module/schedule/.libs/sched_rr.so module/schedule/.libs/sched_wrr.so $RPM_BUILD_ROOT%{_libdir}/l7vs

install -c -m 755 -D init.d/l7vsd $RPM_BUILD_ROOT%{_sysconfdir}/init.d
install -c -m 644 -D conf/l7vs.cf $RPM_BUILD_ROOT%{_sysconfdir}/l7vs

install -c -m 755 -D l7directord/l7directord $RPM_BUILD_ROOT%{_sbindir}
install -c -m 755 -D l7directord/init.d/l7directord $RPM_BUILD_ROOT%{_sysconfdir}/init.d
install -c -m 644 -D l7directord/conf/l7directord.cf $RPM_BUILD_ROOT%{_sysconfdir}/ha.d/conf



%clean
rm -rf $RPM_BUILD_ROOT

%post
mkdir -p /var/run/l7vs
chkconfig --add l7vsd

%postun
rm -rf /var/run/l7vs

%preun
chkconfig --del l7vsd

%files
%defattr(-, root, root, 0755)
#%{_localstatedir}/run/%{name}/
%{_sbindir}
%{_libdir}/l7vs/*
%config %{_sysconfdir}/init.d/*
%config %{_sysconfdir}/l7vs/*
%config %{_sysconfdir}/ha.d/*

#%doc README COPYING
#%{_mandir}

%changelog

