#define _GNU_SOURCE
#include <sys/types.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <fnmatch.h>
#include <getopt.h>
#include <glib.h>
#include "vanessa_logger.h"
#include "l7vs.h"
#include "sync_session.h" 
#include <netdb.h> //NI_NUMARICHOST

struct l7vs_chash_service {
        struct l7vs_service srv;
	char cookie_name[129];
	int cookie_offset;
	int cookie_length;
	int timeout;
	int max_list;
	int reschedule;
	GList *list;
};

struct  l7vs_chash_service_arg {
        struct l7vs_service_arg arg;
	char cookie_name[129];
	int cookie_offset;
	int cookie_length;
	int timeout;
	int max_list;
	int reschedule;
	GList *list;
};

int process_state;

static void fini(void);
static struct l7vs_service *create(struct l7vs_service_arg *arg);
static struct l7vs_service_arg *create_sa(void);
static int compare(struct l7vs_service *s1, struct l7vs_service *s2);
static int match_cldata(struct l7vs_service *srv, struct l7vs_conn *conn, char *buf, size_t *len, struct l7vs_dest **dest, int *tcps);
static int analyze_rsdata(struct l7vs_service *srv, struct l7vs_conn *conn, char *buf, size_t *len);
static void destroy(struct l7vs_service *srv);
static struct l7vs_service_arg *service_arg(struct l7vs_service *srv);
static int parse(struct l7vs_service_arg *arg, int argc, char *argv[]);

char *l7vs_protomod_chash_search(const char *s1, const char *s2, const char *s3);
int l7vs_protomod_chash_str_len(const char *s1, const char s2);
int l7vs_protomod_chash_dest_check(struct l7vs_service *srv, struct l7vs_conn *conn, struct l7vs_dest **dest);


static char *get_servicename(struct sockaddr_in *addr, int isnumeric);

static struct l7vs_protomod chash_protomod = {
        NULL,                   /* handle */
        "chash",                 /* modname */
        0,                      /* refcnt */
        create,                 /* create function */
        compare,                /* compare function */
        match_cldata,         	/* match_cldata function */
	analyze_rsdata,		/* analyze_rsdata function */
        destroy,                /* destroy function */
        fini,                   /* fini function */
        create_sa,              /* create_sa function */
        service_arg,            /* service_arg function */
        parse,                  /* parse function */
};

struct l7vs_protomod *
init(void *handle)
{
        chash_protomod.handle = handle;
        return &chash_protomod;
}

static void 
fini(void)
{
        /* XXX  maybe some work needed */
}

static struct l7vs_service *
create(struct l7vs_service_arg *arg)
{
        struct l7vs_chash_service *chs;
        struct l7vs_chash_service_arg *cha;

        chs = (struct l7vs_chash_service *)calloc(1, sizeof(*chs));
        if (chs == NULL) {
                VANESSA_LOGGER_ERR("Could not allocate memory");
                return (struct l7vs_service *)chs;
        }

        cha = (struct l7vs_chash_service_arg *)arg;
        strcpy(chs->cookie_name, cha->cookie_name);
	chs->cookie_offset = cha->cookie_offset;
	chs->cookie_length = cha->cookie_length;
	chs->timeout = cha->timeout;
	chs->max_list = cha->max_list;
        chs->reschedule = cha->reschedule;
	chs->list = cha->list;
        return (struct l7vs_service *)chs;
}

static struct l7vs_service_arg *
create_sa(void)
{
        struct l7vs_chash_service_arg *cha;

        cha = (struct l7vs_chash_service_arg *)calloc(1, sizeof(*cha));
        if (cha == NULL) {
                VANESSA_LOGGER_ERR("Could not allocate memory");
                return (struct l7vs_service_arg *)cha;
        }

        cha->arg.len = sizeof(*cha);
        strcpy(cha->arg.protomod, chash_protomod.modname);

        return (struct l7vs_service_arg *)cha;
}

static int
compare(struct l7vs_service *s1, struct l7vs_service *s2)
{
        struct l7vs_chash_service *ch1, *ch2;

        ch1 = (struct l7vs_chash_service *)s1;
        ch2 = (struct l7vs_chash_service *)s2;

	if (ch1->cookie_offset != ch2->cookie_offset) {
		return 1;
	}
	if (ch1->cookie_length != ch2->cookie_length) {
		return 1;
	}

        return strcmp(ch1->cookie_name, ch2->cookie_name);
}

static int
match_cldata(struct l7vs_service *srv, struct l7vs_conn *conn,
      char *buf, size_t *len, struct l7vs_dest **dest, int *tcps)
{
        struct l7vs_chash_service *chs;
	struct l7vs_dest d;
        struct cookie_list *cl, *cl_temp;
        time_t t;
        char *temp;
        int ret, f = -1, key_len;
        GList *l;

	int tindx=0;
	char * srvname;
	void *shared_memory=(void *)0;
	int sema_id,shmid;
	struct sync_info_st *sync_info;
	struct cookie_list *ckl;        
	unsigned vip_existence=0;
	unsigned vip_existence2=0;
	unsigned add_data=0;

        chs = (struct l7vs_chash_service *)srv;
        ret = srv->pm->initialize(srv, conn, buf, *len, dest);
        if (ret != 0){
                VANESSA_LOGGER_ERR("Could not initialize protomod");
                return -1;
	}

	/* check weather l7syncd_master is running or not if running it returns int 2 */
	process_state=check_process_state("/var/run/l7syncd_master.pid",1);

	if(process_state!=2)
	{
		VANESSA_LOGGER_ERR("l7syncd_master is not running");
	}
	if(process_state==2)
	{
	        sema_id=initialize_sem(key_sem_ck);
        	shmid=initialize_shm(key_shm_ck,sizeof(struct sync_info_st));
        	if (shmid == -1)
	        {
			VANESSA_LOGGER_ERR("chash shmget failed");
                	exit(EXIT_FAILURE);
	        }

	        shared_memory = shmat(shmid, (void *)0, 0);
	        if (shared_memory == (void *)-1)
        	{
                	VANESSA_LOGGER_ERR("chash shmat failed");
	        }
        	sync_info=(struct sync_info_st *)shared_memory;
	}

	srvname=get_servicename(&srv->lsock->addr,1);

	/*  reading from the shared memory and filling the glist  */
        if(process_state==2)  
	{
		int i=0;
		int lvipindx=0;
		int lvipindx2=0;
	        semaphore_lock(sema_id);

		for (i=0;i<VIP_SZ;i++)
		{
			if(sync_info->standby_flag==0)
			{
				add_data=1;
				if ((strcmp(srvname,sync_info->ckal[i].vip)==0) && (strcmp("chash        ",sync_info->ckal[i].protomod)==0))
				{
					break;
				}
				else if(strcmp(sync_info->ckal[i].vip,"")==0)
				{
					strcpy(sync_info->ckal[i].vip,srvname);
					strcpy(sync_info->ckal[i].protomod,"chash");
					break;
				}
			}
		}

		for (i=0;i<VIP_SZ;i++)
		{
			if (strcmp(srvname,sync_info->ckal[i].vip)==0)
			{
				lvipindx=i;
				vip_existence=1;
				break;
			}
		}
		if(sync_info->standby_flag==1)
		{
			for (i=0;i<VIP_SZ;i++)
			{
				if (strcmp(srvname,sync_info->vp[i].vip)==0)
				{
					lvipindx2=i;
					vip_existence2=1;
					break;
				}
			}
			if((vip_existence==1) && (vip_existence2==1))
			{
				if(strcmp(sync_info->ckal[lvipindx].protomod, sync_info->vp[lvipindx2].protomod)==0)
				add_data=1;
			}
		}
		if(add_data==1)
		{
 		/* If status changed i.e l7syc daemon changed master to backup vice versa */
        		if(sync_info->status_flag[lvipindx]==1)
        		{
                		int shi;
				if(strlen(sync_info->ckal[lvipindx].protomod)!=0)
				{
					for(shi=0;shi<SES_SZ;shi++)
					{
						if(strlen(sync_info->ckal[lvipindx].cklist_ary[shi].pattern)!=0)
	                			{
                                			cl_temp = (struct cookie_list *)calloc(1, sizeof(struct cookie_list));
                                			if (cl_temp == NULL) {
                                        			VANESSA_LOGGER_ERR("Could not allocate memory");
                                        			return -1;
                                			}

                                			memcpy(cl_temp,&sync_info->ckal[lvipindx].cklist_ary[shi],sizeof(struct cookie_list));
                                			chs->list = g_list_append(chs->list, cl_temp);

						}
                			}
                		}
        			sync_info->status_flag[lvipindx]=0;
			}
        	}
        	semaphore_unlock(sema_id);
        }

        t = time((time_t *)0);

        l = g_list_first(chs->list);
        while (l != NULL) {
                cl = (struct cookie_list *)l->data;
                if (cl->date < t) {
                        l = g_list_next(l);
                        chs->list = g_list_remove(chs->list, cl);
			free(cl);
                } else {
                        break;
                }
        }

        temp = l7vs_protomod_chash_search(buf, "\r\n\r\n", "Cookie:");
        if (temp == 0) goto OUT;

	do {
		temp = l7vs_protomod_chash_search(temp, "\r\n", chs->cookie_name);
		if (temp == 0) goto OUT;
	} while (temp[0] != '=');

        temp++;

        if (temp != 0){
                if ((cl_temp = (struct cookie_list *)calloc(1, sizeof(*cl_temp))) == NULL){
                        VANESSA_LOGGER_ERR("Could not allocate memory");
                        return -1;
                }
                key_len = l7vs_protomod_chash_str_len(temp, '\r');
		if (key_len < (chs->cookie_offset + chs->cookie_length)) {
			if (key_len < chs->cookie_offset) {
				VANESSA_LOGGER_INFO("Could not persist because the value of cookie is a too little");
				goto OUT;
			} else {
				temp += chs->cookie_offset;
				key_len -= chs->cookie_offset;
			}
		} else {
			temp += chs->cookie_offset;
			key_len = chs->cookie_length;
		}

                strncpy(cl_temp->pattern, temp, key_len);
                cl_temp->pattern[key_len] = '\0';
                cl_temp->date = (t + chs->timeout);

                l = g_list_first(chs->list);

                while (l != NULL) {
                        cl = (struct cookie_list *)l->data;
                        if (cl->date < cl_temp->date) {
                                if (strcmp(cl->pattern, cl_temp->pattern) == 0) {
                                        cl_temp->raddr = cl->raddr;
					d.addr = cl_temp->raddr;
					*dest = &d;
					ret = l7vs_protomod_chash_dest_check(srv, conn, dest);
					if (ret == 1) {
						cl_temp->raddr = (*dest)->addr;
					}
					chs->list = g_list_remove(chs->list ,cl);
					free(cl); 
                                        if (g_list_length(chs->list) == 0) {
                                                chs->list = g_list_append(chs->list, cl_temp);
                                                goto OUT;
                                        }
                                        for (l = g_list_last(chs->list); l != NULL; l = g_list_previous(l)) {
                                                cl = (struct cookie_list *)l->data;
                                                if (cl->date < cl_temp->date) {
                                                        f = g_list_index(chs->list, cl);
                                                        chs->list = g_list_insert(chs->list, cl_temp, (f+1));
                                                        goto OUT;
                                                }
                                        }
                                        chs->list = g_list_prepend(chs->list, cl_temp);
                                        goto OUT;
                                }
                                l = g_list_next(l);
                        } else {
                                if (f == -1) {
                                        f = g_list_index(chs->list, cl);
                                }
                                if (strcmp(cl->pattern, cl_temp->pattern) == 0) {
                                        cl_temp->raddr = cl->raddr;
                                        d.addr = cl_temp->raddr;
                                        *dest = &d;
					ret = l7vs_protomod_chash_dest_check(srv, conn, dest);
					if (ret == 1) {
						cl_temp->raddr = (*dest)->addr;
					}
                                        chs->list = g_list_remove(chs->list, cl);
					free(cl);
                                        chs->list = g_list_insert(chs->list, cl_temp, f);
                                        goto OUT;
                                }
                                l = g_list_next(l);
                        }
                }

                if (g_list_length(chs->list) >= chs->max_list){
                        VANESSA_LOGGER_ERR("Could not save cookie_list");
                        l = g_list_first(chs->list);
                        cl = (struct cookie_list *)l->data;
                        chs->list = g_list_remove(chs->list, cl);
			free(cl);
                }

                *dest = srv->scheduler->schedule(srv, conn);
                cl_temp->raddr = (*dest)->addr;

		if (f == -1) {
                        chs->list = g_list_append(chs->list, cl_temp);
                } else {
                        chs->list = g_list_insert(chs->list, cl_temp, f);
                }
        }
OUT:
	if (shmdt(shared_memory) == -1)
	{
		VANESSA_LOGGER_ERR("chash shmdt failed");
	}

        *tcps = 0;
        ret = srv->pm->finalize(srv, conn, buf, *len, dest, chs->reschedule);
        if (ret != 0){
                VANESSA_LOGGER_ERR("Could not finalize protomod");
                return -1;
        }
        return 0;
}

static int
analyze_rsdata(struct l7vs_service *srv, struct l7vs_conn *conn,
      char *buf, size_t *len)
{
        struct l7vs_chash_service *chs;
	struct cookie_list *cl, *cl_temp;
        time_t t;
        char *temp, *temp2;
        int ret, f = -1, key_len;
        GList *l;

        chs = (struct l7vs_chash_service *)srv;

	int retval=0;
	int tindx=0;
	char * srvname;
	void *shared_memory=(void *)0;
	int sema_id,shmid;
	struct sync_info_st *sync_info;
	struct cookie_list *ckl;	
	unsigned vip_existence=0;
	unsigned vip_existence2=0;
	unsigned add_data=0;

	if(process_state==2)
	{
		sema_id=initialize_sem(key_sem_ck);
		shmid=initialize_shm(key_shm_ck,sizeof(struct sync_info_st));
        	if (shmid == -1)
	        {
			VANESSA_LOGGER_ERR("chash shmget failed");
                	exit(EXIT_FAILURE);
	        }

		shared_memory = shmat(shmid, (void *)0, 0);
	        if (shared_memory == (void *)-1)
	        {
			VANESSA_LOGGER_ERR("chash shmat failed");
	        }
		sync_info=(struct sync_info_st *)shared_memory;
	}

	srvname=get_servicename(&srv->lsock->addr,1);


	t = time((time_t *)0);

        l = g_list_first(chs->list);

        while (l != NULL) {
                cl = (struct cookie_list *)l->data;
                if (cl->date < t) {
                        l = g_list_next(l);
                        chs->list = g_list_remove(chs->list, cl);
			free(cl);
                } else {
                        break;
                }
        }

	temp = l7vs_protomod_chash_search(buf, "\r\n\r\n", "Set-Cookie:");
	while (1) {
		if (temp == 0) 
		{
			retval=0;
			goto OUT;
		}
		temp2 = l7vs_protomod_chash_search(temp, "\r\n", chs->cookie_name);
		if ((temp2 != 0) && (temp2[0] == '=')) {
			temp = temp2 + 1;
			break;
		}
		else temp = l7vs_protomod_chash_search(temp, "\r\n\r\n", "Set-Cookie:");
	}
                                                                                
        if (temp != 0) {
                if ((cl_temp = (struct cookie_list *)calloc(1, sizeof(*cl_temp))) == NULL){
                        VANESSA_LOGGER_ERR("Could not allocate memory");
			retval=-1;
			goto OUT;
                }
                key_len = l7vs_protomod_chash_str_len(temp, '\r');
		if (key_len < (chs->cookie_offset + chs->cookie_length)) {
			if (key_len < chs->cookie_offset) {
				VANESSA_LOGGER_INFO("Could not persist because the value of cookie is a too little");
				retval=0;
				goto OUT;
			} else {
				temp += chs->cookie_offset;
				key_len -= chs->cookie_offset;
			}
		} else {
			temp += chs->cookie_offset;
			key_len = chs->cookie_length;
		}
                strncpy(cl_temp->pattern ,temp ,key_len);
                cl_temp->pattern[key_len] = '\0';
                cl_temp->raddr = conn->dest->addr;
                cl_temp->date = (t + chs->timeout);

                l = g_list_first(chs->list);

                while (l != NULL) {
                        cl = (struct cookie_list *)l->data;
			if (cl->date < cl_temp->date) {
                                if (strcmp(cl->pattern, cl_temp->pattern) == 0) {
                                        chs->list = g_list_remove(chs->list ,cl);
					free(cl);
                                        if (g_list_length(chs->list) == 0) {
                                                chs->list = g_list_append(chs->list, cl_temp);
						retval=0;
						goto OUT;
                                        }
                                        for (l = g_list_last(chs->list); l != NULL; l = g_list_previous(l)) {
                                                cl = (struct cookie_list *)l->data;
                                                if (cl->date < cl_temp->date) {
                                                        f = g_list_index(chs->list, cl);
                                                        chs->list = g_list_insert(chs->list, cl_temp, (f+1));
							retval=0;
							goto OUT;
                                                }
                                        }
                                        chs->list = g_list_prepend(chs->list, cl_temp);
					retval=0;
					goto OUT;
                                }
                                l = g_list_next(l);
                        } else {
                                if (f == -1) {
                                        f = g_list_index(chs->list, cl);
                                }
                                if (strcmp(cl->pattern, cl_temp->pattern) == 0) {
                                        chs->list = g_list_remove(chs->list, cl);
					free(cl);
                                        chs->list = g_list_insert(chs->list, cl_temp, f);
					retval=0;
					goto OUT;
                                }
                                l = g_list_next(l);
                        }
                }

                if (g_list_length(chs->list) >= chs->max_list){
                        VANESSA_LOGGER_ERR("Could not save cookie_list");
                        l = g_list_first(chs->list);
                        cl = (struct cookie_list *)l->data;
                        chs->list = g_list_remove(chs->list, cl);
			free(cl);
                }

                if (f == -1) {
                        chs->list = g_list_append(chs->list, cl_temp);
			retval=0;
			goto OUT;
                } else {
                        chs->list = g_list_insert(chs->list, cl_temp, f);
			retval=0;
			goto OUT;
                }
        }

OUT:

        if(process_state==2)  
	{
		int i=0;
		int lvipindx=0;
		semaphore_lock(sema_id);

                for (i=0;i<VIP_SZ;i++)
                {
			if (strcmp(srvname,sync_info->ckal[i].vip)==0)
			{
				lvipindx=i;
				vip_existence=1;
			        break;
		        }
		}
		strcpy(sync_info->ckal[lvipindx].cookie_name,chs->cookie_name);

	      	// Reading session information and writing into the shared memory
	      	for(l=g_list_first(chs->list);l!=NULL;l=g_list_next(l))
	      	{
	               	ckl=(struct cookie_list *)l->data;
	              	sync_info->ckal[lvipindx].cklist_ary[tindx]=*ckl;

			if(tindx<SES_SZ)
				tindx++;
	       	}
		semaphore_unlock(sema_id);

        	if (shmdt(shared_memory) == -1)
	        {
        	        VANESSA_LOGGER_ERR("chash shmdt failed");
	        }
	}

	return retval;
}

static void
destroy(struct l7vs_service *srv)
{
	free(srv);
}

static struct l7vs_service_arg *
service_arg(struct l7vs_service *srv)
{
        struct l7vs_chash_service *chs;
        struct l7vs_chash_service_arg *cha;
	char temp[512];
	char *ptr;

        chs = (struct l7vs_chash_service *)srv;

        cha = (struct l7vs_chash_service_arg *)malloc(sizeof(*cha));
        memset(cha, 0, sizeof(*cha));
        if (cha == NULL) {
                VANESSA_LOGGER_ERR("Could not allocate memory");
                return (struct l7vs_service_arg *)cha;
        }

        cha->arg.len = sizeof(*cha);
        cha->reschedule = chs->reschedule;
        strcpy(cha->cookie_name, chs->cookie_name);
	cha->timeout = chs->timeout;
	cha->max_list = chs->max_list;
	cha->list = chs->list;
	cha->cookie_offset = chs->cookie_offset;
	cha->cookie_length = chs->cookie_length;

	ptr = temp;
	cha->arg.reschedule = chs->reschedule;
	sprintf(ptr, "--cookie-name %s\0", chs->cookie_name);
	strcpy(cha->arg.protomod_key_string, ptr);
	sprintf(ptr + strlen(ptr), " --offset %d --length %d --timeout %d --max-list %d\0", chs->cookie_offset, chs->cookie_length, chs->timeout, chs->max_list);
	strcpy(cha->arg.protomod_opt_string, ptr);
	
        return (struct l7vs_service_arg *)cha;
}

static int
parse(struct l7vs_service_arg *arg, int argc, char *argv[])
{
        static struct option opt[] = {
                {"cookie-name",	required_argument,	NULL, 'C'},
		{"offset",	required_argument,	NULL, 'O'},
		{"length",	required_argument,	NULL, 'L'},
		{"timeout",	required_argument,	NULL, 'T'},
		{"max-list",	required_argument,	NULL, 'M'},
                {"reschedule",  no_argument,		NULL, 'F'},
                {"no-reschedule",no_argument,		NULL, 'N'},
                {NULL,          0,                      NULL, 0}
        };
        struct l7vs_chash_service_arg *cha = (struct l7vs_chash_service_arg *)arg;
        int c;
	int c1 = 0, c2 = 0, c3 = 0, c4 = 0, c5 = 0, c6 = 0;

        optind = 0;


	char * srvname;
	void *shared_memory=(void *)0;
	int sema_id,shmid;
	struct sync_info_st *sync_info;
	int i=0;

	srvname=get_servicename(&arg->addr,1);

	/* check weather l7syncd_master is running or not if running it returns 2 */
	process_state=check_process_state("/var/run/l7syncd_master.pid",1);
	
	if(process_state!=2)
	{
		VANESSA_LOGGER_ERR("l7syncd_master is not running");
	}

	if(process_state==2)
	{
		sema_id=initialize_sem(key_sem_ck);
		shmid=initialize_shm(key_shm_ck,sizeof(struct sync_info_st));
        	if (shmid == -1)
	        {
			VANESSA_LOGGER_ERR("chash shmget failed");
                	exit(EXIT_FAILURE);
	        }

		shared_memory = shmat(shmid, (void *)0, 0);
	        if (shared_memory == (void *)-1)
	        {
			VANESSA_LOGGER_ERR("chash shmat failed");
	        }
		sync_info=(struct sync_info_st *)shared_memory;
	}

        while ((c = getopt_long(argc, argv, "C:O:L:T:M:", opt, NULL)) != -1) { 
                switch (c) {
                case 'C':
                        if (strlen(optarg) >= sizeof(cha->cookie_name)) {
                                VANESSA_LOGGER_ERR_UNSAFE(
                                                "%s: path too long",
                                                optarg);
                                return -1;
                        }
                        strcpy(cha->cookie_name, optarg);
			c1++;
                        break;
		case 'O':
			if (atoi(optarg) < 0) {
				VANESSA_LOGGER_ERR("You can't specify less than 0");
				return -1;
			}
			cha->cookie_offset = atoi(optarg);
			c4++;
			break;
		case 'L':
			if (atoi(optarg) < 1) {
                                VANESSA_LOGGER_ERR("You can't specify less than 1");
                                return -1;
                        }
			cha->cookie_length = atoi(optarg);
			c5++;
			break;
		case 'T':
                        if (atoi(optarg) < 0) {
                                VANESSA_LOGGER_ERR("You can't specify less than 0");
                                return -1;
                        }
                        cha->timeout = atoi(optarg);
                        c2++;
                        break;
                case 'M':
                        if (atoi(optarg) < 1) {
                                VANESSA_LOGGER_ERR("You can't specify less than 1");
                                return -1;
                        }
                        cha->max_list = atoi(optarg);
                        c3++;
                        break;
                case 'F':
                        cha->reschedule = 1;
			c6++;
                        break;
		case 'N':
			cha->reschedule = 0;
			c6++;
			break;
                default:
                        return -1;
                }
        }

	if (c6 == 2) {
		VANESSA_LOGGER_ERR("You should choose either of reschdule or no-reschedule");
		return -1;
        }

	if (c6 == 0) {
		cha->reschedule = 1;
	}

	if (c2 == 0) {
		cha->timeout = 86400;
	}

	if (c3 == 0) {
		cha->max_list = 1000;
	}
	
	if (c4 == 0) {
		cha->cookie_offset = 0;
	}

	if (c5 == 0) {
		cha->cookie_length = 1;
	}

	if (c1 == 1) {


	if(process_state==2)
	{
	        semaphore_lock(sema_id);
                
		if(sync_info->standby_flag==1)
                {
			for (i=0;i<VIP_SZ;i++)
			{
				if ((strcmp(srvname,sync_info->vp[i].vip)==0) && (strcmp("chash",sync_info->vp[i].protomod)==0))
				{
				        break;
			        }
				else if(strcmp(sync_info->vp[i].vip,"")==0)
				{
					strcpy(sync_info->vp[i].vip,srvname);
					strcpy(sync_info->vp[i].protomod,"chash");
					break;
				}
			}
		}
		semaphore_unlock(sema_id);
        	if (shmdt(shared_memory) == -1)
	        {
        	        VANESSA_LOGGER_ERR("chash shmdt failed");
	        }
	}	

		return 0;
	} else {
		VANESSA_LOGGER_ERR("you must write only cookie-name"); 
		return -1;
	}

}

char *
l7vs_protomod_chash_search(const char *s1, const char *s2, const char *s3)
{
        int i, j;
        char c0, c1, c2, c3;

        if (*s2 == 0 || *s3 == 0) {
                return 0;
        }

        while (*s1) {
                i = 0; j = 0;
                c0 = toupper(s1[i]);
                c1 = toupper(s1[j]);
                c2 = toupper(s2[i]);
                c3 = toupper(s3[j]);

                while (1) {
                        if (s3[j] == 0) return (char *) (s1 + j);
                        if (s2[i] == 0) return 0;

                        if (c2 != c0 && c3 != c1) break;
                        if (c2 == c0) {
                                i++;
                                c0 = toupper(s1[i]);
                                c2 = toupper(s2[i]);
                        }
                        if (c3 == c1) {
                                j++;
                                c1 = toupper(s1[j]);
                                c3 = toupper(s3[j]);
                        }
                }
                s1++;
        }
        return 0;
}

int
l7vs_protomod_chash_str_len(const char *s1, const char s2)
{
	int i = 0;

	while (*s1) {
		if (s1[0] == ' ')
			return i;
		if (s1[0] == ';')
			return i;
		if (s1[0] == '"')
			return i;
		if (s1[0] == '\t')
			return i;
		if (s1[0] == s2)
			return i;
		s1++;
		i++;
	}
	return i;
}

int
l7vs_protomod_chash_dest_check(struct l7vs_service *srv, struct l7vs_conn *conn, struct l7vs_dest **dest)
{
	GList *l;
	struct l7vs_dest *d;

	if ((*dest) != NULL) {
		for (l = g_list_first(srv->dest_list); l != NULL; l = g_list_next(l)) {
			d = (struct l7vs_dest *)l->data;
			if ((d->addr.sin_addr.s_addr == (*dest)->addr.sin_addr.s_addr) &&
			    (d->addr.sin_port == (*dest)->addr.sin_port)) {
				*dest = d;
				return 0;
			}
		}
	}
	*dest = srv->scheduler->schedule(srv, conn);
	if ((*dest) == NULL) {
		VANESSA_LOGGER_ERR("realserver nonexistence");
		return -1;
	}
	return 1;
}

/* reference from l7vsadm.c */
static char *get_servicename(struct sockaddr_in *addr, int isnumeric)
{
        char *sname;
        char hostname[40], portname[20];
        int flags;
        int ret;

        flags = 0;
        if (isnumeric) {
                flags = NI_NUMERICHOST | NI_NUMERICSERV;
        }

        ret = getnameinfo((struct sockaddr *)addr, sizeof(*addr),
                          hostname, sizeof(hostname),
                          portname, sizeof(portname), flags);
        if (ret != 0) {
                VANESSA_LOGGER_ERR_UNSAFE("getnameinfo: %s",
                                          gai_strerror(ret));
                return NULL;
        }

        ret = asprintf(&sname, "%s:%s", hostname, portname);
        if (ret < 0) {
                VANESSA_LOGGER_ERR("Could not allocate memory");
                return NULL;
        }

        return sname;
}

