#define _GNU_SOURCE     /* for getopt_long() */
#include <getopt.h>
#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include<errno.h>
#include<fcntl.h>
#include<unistd.h>
#include <netdb.h>
#include <time.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <sys/time.h>
#include "../sync_session.h"
#include <signal.h>
#include <vanessa_logger.h>
#include <sys/utsname.h>//uname

#include <netinet/in.h>
#include <arpa/inet.h>

/* This value is using to set the index of the session maintaining array */
#define LOCAL_CK_SIZE 399
/* This value is using for debuggin */
#define DEBUG 0 

#define PORT_NUMBER 5566
#define BUFFER_SIZE 1024
/* Path of the log file */
#define LOG_FILE_NAME "/var/log/l7syncd.log" 


void *shm_area;
int shmid,sema_id;
struct sync_info_st *sync_info;
char *ipaddr;

/* Using for the process pid file */
char file[10]="/var/run/";

int timerval=0;
static int running=1;
static int lets_go=0;
static int tflag1=0;
int debug = 0;


struct cookie_ad_info 
{
        char vip[30];
	char protomod[16];
	char cookie_name[129];
	struct cookie_list cklist_ary[400];
	unsigned int ckindx;
	unsigned int vipindx;
};

struct cookie_ad_info *ckainfo; 

static void set_while_flag_handler(int sig);

/* To Send the session information */
static void send_data(int , struct sockaddr_in *, struct cookie_ad_info *,int,int,int);

/* When timeout occur(SIGALRM) this function will be called */
void timer_handler(int sig)
{
	tflag1=1;
}

static void dummy_handler(int sig)
{
        signal(sig, dummy_handler);
}

static void lets_go_handler(int sig)
{
        signal(sig, lets_go_handler);
        lets_go = sig;
}

/* 
 * To be used 
void remove_shm()
{
        if (shmdt(shm_area) == -1)
        {
		VANESSA_LOGGER_ERR_UNSAFE("Error in shmdt due to %s",strerror(errno));
        }
       
	if (shmctl(shmid, IPC_RMID, 0) == -1)
        {
		VANESSA_LOGGER_ERR_UNSAFE("Error in semctl shared memory due to %s",strerror(errno));
        }

        if(semctl(sema_id,IPC_RMID,0)==-1)
        {
		VANESSA_LOGGER_ERR_UNSAFE("Error in semctl semaphore due to %s",strerror(errno));
        }
}
*/

void set_signals(void)
{
        signal(SIGHUP, SIG_IGN);
        signal(SIGINT, set_while_flag_handler);
        signal(SIGQUIT, lets_go_handler);
        signal(SIGKILL, lets_go_handler);
        signal(SIGTRAP, lets_go_handler);
        signal(SIGIOT, lets_go_handler);
        signal(SIGBUS, lets_go_handler);
        signal(SIGFPE, lets_go_handler);
        signal(SIGUSR1, SIG_IGN);
        signal(SIGUSR2, SIG_IGN);
        signal(SIGSEGV, lets_go_handler);
        signal(SIGPIPE, SIG_IGN);
        signal(SIGTERM, set_while_flag_handler);
        signal(SIGCHLD, dummy_handler);
        signal(SIGURG, lets_go_handler);
        signal(SIGXCPU, lets_go_handler);
        signal(SIGVTALRM, lets_go_handler);
        signal(SIGPROF, lets_go_handler);
        signal(SIGWINCH, SIG_IGN);
        signal(SIGIO, lets_go_handler);
}

/* initializing the time for every x(timerval) sec's */
void init_timer()
{
        struct itimerval itval;
        signal(SIGALRM,timer_handler);
        itval.it_interval.tv_sec=timerval;
        itval.it_interval.tv_usec=0;

        itval.it_value.tv_sec=0;
        itval.it_value.tv_usec=1;

        if(setitimer(ITIMER_REAL,&itval,NULL)==-1)
        {
		VANESSA_LOGGER_ERR_UNSAFE("Error in set timer function: %s", strerror(errno));
        }

}

/* Display usage message */
static void usage(FILE *fp, char *ident)
{
        fprintf(fp,
                "Usage: %s [-d] [-h]\n"
                "   -d    --debug        run in debug mode (in foreground)\n"
                "   -t    --timer-value        Time Interval\n"
                "   -h    --help         print this help messages and exit\n",
                ident);
}

int main(int argc, char *argv[])
{
	int msflag;

        int i=0;
        struct sockaddr_in saddr;
        int sfd,rnbytes;

	fd_set rfds;
        struct timeval stval;
        int retval;
	time_t t;
	struct tm *tms;
	char timebuf[120];
	char logstr[20] = "l7syncd";
	char send_addr[20];
	struct ck_list_ary_st *cka_list;

        vanessa_logger_t *vl;

	int c,c3=0;
        int ret;

        static struct option options[] = {
                {"debug",               no_argument,            NULL, 'd'},
                {"timer-value",        required_argument,       NULL, 't'},
                {"help",                no_argument,            NULL, 'h'},
                {NULL,                  0,                      NULL, 0}
        };

        while ((c = getopt_long(argc, argv, "dt:", options, NULL)) != -1) {
                switch (c) {
                case 'd':
                        debug = 1;
                        break;
                case 't':
			timerval=atoi(optarg);
			if(timerval<=0)
			{
				timerval=10;
			}
			c3++;
                        break;
                case '?':
                default:
                        fprintf(stderr, "%s: unknown option: %s\n",
                                argv[0], argv[optind - 1]);
                        usage(stderr, argv[0]);
                        exit(1);
                        break;
                case 'h':
                        usage(stdout, argv[0]);
                        exit(0);
                        break;
                }
        }

	if(c3==0)
	{
		timerval=10;
	}

        if (debug) {
                vl = vanessa_logger_openlog_filehandle(stderr, argv[0],
                                                       LOG_DEBUG, 0);
        } else {
                ret = daemon(0, 0);
                if (ret < 0) {
                        perror("daemon() failed");
                        exit(1);
                }
        	vl = vanessa_logger_openlog_filename(LOG_FILE_NAME, logstr , LOG_INFO, VANESSA_LOGGER_F_TIMESTAMP);//v5

        }

        vanessa_logger_set(vl);
	VANESSA_LOGGER_INFO_UNSAFE("Timer value set to:\t%d\n",timerval);

        if(strstr(argv[0],"l7syncd_master")!=NULL) 
        {
                msflag=1;//master
		strcpy(process_file,"l7syncd_master.pid");
		file_path=strcat(file,process_file);
		if(check_process_state(process_file,0)==0)
		{
			exit(1);
		}
		VANESSA_LOGGER_INFO("Starting synchronization daemon +++++ as Master");
        }
        if(strstr(argv[0],"l7syncd_backup")!=NULL) 
        {
                msflag=2;//standby
		strcpy(process_file,"l7syncd_backup.pid");
		file_path=strcat(file,process_file);
		if(check_process_state(process_file,0)==0)
		{
			exit(1);
		}
		VANESSA_LOGGER_INFO("Starting synchronization daemon ++++++ as Standby");
        }

	        ckainfo=(struct cookie_ad_info *)calloc(1,sizeof(*ckainfo));
	if(msflag==1) 
	{
	        char eth_status[10];
	        char system_ip[20];
		char ip_addr[20];
		char node_name[20];

		char *buffer;
		buffer=(char *)calloc(1,BUFFER_SIZE);

		struct utsname unst;

	        bzero(eth_status,10);
	        bzero(system_ip,20);
		
       		uname(&unst);

	        system("/sbin/ifconfig  >> ethernet_status.txt");
	        system("hostname -i >> system_ip.txt");

	        FILE *eth,*sip;
		FILE *hosts;

	        eth=fopen("ethernet_status.txt","r");
        	if(eth==NULL)
		{
			VANESSA_LOGGER_ERR("error in ethernet_status.txt file open");
		}
	        else
        	        fscanf(eth,"%s",eth_status);
		fclose(eth);

        	sip=fopen("system_ip.txt","r");
	        if(sip==NULL)
		{
			VANESSA_LOGGER_ERR("error in system_ip.txt file open");
		}
	        else
                	fgets(system_ip,20,sip);
		fclose(sip);

        	if(strcmp(eth_status,"eth0")!=0)
		{
			VANESSA_LOGGER_ERR("Ethernet service is not running");
		}

	        unlink("system_ip.txt");
	        unlink("ethernet_status.txt");

	        hosts=fopen("/etc/hosts","r");
	        if(hosts==NULL)
		{
			VANESSA_LOGGER_ERR("error in hosts file open");
		}
	        else
        	{
                	while(!feof(hosts))
                	{
                        	fgets(buffer,BUFFER_SIZE,hosts);
	                        if(buffer[0]!='#')
        	                {
					sscanf(buffer,"%s %s",ip_addr,node_name);
                			if(strcmp(node_name,"localhost.localdomain")!=0)
					{
						if(strcmp(unst.nodename,node_name)!=0)
						{
							strcpy(send_addr,ip_addr);
							break;
						}
							
					}
                        	}
                	}
        	}
		fclose(hosts);
		free(buffer);
	}

	set_signals();

        sfd=socket(AF_INET,SOCK_DGRAM,0);
        if(sfd==-1)
        {
		VANESSA_LOGGER_ERR_UNSAFE("Error in socket creation: %s", strerror(errno));
                return -1;
        }

        saddr.sin_family=AF_INET;
        saddr.sin_port=htons(PORT_NUMBER);

	shmid=initialize_shm(key_shm_ck,sizeof(struct sync_info_st));
        if (shmid == -1)
	{
		VANESSA_LOGGER_ERR("l7syncd shmget failed");
		exit(EXIT_FAILURE);
	}
       	VANESSA_LOGGER_INFO_UNSAFE("l7syncd shared meory with  Vips=%d  Sessions=%d\n",VIP_SZ,SES_SZ);
	shm_area = shmat(shmid, (void *)0, 0);
	sema_id = initialize_sem(key_sem_ck);
	if (shm_area == (void *)-1)
	{
		VANESSA_LOGGER_ERR_UNSAFE("l7sycd shared memory attach failed: %s", strerror(errno));
	}
	sync_info=(struct sync_info_st *)shm_area;

	if(isStandby()==1)
	{
		semaphore_lock(sema_id);
		sync_info->standby_flag=1;
		semaphore_unlock(sema_id);
	}

        if(msflag==2) 
	{

		saddr.sin_addr.s_addr=INADDR_ANY;
		if(bind(sfd,(struct sockaddr *)&saddr,sizeof(saddr))<0)
        	{
			VANESSA_LOGGER_ERR_UNSAFE("Error in bind: %s", strerror(errno));
	                return -1;
        	}
	
	        cka_list=(struct ck_list_ary_st *)calloc(1,sizeof(*cka_list));

	}
        if(msflag==1) 
	{
		init_timer();
        	saddr.sin_addr.s_addr=inet_addr(send_addr);//setting destination ip;
	}

	while(running)
	{
        	sema_id =initialize_sem(key_sem_ck);
		t=time(&t);
		tms=localtime(&t);
		strftime(timebuf,sizeof(timebuf),"%c",tms);
	if(msflag==1) 
	{
	if(tflag1==1)
	{
	//VANESSA_LOGGER_INFO_UNSAFE("time : %s\n",timebuf);
	fprintf(stderr, "time : %s\n",timebuf);
	semaphore_lock(sema_id);
	int vindx;
	for(vindx=0;vindx<VIP_SZ;vindx++)
	{
                if(strlen(sync_info->ckal[vindx].protomod)!=0)
                {
			int j,k;
			unsigned iflag=0;
			ckainfo->vipindx=vindx;	

    	        	strcpy(ckainfo->protomod,sync_info->ckal[vindx].protomod);
			strcpy(ckainfo->cookie_name,sync_info->ckal[vindx].cookie_name);
		        strcpy(ckainfo->vip,sync_info->ckal[vindx].vip);

        		for(j=0,k=0;j<SES_SZ;j++,k++)
        		{
				if(k==400)
				{
					k=0;
					send_data(sfd, &saddr, ckainfo,i,j,vindx);
					ckainfo->cklist_ary[k]=sync_info->ckal[vindx].cklist_ary[j];
					ckainfo->ckindx=j-1;	
					iflag=0;
				}
				else
				{	
					if(iflag==0)
					{
						if(j!=0)
							ckainfo->ckindx=j-1;	
						else
							ckainfo->ckindx=j;	
						iflag=1;
					}
					ckainfo->cklist_ary[k]=sync_info->ckal[vindx].cklist_ary[j];
					ckainfo->ckindx=j;	

				#if DEBUG 
					fprintf(stderr,"Sent %d %d Pattern \t: %s\n",i,j,sync_info->ckal[vindx].cklist_ary[j].pattern);
					fprintf(stderr,"Sent %d %d Time \t: %u\n ",i,j,(unsigned short)(sync_info->ckal[vindx].cklist_ary[j].date));
					ipaddr=inet_ntoa(sync_info->ckal[vindx].cklist_ary[j].raddr.sin_addr);
				       	fprintf(stderr,"Sent %d %d IPaddr %s\n",i,j,ipaddr);
				       	fprintf(stderr,"\n");
				#endif
				}
				if(j==SES_SZ-1)
				{
					send_data(sfd, &saddr, ckainfo,i,j,vindx);
				}
			}
                }//strlen
	}//for vindx 
        semaphore_unlock(sema_id);
	tflag1=0;
	}//tflag
	}//master

	if(msflag==2) 
	{
		FD_ZERO(&rfds);
                FD_SET(sfd,&rfds);
                stval.tv_sec=3*timerval;
                stval.tv_usec=0;

                retval=select(sfd+1,&rfds,NULL,NULL,&stval);
                if(retval<0)
                {
			//remove_shm(); //to be used
			if(debug)
                        	perror("select error");
			VANESSA_LOGGER_ERR("Exiting L7Synchronization daemon");
			unlink(file_path);
	                exit(EXIT_FAILURE);
                }
                if(FD_ISSET(sfd,&rfds))
                {
                	rnbytes=recvfrom(sfd,ckainfo,sizeof(*ckainfo),0,0,0);
		        if(rnbytes<0)
		        {
				VANESSA_LOGGER_ERR_UNSAFE("Error in receiving data: %s", strerror(errno));
        		}
		        else
		        {
				int k=0;
				int l,n;
				unsigned int lvipindx=0;
				unsigned int tempcki=0;

				l=ckainfo->ckindx;
				lvipindx=ckainfo->vipindx;
				tempcki=l-LOCAL_CK_SIZE;
				printf("Received ckindx :%u\t and vipindx :%u\n",l,lvipindx);

				if(strcmp(ckainfo->protomod,"cpassive")==0)
				{
					k=0;
	       				semaphore_lock(sema_id);
                			strcpy(sync_info->ckal[lvipindx].protomod,ckainfo->protomod);
			                strcpy(sync_info->ckal[lvipindx].cookie_name,ckainfo->cookie_name);
			                strcpy(sync_info->ckal[lvipindx].vip,ckainfo->vip);
       					semaphore_unlock(sema_id);
				}
				if(strcmp(ckainfo->protomod,"chash")==0)
				{
					k=1;
	       				semaphore_lock(sema_id);
                			strcpy(sync_info->ckal[lvipindx].protomod,ckainfo->protomod);
			                strcpy(sync_info->ckal[lvipindx].cookie_name,ckainfo->cookie_name);
			                strcpy(sync_info->ckal[lvipindx].vip,ckainfo->vip);
       					semaphore_unlock(sema_id);
				}
				if(strcmp(ckainfo->protomod,"urla")==0)
				{
					k=2;
	       				semaphore_lock(sema_id);
                			strcpy(sync_info->ckal[lvipindx].protomod,ckainfo->protomod);
			                strcpy(sync_info->ckal[lvipindx].cookie_name,ckainfo->cookie_name);
			                strcpy(sync_info->ckal[lvipindx].vip,ckainfo->vip);
       					semaphore_unlock(sema_id);
				}

       				semaphore_lock(sema_id);
				if(k==0 || k==1 || k==2)
				{
        				for(n=0;n<400;n++,l++)
					{
						sync_info->ckal[lvipindx].cklist_ary[tempcki]=ckainfo->cklist_ary[n];
			
					#if DEBUG 

					if(n<4 && l<400){
						printf(" %u Received %u Cookie: %s\n",lvipindx,tempcki,sync_info->ckal[lvipindx].cookie_name);
					        printf(" %u Received %u Pattern: %s\n",lvipindx,tempcki,sync_info->ckal[lvipindx].cklist_ary[tempcki].pattern);
					        printf(" %u Received %u Time: %u\n",lvipindx,tempcki,(unsigned short)sync_info->ckal[lvipindx].cklist_ary[tempcki].date);
						ipaddr=inet_ntoa(sync_info->ckal[lvipindx].cklist_ary[tempcki].raddr.sin_addr);
					       	printf(" %u Received %u IPaddr: %s\n",lvipindx,tempcki,ipaddr);
					        printf("\n");
						}
					#endif
						tempcki++;
					}
				}
       				semaphore_unlock(sema_id);
        		}
 		}
                else
		{
			if(debug)
			{
	        	        printf("+++++++++++++++++No data within %d seconds.\n",3*timerval);
		        	fprintf(stderr, "time : %s\n",timebuf);
			}
			VANESSA_LOGGER_INFO_UNSAFE("No data received from master within %d seconds", 3*timerval);
		}

	}

	}//while
	//remove_shm(); //to be used
	VANESSA_LOGGER_INFO("Exiting L7Synchronization daemon sucessfully.");
	vanessa_logger_unset();
	if(vl)
	{
		vanessa_logger_closelog(vl);
	}
        return 0;
}

static void set_while_flag_handler(int sig)
{
	int i;
	semaphore_lock(sema_id);
	for(i=0;i<VIP_SZ;i++)
                sync_info->status_flag[i]=1;
		
	semaphore_unlock(sema_id);
        if (shmdt(shm_area) == -1)
        {
		VANESSA_LOGGER_ERR_UNSAFE("Error in shmdt due to %s",strerror(errno));
        }
	VANESSA_LOGGER_ERR("Change occured in l7syncd status");
	unlink(file_path);
	free(ckainfo); 
	running=0;
}


static void send_data(int fd, struct sockaddr_in *sadr, struct cookie_ad_info *cklainfo,int i, int j, int vindx)
{
	int snbytes;
    	snbytes=sendto(fd,cklainfo,sizeof(*cklainfo),0,(struct sockaddr *)sadr,sizeof(*sadr));
	if(snbytes==-1)
	{
		VANESSA_LOGGER_ERR("Error in sending synchronization information");
	}	
       else
	{
		if(debug)
		{
			fprintf(stderr,"%d bytes sent \n",snbytes);
                	fprintf(stderr,"Sent Protocol Module name : %s\n",sync_info->ckal[vindx].protomod);
			fprintf(stderr,"Sent Cooke \t: %s\n",sync_info->ckal[vindx].cookie_name);	
		        fprintf(stderr,"Sent VIP \t: %s\n",sync_info->ckal[vindx].vip);
	                fprintf(stderr,"\n");
		}
	}
}
