#define _POSIX_SOURCE
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/select.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <stdio.h>
#include "tcps.h"

#define VIRT_SERVICE_PORT	8000
#define HTTP_SERVICE_PORT	80 /* XXX Should use getservbyname() instead */
const char reqstr[] = "GET / HTTP/1.0\r\n\r\n";

static int
serversock(struct sockaddr_in *claddr)
{
	int s, as;
	int ret;
	struct sockaddr_in sin;
	socklen_t len;

	s = socket(PF_INET, SOCK_STREAM, 0);
	if (s < 0) {
		perror("socket");
		exit(1);
	}

	memset(&sin, 0, sizeof(sin));
	sin.sin_family = AF_INET;
	sin.sin_addr.s_addr = htonl(INADDR_ANY);
	sin.sin_port = htons(VIRT_SERVICE_PORT);

	ret = bind(s, (struct sockaddr *)&sin, sizeof(sin));
	if (ret < 0) {
		perror("bind");
		exit(1);
	}

	ret = listen(s, 5);
	if (ret < 0) {
		perror("listen");
		exit(1);
	}

	return s;
}

static int
vsrvaccept(int ls, struct sockaddr_in *claddr)
{
	int as;
	socklen_t len;

	memset(claddr, 0, sizeof(*claddr));
	len = sizeof(*claddr);
	as = accept(ls, (struct sockaddr *)claddr, &len);
	if (ls < 0) {
		perror("accept");
		exit(1);
	}

	return as;
}

int
main(int argc, char *argv[])
{
	int s, ls, as;
	int ret;
	struct sockaddr_in sin, claddr;
	char buf[16];
	fd_set readfds;

	if (argc < 2) {
		fprintf(stderr, 
			"Usage: tcpstest <IP-address>\n"
			"   <IP-address>: HTTP server's IP address\n");
		exit(1);
	}

	ls = serversock(&claddr);

repeat:
	as = vsrvaccept(ls, &claddr);
	s = socket(PF_INET, SOCK_STREAM, 0);
	if (s < 0) {
		perror("socket");
		exit(1);
	}
	ret = setsockopt(s, IPPROTO_IP, TCPS_SO_SET_SOURCE_FAKE,
			 &claddr, sizeof(claddr));
	if (ret < 0) {
		perror("setsockopt TCPS_SO_SET_SOURCE_FAKE");
		exit(1);
	}

	sin.sin_family = AF_INET;
	sin.sin_addr.s_addr = inet_addr(argv[1]);
	sin.sin_port = htons(HTTP_SERVICE_PORT);
	ret = connect(s, (struct sockaddr *)&sin, sizeof(sin));
	if (ret < 0) {
		perror("connect");
		exit(1);
	}

#if 0
	ret = setsockopt(as, IPPROTO_IP, TCPS_SO_SPLICE, &s, sizeof(s));
	if (ret < 0) {
		perror("setsockopt(TCPS_SO_SPLICE)");
		exit(1);
	}
	fprintf(stderr, "splicing ok.\n");
#endif
	for (;;) {
		FD_ZERO(&readfds);
		FD_SET(as, &readfds);
		FD_SET(s, &readfds);

		ret = select(as > s ? as + 1 : s + 1, &readfds, NULL, NULL,
				NULL);
		if (ret < 0)
			perror("select");
		else if (ret == 0)
			continue;

		if (FD_ISSET(as, &readfds)) {
			ret = recv(as, buf, sizeof(buf), 0);
			if (ret > 0)
				send(s, buf, ret, 0);
			else if (ret == 0)
				break;
			else {
				perror("recv");
				break;
			}
			printf(">>>>from client:\n");
			write(1, buf, ret);
			fputc('\n', stdout);
		}

		if (FD_ISSET(s, &readfds)) {
			ret = recv(s, buf, sizeof(buf), 0);
			if (ret > 0)
				send(as, buf, ret, 0);
			else if (ret == 0)
				break;
			else {
				perror("recv");
				break;
			}
			printf(">>>>from real server:\n");
			write(1, buf, ret);
			fputc('\n', stdout);
		}
	}

	close(as);
	close(s);
	goto repeat;

	return 0;
}
