<?php
// +----------------------------------------------------------------------+
// | PHP version 4                                                        |
// +----------------------------------------------------------------------+
// | Copyright (c) 1997-2005 Snapshot Inc.                                |
// +----------------------------------------------------------------------+
// | License                                                              |
// | GNU General Public License                                           |
// +----------------------------------------------------------------------+
// | Authors: Takayuki Tanimoto <takayuki@snapshot.co.jp>                 |
// +----------------------------------------------------------------------+
//
// $Id: List_success.php,v 1.1 2005/06/20 09:31:28 snapshot Exp $
//
// Description:
// 2005/05/18
//
include(BASE_DIR."templates/header.php");
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title>Uラーニング</title>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<link rel="stylesheet" href="files/css/main.css" type="text/css" />
<script src="files/js/main.js" type="text/javascript"></script>
<script src="files/js/dom.js" type="text/javascript"></script>
</head>
<body>
<div id="container">


<div id="header">
	<div class="menu">
		<div class="menu_right">
			<table>
				<tr>
					<td><a href="<?= htmlspecialchars(TemplateUtils::createLink('User','List')) ?>">学生管理</a></td>
					<td><a href="<?= htmlspecialchars(TemplateUtils::createLink('Subject','List')) ?>">科目編集</a></td>
					<td><a href="<?= htmlspecialchars(TemplateUtils::createLink('Config','Input')) ?>">設定</a></td>
					<td><a href="<?= htmlspecialchars(TemplateUtils::createLink('Login','Logout')) ?>">ログアウト</a></td>
				</tr>
			</table>
		</div>
        <div class="menu_login">
            ログイン : <?= htmlspecialchars($template['admin']->aid) ?>
        </div>
		<div class="menu_left">
			<table>
				<tr>
					<td><a href="<?= htmlspecialchars(TemplateUtils::createLink('Exam','List')) ?>">テスト</a></td>
					<td class="menu_focus"><a href="<?= htmlspecialchars(TemplateUtils::createLink('Results','Search')) ?>">成績</a></td>
				</tr>
			</table>
		</div>
	</div>
	<div class="div_clear"></div>
</div>


<div id="contents">
	
	<div id="subject">
		<ul>
<?php
foreach($template['subjects'] as $subject) {
?>
			<li class="sub_s"><a id="sub_<?= $subject->sid ?>" href="#" class="<?= ($subject->sid == $template['subject']->sid) ? '' : 'disable ' ?>sub_s_<?= TemplateUtils::subType($subject->sid) ?>"><?= htmlspecialchars($subject->name) ?></a></li>
<?php
}
?> 
		</ul>
		<div class="div_clear">&#160;</div>
	</div>
	
	<div id="main">
		<div id="navi">
<?php
if($template['exam']) {
?>
			<h1><?= htmlspecialchars($template['exam']->name) ?></h1>
			&nbsp;<?= htmlspecialchars(TemplateUtils::formatDateTime($template['exam']->publish_time)) ?>配信
			&nbsp;<?= ($template['exam']->deadline_time) ? htmlspecialchars(TemplateUtils::formatDateTime($template['exam']->deadline_time)).'締切' : '締切なし' ?>
			&nbsp;全<?= $template['exam']->getQuestionsCount() ?>問
			&nbsp;<?= $template['exam']->getTotalPoint() ?>点満点
<?php
} else {
?>
			<h1><?= htmlspecialchars($template['student']->name) ?></h1>
			&nbsp;学年 <?= htmlspecialchars($template['student']->year) ?>
			&nbsp;学生番号 <?= htmlspecialchars($template['student']->number) ?>
			&nbsp;<?= htmlspecialchars($template['student']->mail) ?>
<?php
}
?>
			<br />
			<a href="javascript:history.back();" class="operation">戻る</a>
		</div>
		
		
		<div class="result_list">
			<table>
				<tr>
<?php
if($template['exam']) {
?>
					<th>学年</th>
					<th>学生番号</th>
					<th>氏名</th>
					<th>受験日</th>
					<th>得点</th>
<?php
} else {
?>
					<th>科目</th>
					<th>テスト名</th>
					<th>配信日</th>
					<th>締切</th>
					<th>回答日</th>
					<th>得点</th>
<?php
}
for($i = 0; $i < count($template['exam']->questions); $i++) {
?>
					<th>問<?= $i + 1 ?></th>
<?php
}
?>
					<th>詳細</th>
				</tr>
<?php
foreach($template['results'] as $result) {
?>
				<tr>
<?php
	if($template['exam']) {
?>
					<td><?= htmlspecialchars($result->uyear) ?></td>
					<td><?= htmlspecialchars($result->unumber) ?></td>
					<td><?= htmlspecialchars($result->uname) ?></td>
					<td class="text_center"><?= htmlspecialchars(TemplateUtils::formatDateTime($result->reply_date)) ?></td>
					<td class="text_right"><?= htmlspecialchars($result->points) ?></td>
<?php
		for($i = 1; $i <= count($template['exam']->questions); $i++) {
?>
					<td class="text_center">
<?php
			if(array_key_exists($i, $result->questions)) {
				if(count($result->questions[$i]->choices)) {
?>
						<?= $result->questions[$i]->choices[0]->number ?>
<?php
				}
				if($result->questions[$i]->point) {
?>
						<font color="red">○</font>
<?php
				} else {
?>
						<font color="blur">×</font>
<?php
				}
			} else {
?>
						<font color="blur">×</font>
<?php
			}
?>
					</td>
<?php
		}
	} else {
?>
					<td><?= htmlspecialchars($result->sname) ?></td>
					<td><?= htmlspecialchars($result->ename) ?></td>
					<td class="text_center"><?= htmlspecialchars(TemplateUtils::formatDateTime($result->publish_time)) ?></td>
					<td class="text_center"><?= ($result->deadline_time) ? htmlspecialchars(TemplateUtils::formatDateTime($result->deadline_time)) : 'なし' ?></td>
					<td class="text_center"><?= htmlspecialchars(TemplateUtils::formatDateTime($result->reply_date)) ?></td>
					<td class="text_right"><?= htmlspecialchars($result->points) ?></td>
<?php
	}
?>
					<td><a href="<?= htmlspecialchars(TemplateUtils::createLink('Results','Detail', array('rid'=>$result->rid))) ?>">詳細</a></td>
				</tr>
<?php
}
?>
			</table>
		</div>
	</div>
	
	
	<div class="div_clear">&#160;</div>
</div>


<?php
include(BASE_DIR.'templates/admin_footer.php');
?>

<div class="div_clear">&nbsp;</div>


</div>
</body>
</html>