<?php

// +----------------------------------------------------------------------+
// | PHP version 4                                                        |
// +----------------------------------------------------------------------+
// | Copyright (c) 1997-2005 Snapshot Inc.                                |
// +----------------------------------------------------------------------+
// | License                                                              |
// | GNU General Public License                                           |
// +----------------------------------------------------------------------+
// | Authors: Takayuki Tanimoto <takayuki@snapshot.co.jp>                 |
// +----------------------------------------------------------------------+
//
// $Id: LoginAction.class.php,v 1.1 2005/06/20 09:31:27 snapshot Exp $
//
// Description:
// 2005/05/18
//

require_once (OPT_DIR.'u-learning/config.php');
require_once (OPT_DIR.'u-learning/action/DBAction.class.php');
require_once (OPT_DIR.'u-learning/lib/TemplateUtils.class.php');

/**
 * LoginAction
 * 
 * ログインアクションクラス
 */
class LoginAction extends DBAction {

    function execute(& $controller, & $request, & $user) {

        if ($request->hasParameter('login_submit')) {
            // ログイン処理

            // DBオブジェクト取得
            $DB= $request->getAttribute('DB');

            // ユーザID
            $aid= $request->getParameter('aid');
            // パスワード
            $pass= $request->getParameter('pass');

            // DB問い合わせ
            $sql= "SELECT count(*) FROM admin_info "." WHERE aid = ".$DB->qstr($aid)." AND pass = ".$DB->qstr($pass);
            $count= $DB->GetOne($sql);

            if ($count > 0) {
                // ログイン成功
                // 認証OK
                $user->setAuthenticated(true);
                // ユーザIDをセット
                $user->setAttribute('aid', $aid);

                // TOPページへ飛ばす
                $url= TemplateUtils :: createURL('Exam', 'List');
                header('Location: '.$url);
                return VIEW_NONE;
            }

            // ログイン失敗
            $request->setError('error', 'ログインIDとパスワードが間違っています。');
            $request->setAttribute('aid', $aid);
            $request->setAttribute('pass', $pass);
            return VIEW_ERROR;
        }

        return VIEW_INPUT;
    }

    /**
     * このページにログインは必要か
     */
    function isSecure() {
        return false;
    }
}
?>