<?php
// +----------------------------------------------------------------------+
// | PHP version 4                                                        |
// +----------------------------------------------------------------------+
// | Copyright (c) 1997-2005 Snapshot Inc.                                |
// +----------------------------------------------------------------------+
// | License                                                              |
// | GNU General Public License                                           |
// +----------------------------------------------------------------------+
// | Authors: Takayuki Tanimoto <takayuki@snapshot.co.jp>                 |
// +----------------------------------------------------------------------+
//
// $Id: Distribute_success.php,v 1.1 2005/06/20 09:31:25 snapshot Exp $
//
// Description:
// 2005/05/18
//
include(BASE_DIR."templates/header.php");
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title>Uラーニング</title>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<link rel="stylesheet" href="files/css/main.css" type="text/css" />
<script src="files/js/main.js" type="text/javascript"></script>
<script src="files/js/dom.js" type="text/javascript"></script>
<script src="files/js/exam_distribute.js" type="text/javascript"></script>
</head>
<body>
<div id="container">


<div id="header">
	<div class="menu">
		<div class="menu_right">
			<table>
				<tr>
					<td><a href="<?= htmlspecialchars(TemplateUtils::createLink('User','List')) ?>">学生管理</a></td>
					<td><a href="<?= htmlspecialchars(TemplateUtils::createLink('Subject','List')) ?>">科目編集</a></td>
					<td><a href="<?= htmlspecialchars(TemplateUtils::createLink('Config','Input')) ?>">設定</a></td>
					<td><a href="<?= htmlspecialchars(TemplateUtils::createLink('Login','Logout')) ?>">ログアウト</a></td>
				</tr>
			</table>
		</div>
        <div class="menu_login">
            ログイン : <?= htmlspecialchars($template['admin']->aid) ?>
        </div>
		<div class="menu_left">
			<table>
				<tr>
					<td class="menu_focus"><a href="<?= htmlspecialchars(TemplateUtils::createLink('Exam','List')) ?>">テスト</a></td>
					<td><a href="<?= htmlspecialchars(TemplateUtils::createLink('Results','Search')) ?>">成績</a></td>
				</tr>
			</table>
		</div>
	</div>
	<div class="div_clear"></div>
</div>


<div id="contents">
	
	<div id="subject">
		<ul>
<?php
foreach ($template['subjects'] as $subject) {
?>
			<li class="sub_s"><a id="sub_<?= $subject->sid ?>" class="<?= ($subject->sid == $template['exam']->sid) ? "" : "disable " ?>sub_s_<?= TemplateUtils::subType($subject->sid) ?>"><?= htmlspecialchars($subject->name) ?></a></li>
<?php
}
?>
		</ul>
		<div class="div_clear">&#160;</div>
	</div>
	
	<div id="main">
	
		<div class="confirm">
			配信が完了しました。
		</div>
		
		<div class="confirm_buttons">
			<a href="<?= htmlspecialchars(TemplateUtils::createLink('Exam','List')) ?>" class="operation">テスト一覧へ戻る</a>
		</div>
		
		<div id="compose2">
			<div id="navi">
				<h1>
					<?= htmlspecialchars($template['exam']->name) ?> 
                    <span class="exam_info">
                        &nbsp;全<?= $template['questions_count'] ?>問&nbsp;合計点数<?= $template['total_point'] ?>
                    </span>
				</h1>
			</div>
			<div class="console">
				<table>
					<tr>
						<th width="20%">回答締切:</th>
						<td class="input_mid">
							<div>
								<p><?= htmlspecialchars($template['deadline_label']) ?></p>
								<p><?= htmlspecialchars($template['deadline']) ?></p>
							</div>
						</td>
					</tr>
					<tr>
						<th>テストの概要:</th>
						<td class="input_mid">
							<div>
								<?= nl2br(htmlspecialchars($template['summary'])) ?>
							</div>
						</td>
					</tr>
					<tr>
						<th></th>
						<td>
							
						</td>
					</tr>
				</table>
			</div>
			
			
			<div>
				<a href="javascript:expandAllQuestions();">すべて展開</a>
				<a href="javascript:collapseAllQuestions();">すべて閉じる</a>
			</div>
			
			
			<div id="exams">
<?php
foreach($template['questions'] as $question) {
?>
				<div id="exam_<?= $question->number ?>_collapse" class="exam exam_collapse">
					<h1>
                        <a href="javascript:expandQuestion(<?= $question->number?>);">第<?= $question->number ?>問 &nbsp; <?= (mb_strlen($question->question) < 20) ? htmlspecialchars($question->question) : htmlspecialchars(mb_substr($question->question, 0, 20)."....") ?></a>
					</h1>
				</div>
				<div id="exam_<?= $question->number ?>_expand" class="exam exam_expand" style="display: none;">
					<h1>
						<a name="a_expand_<?= $question->number ?>" href="javascript:collapseQuestion(<?= $question->number ?>);">第<?= $question->number ?>問</a>
					</h1>
					<div id="exam_<?= $question->number ?>_body" class="exam_body">
						<table>
							<tr>
								<th>設問:</th>
								<td><?= nl2br(htmlspecialchars($question->question)) ?></td>
							</tr>
							<tr>
								<th>回答:</th>
								<td>
									<ul>
<?php
	foreach($question->choices as $choice) {
?>
										<li><?= ($choice->correct == '1') ? '<span class="answer_right_saved">'.htmlspecialchars($choice->value).'</span>' : htmlspecialchars($choice->value) ?></li>
<?php
	}
?>
									</ul>
								</td>
							</tr>
							<tr>
								<th>配点:</th>
								<td><?= htmlspecialchars($question->point) ?></td>
							</tr>
							<tr>
								<th>解説:</th>
								<td><?= nl2br(htmlspecialchars($question->explanation)) ?></td>
							</tr>
						</table>
						<div class="div_clear">&#160;</div>
					</div>
				</div>
<?php
}
?>
			</div>
		</div>
		
	</div>
	
	
	<div id="side">
		<div class="side_menu">
			<h2>3ステップ</h2>
            <div class="progress">
            <a href="<?= htmlspecialchars(TemplateUtils::createLink('Exam','ExamInfo', array('eid'=>$template['exam']->eid))) ?>">
            <span class="done point">①</span><br/>
            <span class="done">科目とテスト名</span><br/>
            </a>
            <span class="done arrow">↓</span><br/>
            <a href="<?= htmlspecialchars(TemplateUtils::createLink('Exam','Questions', array('eid'=>$template['exam']->eid))) ?>">
            <span class="done point">②</span><br/>
            <span class="done">テスト内容</span><br/>
            </a>
            <span class="done arrow">↓</span><br/>
            <span class="focus point">③</span><br/>
            <span class="focus">配信</span><br/>
            </div>
		</div>
	</div>
	<div class="div_clear">&#160;</div>
</div>


<?php
include(BASE_DIR.'templates/admin_footer.php');
?>

<div class="div_clear">&nbsp;</div>


</div>
<script language="javascript" type="text/javascript">
// readyToFade();
</script>
</body>
</html>