<?php

// +----------------------------------------------------------------------+
// | PHP version 4                                                        |
// +----------------------------------------------------------------------+
// | Copyright (c) 1997-2005 Snapshot Inc.                                |
// +----------------------------------------------------------------------+
// | License                                                              |
// | GNU General Public License                                           |
// +----------------------------------------------------------------------+
// | Authors: Takayuki Tanimoto <takayuki@snapshot.co.jp>                 |
// +----------------------------------------------------------------------+
//
// $Id: ComposeAction.class.php,v 1.1 2005/06/20 09:31:27 snapshot Exp $
//
// Description:
// 2005/05/18
//

require_once (OPT_DIR.'u-learning/config.php');
require_once (OPT_DIR.'u-learning/action/AdminAction.class.php');
require_once (OPT_DIR.'u-learning/data/Admin.class.php');
require_once (OPT_DIR.'u-learning/data/AdminExam.class.php');

/**
 * ComposeAction
 * 
 * テスト作成開始
 */
class ComposeAction extends AdminAction {

    /**
     * POST
     */
    function execute(& $controller, & $request, & $user) {
        // DBコネクション
        $db= $request->getAttribute('DB');
        $admin= new Admin($user->getAttribute('aid'), $db);

        if ($request->hasParameter('compose_submit')) {
            // テストの作成
            $exam= new AdminExam();
            $exam->aid= $admin->aid;
            $exam->sid= $request->getParameter('subject');
            $exam->name= $request->getParameter('name');
            $exam->retry= $request->getParameter('retry');
            $exam->correct= $request->getParameter('correct');
            // DB追加
            $exam->insert($db);
            // INSERTされたテストIDを取得
            $eid= $db->lastInsertID();
            // リダイレクト
            $this->location('Exam', 'Questions', array ('eid' => $eid));
            return VIEW_NONE;
        }

        // 科目取得
        $subjects= $admin->getSubjects($db);
        $request->setAttribute('subjects', $subjects);
        return VIEW_SUCCESS;
    }

    /**
     * GET
     */
    function getDefaultView(& $controller, & $request, & $user) {
        // DBコネクション
        $db= $request->getAttribute('DB');
        $admin= new Admin($user->getAttribute('aid'), $db);

        // 科目取得
        $subjects= $admin->getSubjects($db);
        $request->setAttribute('subjects', $subjects);
        return VIEW_SUCCESS;
    }

    function getRequestMethods() {
        return REQ_POST;
    }
}
?>