<?php

// +----------------------------------------------------------------------+
// | PHP version 4                                                        |
// +----------------------------------------------------------------------+
// | Copyright (c) 1997-2005 Snapshot Inc.                                |
// +----------------------------------------------------------------------+
// | License                                                              |
// | GNU General Public License                                           |
// +----------------------------------------------------------------------+
// | Authors: Takayuki Tanimoto <takayuki@snapshot.co.jp>                 |
// +----------------------------------------------------------------------+
//
// $Id: StudentQuestionDetail.class.php,v 1.1 2005/06/20 09:31:26 snapshot Exp $
//
// Description:
// 2005/05/30
//

require_once (OPT_DIR.'u-learning/data/StudentQuestion.class.php');
require_once (OPT_DIR.'u-learning/data/StudentChoiceDetail.class.php');

/**
 * StudentQuestionDetail
 * 
 * 学生テスト結果設問詳細
 */
class StudentQuestionDetail extends StudentQuestion {

    // 設問番号
    var $number;
    // 設問
    var $question;
    // 解説
    var $explanation;

    function StudentQuestionDetail($rid= null, $qid= null, $db= null) {
        if (!is_null($rid) && !is_null($qid) && !is_null($db)) {
            $this->setDB($db);
            $this->rid= $rid;
            $this->qid= $qid;

            $select= "SELECT uq.*, aq.number, aq.question, aq.explanation";
            $from= "FROM user_question uq INNER JOIN admin_question aq ON uq.qid = aq.qid ";
            $where= "WHERE uq.rid = ".$rid." AND uq.qid = ".$qid;
            $row= $this->DB->GetRow("$select $from $where");
            if (count($row) > 0) {
                $this->setValues($row);
            }
        }
    }

    /**
     * 配列から値をセットする
     */
    function setValues($array) {
        $this->rid= $array['rid'];
        $this->qid= $array['qid'];
        $this->aid= $array['aid'];
        $this->uid= $array['uid'];
        $this->eid= $array['eid'];
        $this->point= $array['point'];

        if (array_key_exists('number', $array))
            $this->number= $array['number'];
    }

    /**
     * 現在の設問の回答リストを取得
     */
    function setChoice() {
        $select= "SELECT *";
        $from= "FROM user_choice";
        $where= "WHERE qid = ".$this->qid." AND rid = ".$this->rid;
        $all= $this->DB->GetAll("$select $from $where");
        $this->choices= array ();
        foreach ($all as $row) {
            $choice= new StudentChoiceDetail();
            $choice->setValues($row);
            $choice->setDB($this->DB);
            $choice->setNumber();
            array_push($this->choices, $choice);
        }
        return $this->choices;
    }

    /**
     * 選択されている回答の値を取得する
     */
    function getAnswer() {
        if (!is_array($this->choices))
            $this->setChoice();
        foreach ($this->choices as $choice) {
            // !!!! 単一選択なので最初のものを返す
            return $choice->choice;
        }
    }

    /**
     * 選択されている回答の番号を取得する
     */
    function getAnswerNumber() {
        if (!is_array($this->choices))
            $this->setChoice();
        foreach ($this->choices as $choice) {
            // !!!! 単一選択なので最初のものを返す
            $choice->setNumber();
            return $choice->number;
        }
    }

}
?>