/*
    setwindrv TiMidity++ config file ediotr.
    Copyright (C) 2006-2007 Keishi Suenaga <skeishi@yahoo.co.jp>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <stdio.h>
#include <string.h>
#include "dirent.h"
#include <glib.h> //for gboolean

#include <windows.h>
#include <mmsystem.h>
#include <portaudio.h>
#include <pa_asio.h>
#include "w32_portaudio.h"

#include "file_io.h"
 
#ifdef _MSC_VER
#define snprintf _snprintf
#endif


static char timidity_cfg_path[FILENAME_MAX]={0};

void wmme_device_list(char device_list[DEVICE_LIST_MAX][MAX_LINE]){
	UINT num,i ;
	int list_num;
	WAVEOUTCAPS woc;
	typedef struct tag_DEVICELIST{
		int  deviceID;
		char name[256];
	} DEVICELIST;
	DEVICELIST device[DEVICE_LIST_MAX];

	num = waveOutGetNumDevs();
	list_num=0;
	for(i = 0 ; i < num ; i++){
		if (MMSYSERR_NOERROR == waveOutGetDevCaps((UINT)i, &woc, sizeof(woc)) ){
			device[list_num].deviceID=i;
			strcpy(device[list_num].name, woc.szPname);
			list_num++;
		}
        if (list_num >= DEVICE_LIST_MAX-1) break;
	}
	for(i=0;i<list_num;i++){
		sprintf(device_list[i],"%2d %s", device[i].deviceID, device[i].name);
	}
    device_list[list_num][0]='\0';
}


int  asio_device_list(char out_device_c,char device_list[DEVICE_LIST_MAX][MAX_LINE]){
    PaHostApiTypeId HostApiTypeId;
	PaDeviceIndex maxDeviceIndex, i;
	PaHostApiIndex HostApiIndex;
	const PaDeviceInfo* DeviceInfo;
    PaError err;
	int line_no;

	if(load_portaudio_dll(0)){
      MessageBox(NULL, NULL, "Can't load portaudio.dll", IDOK);
	  return -1;
    }
	
	err = Pa_Initialize();
	if( err != paNoError ) goto error1;

    if(out_device_c == 'p') HostApiTypeId = paMME;
    if(out_device_c == 'P') HostApiTypeId = paDirectSound;
    if(out_device_c == 'o') HostApiTypeId = paASIO;
	HostApiIndex=Pa_HostApiTypeIdToHostApiIndex(HostApiTypeId);
	
	maxDeviceIndex=Pa_GetDeviceCount();

    line_no=0;	
	for( i = 0; i < maxDeviceIndex; i++){
		DeviceInfo=Pa_GetDeviceInfo(i);
		if( DeviceInfo->hostApi == HostApiIndex){
			if( DeviceInfo->maxOutputChannels > 0){
				sprintf(device_list[line_no++],"%2d %s",i,DeviceInfo->name);
			}
		}
        if (line_no >= DEVICE_LIST_MAX-1) break;
	}
    device_list[line_no++][0]='\0';
	Pa_Terminate();
  	free_portaudio_dll();
	return 0;

error1:
  	free_portaudio_dll();
	MessageBox(NULL, Pa_GetErrorText( err ), "Port Audio error", IDOK);
error2:
	Pa_Terminate();
	return -1;
}

int convert_to_urlencode(char text[MAX_LINE], gboolean to_urlencode){
  char buf[MAX_LINE];
  int len, i,j,n;

  len = strlen(text);  //  0x0D + 0x0A terminated
  if (to_urlencode == TRUE) {
    return -1; // not implemented
  }else{
    i = 0;
	j = 0;
    while( i < len){
      n = (unsigned char)(text[i]);
      if( n == '%' && i + 2 <  len){
        sscanf(text+i+1, "%2x",&n);
		buf[j++]=(char)n;
        i=i+3;
      }
      else
      {
      if ( n == '+')
       {
        buf[j++]=' ';
        i++;
       }
      else
       {
      if ( (n == 0x0D) && ((unsigned char)(text[i+1]) == 0x0A) )
	    {
          buf[j++]='\n';
          i=i+2;
        }
      else
        {
        buf[j++]=text[i++];
        }
       }
      }
    
    }
	buf[j]='\0';
    strncpy(text,buf,MAX_LINE-1);
    return 0;
  }
}
        
int convert_to_utf8(char text[MAX_LINE], gboolean to_utf8){
    WCHAR  buf[MAX_LINE];
    MultiByteToWideChar(to_utf8?CP_ACP:CP_UTF8, 0, (PCSTR)(text), -1, (PWSTR)buf, MAX_LINE); 
    WideCharToMultiByte(to_utf8?CP_UTF8:CP_ACP, 0, (PCWSTR)buf, -1, (PSTR)(text), MAX_LINE, NULL, NULL);
    return 0;
}

void to_utf8_device_list(char device_list[DEVICE_LIST_MAX][MAX_LINE]){
  int i;
  for( i=0; i < DEVICE_LIST_MAX-1 && device_list[i][0] != '\0';i++){
    convert_to_utf8(device_list[i],TRUE);
  }
}

void get_device_list(char out_device_c,char device_list[DEVICE_LIST_MAX][MAX_LINE]){

  if(out_device_c == 'd')
    wmme_device_list(device_list);
  if( (out_device_c == 'p') || (out_device_c == 'P') || (out_device_c == 'o') )
    asio_device_list(out_device_c,device_list);
  to_utf8_device_list(device_list);
}

int asioConfigDialog(void)
{

	PaHostApiTypeId HostApiTypeId;
	const PaHostApiInfo  *HostApiInfo;
	PaDeviceIndex DeviceIndex;
	PaError err;
	HWND hWnd;

	PaHostApiIndex i, ApiCount;
	
	
	if(load_portaudio_dll(0)){
      MessageBox(NULL, NULL, "Can't load portaudio.dll", IDOK);
	  return -1;
    }
	
	err = Pa_Initialize();
	if( err != paNoError ) goto error1;


	HostApiTypeId = paASIO;
	i = 0;
//	hWnd = hPrefWnd;
    hWnd = NULL;
	ApiCount = Pa_GetHostApiCount();
	do{
		HostApiInfo=Pa_GetHostApiInfo(i);
		if( HostApiInfo->type == HostApiTypeId ) break;
	    i++;
	}while ( i < ApiCount );
	if ( i == ApiCount ) goto error2;
    DeviceIndex = HostApiInfo->defaultOutputDevice;
	if(DeviceIndex==paNoDevice) goto error2;

	if (HostApiTypeId ==  paASIO){
    	err = PaAsio_ShowControlPanel( DeviceIndex, (void*) hWnd);
		if( err != paNoError ) goto error1;
	}
	Pa_Terminate();
  	free_portaudio_dll();
	return 0;
	
error1:
  	free_portaudio_dll();
	MessageBox(NULL, Pa_GetErrorText( err ), "Port Audio (asio) error", IDOK);
error2:
	Pa_Terminate();
	return -1;
}


int dir_list(char* file_path,  char* type, char* file_list, size_t file_list_size)
{
  struct dirent *de;
  DIR *dp = opendir(file_path);
  int offset = 0;
  file_list[0]= '\0';
  if (dp == NULL) return -1;
  while (de = readdir(dp)){
   if ( 0 == strcmp(de->d_name+strlen(de->d_name)-strlen(type), type) )
     offset += snprintf(file_list+offset,file_list_size-offset,"%s\n", de->d_name);
  }
  closedir(dp);
  return 0;
}

gboolean set_cfg_path(char *path){
  FILE *fp;
  if( (path == NULL) && ( timidity_cfg_path[0] =='\0') ){
    GetWindowsDirectory(timidity_cfg_path, sizeof(timidity_cfg_path));
    strncat(timidity_cfg_path,"\\timidity.cfg", FILENAME_MAX-1);
    return TRUE;
  }
  if( (fp=fopen(path,"r+")) != NULL){		
    fclose(fp);
  }else{
    if( (fp=fopen(path,"w+")) != NULL){  //make new file
      fclose(fp);
    }else{
      return FALSE;
    }
  }
  strncpy(timidity_cfg_path, path, FILENAME_MAX-1);
  return TRUE;
}

const char* get_cfg_path(void){
   return timidity_cfg_path;
}

gboolean is_dir(char *dir_path){
   DIR *dp = opendir(dir_path);
   if (dp == NULL) return FALSE;
   closedir(dp);
   return TRUE;
}
