;--------------------------------

!define TIMIDITY_VERSION "2.13.2-twsynth051024"
!define DISPLAY_NAME "TiMidity++(${TIMIDITY_VERSION})"
!define HAVE_PATCHES
!define NEW_INTERFACE

;Var LOCAL_APPDATA

!ifdef NEW_INTERFACE
;--------------------------------
;Include Modern UI

  !include "MUI.nsh"

!endif

  !include "logiclib.nsh" ; needed by ${switch}
;--------------------------------

# [Installer Attributes]

Name "${DISPLAY_NAME}"
!ifdef HAVE_PATCHES 
OutFile "timidity-${TIMIDITY_VERSION}_setup.exe"
!else
OutFile "timidity-${TIMIDITY_VERSION}_nopatches_setup.exe"
!endif
Caption "${DISPLAY_NAME}"

# [Licence Attributes]
LicenseText "TiMidity++ is distributed under the GNU General Public License :"
LicenseData "COPYING.txt"

# [Directory Selection]
InstallDir "C:\timidity"
DirText "Select the directory to install TiMidity++ to :"

# [Additional Installer Settings ]
SetCompress force
SetCompressor lzma

;--------------------------------
;Interface Settings

ShowInstDetails show
AutoCloseWindow false
SilentInstall normal
CRCCheck on
SetCompress auto
SetDatablockOptimize on
;SetOverwrite ifnewer
XPStyle on


InstType "Typical" ;1
InstType "Full" ;2

ComponentText "Choose components"

# [Background Gradient]
BGGradient off

!ifdef NEW_INTERFACE
  !define MUI_ABORTWARNING
!endif

;--------------------------------

# [Pages]

!ifndef NEW_INTERFACE
  
Page license
Page components
PageEx directory
  DirVerify leave
;  PageCallbacks "" "" dirLeave
PageExEnd
Page instfiles

UninstPage uninstConfirm
UninstPage instfiles

!else ;NEW_INTERFACE

  !insertmacro MUI_PAGE_LICENSE "COPYING.txt"
  !insertmacro MUI_PAGE_COMPONENTS
;  !define MUI_PAGE_CUSTOMFUNCTION_LEAVE dirLeave
  !insertmacro MUI_PAGE_DIRECTORY
  !insertmacro MUI_PAGE_INSTFILES
  
  !define MUI_FINISHPAGE_RUN "$INSTDIR\timw32g.exe"
  !define MUI_FINISHPAGE_NOREBOOTSUPPORT
  !insertmacro MUI_PAGE_FINISH

  !insertmacro MUI_UNPAGE_CONFIRM
  !insertmacro MUI_UNPAGE_INSTFILES

;--------------------------------
;Languages

  !insertmacro MUI_LANGUAGE "English"
  !insertmacro MUI_LANGUAGE "Japanese"

!endif ;NEW_INTERFACE
;--------------------------------
    LangString MSG_AllUser ${LANG_ENGLISH} "Do you want to install TiMidity++ for all users on this computer ?"
    LangString MSG_AllUser ${LANG_JAPANESE} "̃Rs[^̑S[U[TiMidity++CXg[܂H"

# [Files]

Section "TiMidity++ program files (required)" SectionMain
  SectionIn 1 2 RO
  SetOutPath $INSTDIR
  File "COPYING.txt"
  File "README.ja.txt"
  File "README.txt"
  File "SETUP.ja.txt"
  File "SETUP.txt"
  File "timw32g.exe"
  File "twsyng.exe"
  File "twsynsrv.exe"
  File "timidity.exe"
  File "twsynth.bat"
  File "timpp32g.ini"
  File "timidity_output.ini"
  File "timidity_window.ini"
  
  File /r timiditydrv
    
;INI file
DeleteINIStr $INSTDIR\timpp32g.ini PLAYER ConfigFile
WriteINIStr $INSTDIR\timpp32g.ini PLAYER ConfigFile "$INSTDIR\timidity.cfg"

  ;Create uninstaller
  WriteUninstaller "$INSTDIR\Uninstall.exe"

SectionEnd

Section "Optional DLLs" SectionOptinaldlls
  SectionIn 1 2
  SetOutPath $INSTDIR
  File "gogo.dll"
  File "pa_win_wmme.dll"
  File "pdcurses.dll"
  File "vorbis.dll"
  File "libFLAC.dll"
  File "vorbisenc.dll"
  File "libOggFLAC.dll"
;  File "pa_asio.dll"
  File "pa_win_ds.dll"
  File "ogg.dll"
SectionEnd


!ifdef HAVE_PATCHES
Section "S-densh SYUUHOU 30M Bpatch" SectionPatch
  SectionIn 1 2
  SetOutPath $INSTDIR\SYUUHOU
  File "SYUUHOU\88prod.cfg"
  File "SYUUHOU\88prot.cfg"
  File "SYUUHOU\Drumset-j.txt"
  File "SYUUHOU\ReadMe-j.txt"
  File "SYUUHOU\VupHistory-j.txt"
  File "SYUUHOU\adsrmod.cfg"
  File "SYUUHOU\altassign8p.cfg"
  File "SYUUHOU\mt32.cfg"
  File "SYUUHOU\sfx.cfg"
  File "SYUUHOU\tune.cfg"
  File "SYUUHOU\timskel.cfg"
SetCompress off
  File "SYUUHOU\inst.zip"
SetCompress auto

;INI file
DeleteINIStr $INSTDIR\timpp32g.ini PLAYER ConfigFile
WriteINIStr $INSTDIR\timpp32g.ini PLAYER ConfigFile "$INSTDIR\SYUUHOU\timidity.cfg"
	
; compleate timidity.cfg
FileOpen $0 "$INSTDIR\SYUUHOU\timidity.cfg" "w"
FileOpen $1 "$INSTDIR\SYUUHOU\timskel.cfg" "r"
FileWrite $0 'dir "$INSTDIR\SYUUHOU\inst.zip#"$\r$\n'
FileWrite $0 'dir "$INSTDIR\SYUUHOU"$\r$\n'
ClearErrors
LOOP:
FileRead $1 $2
FileWrite $0 $2
IfErrors DONE LOOP
DONE:
FileClose $1
FileClose $0

SectionEnd
!endif


Section "Timidity++ Driver" SectionDriver
  SectionIn 2
  Call GetWindowsVersion
  Pop $R0
  ClearErrors
  StrCmp $R0 95 REGDONE
  StrCmp $R0 98 REGDONE
  StrCmp $R0 ME REGDONE

  IfFileExists $INSTDIR\SYUUHOU\timidity.cfg 0 NOCFG
  IfFileExists $WINDIR\timidity.cfg 0 CFGABSENT
  Rename $WINDIR\timidity.cfg $WINDIR\timidity.cfg.bak
  CFGABSENT:
  CopyFiles $INSTDIR\SYUUHOU\timidity.cfg $WINDIR
  NOCFG:

;  ExecWait 'rundll32.exe setupapi,InstallHinfSection DefaultInstall.ntx86 132 $INSTDIR\timiditydrv\timiditydrv.INF'
  ExecWait 'rundll32.exe syssetup.dll,SetupInfObjectInstallAction timiditydrv.NT 132 $INSTDIR\timiditydrv\timiditydrv.INF'

StrCpy  $1 "0"
LOOP0:
  IntOp $1 $1 + 1
  ReadRegStr $0  HKLM "Software\Microsoft\Windows NT\CurrentVersion\Drivers32" "MIDI$1"
  StrCmp $0 "timiditydrv.dll" REGDONE
  ReadRegStr $0  HKLM "Software\Microsoft\Windows NT\CurrentVersion\Drivers32" "midi$1"
  StrCmp $0 "timiditydrv.dll" REGDONE
  StrCmp $1 "9" 0 LOOP0

  StrCpy  $1 "0"
LOOP1:
  IntOp $1 $1 + 1
  ClearErrors
  ReadRegStr $0  HKLM "Software\Microsoft\Windows NT\CurrentVersion\Drivers32" "MIDI$1"
  StrCmp $0 "" 0  NEXT1
  ReadRegStr $0  HKLM "Software\Microsoft\Windows NT\CurrentVersion\Drivers32" "midi$1"
  StrCmp $0 "" 0  NEXT1
  WriteRegStr HKLM "Software\Microsoft\Windows NT\CurrentVersion\Drivers32" "MIDI$1" "timiditydrv.dll"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\TiMidity++\Backup" \
      "MIDI" "MIDI$1"
  Goto REGDONE
NEXT1:
  StrCmp $1 "9" 0 LOOP1

REGDONE:

SectionEnd

# [Shortcuts]
Section "Create shortcuts in Start Menu" SectionShortcuts
  SectionIn 1 2

  ;try to read from registry if last installation installed for All Users/Current User
  ReadRegStr $0 HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\TiMidity++\Backup" \
      "Shortcuts"
  StrCmp $0 "" cont exists
  cont:

  SetShellVarContext all
  MessageBox MB_YESNO "$(MSG_AllUser)" IDYES AllUsers
  SetShellVarContext current
AllUsers:
  StrCpy $0 $SMPROGRAMS
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\TiMidity++\Backup" \
      "Shortcuts" "$0"

exists:
  CreateDirectory "$0\TiMidity++"
  SetOutPath $INSTDIR
  CreateShortCut "$0\TiMidity++\timw32g.lnk" "$INSTDIR\timw32g.exe"
  CreateShortCut "$0\TiMidity++\twsyng.lnk" "$INSTDIR\twsyng.exe"
  CreateShortCut "$0\TiMidity++\License.lnk" "$INSTDIR\COPYING.txt"
  CreateShortCut "$0\TiMidity++\Uninstall TiMidity++.lnk" "$INSTDIR\uninstall.exe"
SectionEnd

Section "Create Quick Launch shortcut" SectionQuickLaunch
  SectionIn 1 2
  SetShellVarContext current
  CreateShortCut "$QUICKLAUNCH\tim32g.lnk" "$INSTDIR\timw32g.exe"
  CreateShortCut "$QUICKLAUNCH\twsyng.lnk" "$INSTDIR\twsyng.exe"
SectionEnd


;--------------------------------

# [Sections' descriptions (on mouse over)]
!ifdef NEW_INTERFACE

  LangString DESC_SectionMain ${LANG_ENGLISH} "The TiMdity++"
  LangString DESC_SectionMain ${LANG_JAPANESE} "TiMdity++{"
  LangString DESC_SectionOptinaldlls ${LANG_ENGLISH} "Optional dlls for TiMidity++(not GPL)"
  LangString DESC_SectionOptinaldlls ${LANG_JAPANESE} "ǉ DLL(GPL)"
!ifdef HAVE_PATCHES
  LangString DESC_SectionPatch ${LANG_ENGLISH} "S-densh's SYUUHOU 30 MB patch(not GPL)$\nhttp://syuuhou.hp.infoseek$\n.co.jp/timidity/"
  LangString DESC_SectionPatch ${LANG_JAPANESE} "S-dq SYUUHOU 30 MB pb`(GPL)$\nhttp://syuuhou.hp.infoseek$\n.co.jp/timidity/"
!endif
  LangString DESC_SectionShortcuts ${LANG_ENGLISH} "Create a 'TiMidity++' program group with shortcuts, in the start menu"
  LangString DESC_SectionShortcuts ${LANG_JAPANESE} "X^[gj[TiMidity++̃O[vƃV[gJbgo^"
  LangString DESC_SectionQuickLaunch ${LANG_ENGLISH} "Create a shortcut to TiMidity++ in the QuickLaunch toolbar"
  LangString DESC_SectionQuickLaunch ${LANG_JAPANESE} "NCbN`TiMidity++̃V[gJbgo^"
  LangString DESC_SectionDriver ${LANG_ENGLISH} "Install TiMidity++ Driver for XP 2000 (rebooting requied)"
  LangString DESC_SectionDriver ${LANG_JAPANESE} "Windows2000܂XPő̃\tgTiMidity++g悤ɂB \
TiMidity++ Driver̃CXg[(v ċNj"

  !insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
    !insertmacro MUI_DESCRIPTION_TEXT ${SectionMain} $(DESC_SectionMain)
    !insertmacro MUI_DESCRIPTION_TEXT ${SectionOptinaldlls} $(DESC_SectionOptinaldlls)
!ifdef HAVE_PATCHES
    !insertmacro MUI_DESCRIPTION_TEXT ${SectionPatch} $(DESC_SectionPatch)
!endif
    !insertmacro MUI_DESCRIPTION_TEXT ${SectionShortcuts} $(DESC_SectionShortcuts)
    !insertmacro MUI_DESCRIPTION_TEXT ${SectionQuickLaunch} $(DESC_SectionQuickLaunch)
    !insertmacro MUI_DESCRIPTION_TEXT ${SectionDriver} $(DESC_SectionDriver)
  !insertmacro MUI_FUNCTION_DESCRIPTION_END

!endif ;NEW_INTERFACE

;--------------------------------

; Functions
    LangString MSG_Welcome ${LANG_ENGLISH} "Welcome to TiMidity++ install program."
    LangString MSG_Welcome ${LANG_JAPANESE} "TiMidity++CXg[[ւ悤"
    LangString MSG_AbortInstall ${LANG_ENGLISH} "Abort install?"
    LangString MSG_AbortInstall ${LANG_JAPANESE} "CXg[߂܂"
    LangString MSG_StartTim ${LANG_ENGLISH} "Do you want to run TiMidity++ now?"
    LangString MSG_StartTim ${LANG_JAPANESE} "TiMidity++N܂H"

Function .onInit
  MessageBox MB_OK "$(MSG_Welcome)"

  !insertmacro MUI_LANGDLL_DISPLAY
FunctionEnd

!ifndef NEW_INTERFACE

;called when the user hits the 'cancel' button
Function .onUserAbort
  MessageBox MB_YESNO "$(MSG_AbortInstall)" IDYES NoCancelAbort
  Abort
  NoCancelAbort:
FunctionEnd

called when the install was successful
Function .onInstSuccess
  MessageBox MB_YESNO "$(MSG_StartTim)" IDNO DontRun
  Exec '$INSTDIR\timw32g.exe'
  DontRun:
FunctionEnd

!endif ;!NEW_INTERFACE

;http://nsis.sourceforge.net/archive/nsisweb.php?page=628&instances=0,11,122
    LangString MSG_IrLetter ${LANG_ENGLISH} "Installation directory cannot contain: '$R0'. Only letters, numbers and ':-_\' are allowed."
    LangString MSG_IrLetter ${LANG_JAPANESE} "CXg[fBNg '$R0' ܂܂Ă܂Bp':-_\ 'ȊO͎g܂B"
    LangString MSG_IvInstDirectory ${LANG_ENGLISH} "invalid installation directory!"
    LangString MSG_IvInstDirectory ${LANG_JAPANESE} "CXg[fBNgԈĂ܂"
    LangString MSG_NotEnoughSpace ${LANG_ENGLISH} "not enough free space!"
    LangString MSG_NotEnoughSpace ${LANG_JAPANESE} "fBXN̈悪܂"
    
Function StrCSpnReverse
 Exch $R0 ; string to check
 Exch
 Exch $R1 ; string of chars
 Push $R2 ; current char
 Push $R3 ; current char
 Push $R4 ; char loop
 Push $R5 ; char loop

  StrCpy $R4 -1

  NextCharCheck:
  StrCpy $R2 $R0 1 $R4
  IntOp $R4 $R4 - 1
   StrCmp $R2 "" StrOK

   StrCpy $R5 -1

   NextChar:
   StrCpy $R3 $R1 1 $R5
   IntOp $R5 $R5 - 1
    StrCmp $R3 "" +2
    StrCmp $R3 $R2 NextCharCheck NextChar
     StrCpy $R0 $R2
     Goto Done

 StrOK:
 StrCpy $R0 ""

 Done:

 Pop $R5
 Pop $R4
 Pop $R3
 Pop $R2
 Pop $R1
 Exch $R0
FunctionEnd

#Verify the installation directory
Function dirLeave
  Push "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz:-_\ "
  Push $INSTDIR
  Call StrCSpnReverse
  Pop $R0
  StrCmp $R0 "" +3
  MessageBox MB_OK|MB_ICONEXCLAMATION "$(MSG_IrLetter)"
  Abort

  GetInstDirError $0
  ${Switch} $0
    ${Case} 1
      MessageBox MB_OK "$(MSG_IvInstDirectory)"
      Abort
      ${Break}
    ${Case} 2
      MessageBox MB_OK "$(MSG_NotEnoughSpace)"
      Abort
      ${Break}
  ${EndSwitch}
  

FunctionEnd
; GetWindowsVersion
 ;
 ; Based on Yazno's function, http://yazno.tripod.com/powerpimpit/
 ; Updated by Joost Verburg
 ;
 ; Returns on top of stack
 ;
 ; Windows Version (95, 98, ME, NT x.x, 2000, XP, 2003)
 ; or
 ; '' (Unknown Windows Version)
 ;
 ; Usage:
 ;   Call GetWindowsVersion
 ;   Pop $R0
 ;   ; at this point $R0 is "NT 4.0" or whatnot
 
 Function GetWindowsVersion
 
   Push $R0
   Push $R1
 
   ClearErrors
 
   ReadRegStr $R0 HKLM \
   "SOFTWARE\Microsoft\Windows NT\CurrentVersion" CurrentVersion

   IfErrors 0 lbl_winnt
   
   ; we are not NT
   ReadRegStr $R0 HKLM \
   "SOFTWARE\Microsoft\Windows\CurrentVersion" VersionNumber
 
   StrCpy $R1 $R0 1
   StrCmp $R1 '4' 0 lbl_error
 
   StrCpy $R1 $R0 3
 
   StrCmp $R1 '4.0' lbl_win32_95
   StrCmp $R1 '4.9' lbl_win32_ME lbl_win32_98
 
   lbl_win32_95:
     StrCpy $R0 '95'
   Goto lbl_done
 
   lbl_win32_98:
     StrCpy $R0 '98'
   Goto lbl_done
 
   lbl_win32_ME:
     StrCpy $R0 'ME'
   Goto lbl_done
 
   lbl_winnt:
 
   StrCpy $R1 $R0 1
 
   StrCmp $R1 '3' lbl_winnt_x
   StrCmp $R1 '4' lbl_winnt_x
 
   StrCpy $R1 $R0 3
 
   StrCmp $R1 '5.0' lbl_winnt_2000
   StrCmp $R1 '5.1' lbl_winnt_XP
   StrCmp $R1 '5.2' lbl_winnt_2003 lbl_error
 
   lbl_winnt_x:
     StrCpy $R0 "NT $R0" 6
   Goto lbl_done
 
   lbl_winnt_2000:
     Strcpy $R0 '2000'
   Goto lbl_done
 
   lbl_winnt_XP:
     Strcpy $R0 'XP'
   Goto lbl_done
 
   lbl_winnt_2003:
     Strcpy $R0 '2003'
   Goto lbl_done
 
   lbl_error:
     Strcpy $R0 ''
   lbl_done:
 
   Pop $R1
   Exch $R0
 
 FunctionEnd

;--------------------------------
    LangString MSG_FinishUninstall ${LANG_ENGLISH} "TiMidity++ has been uninstalled. Please now delete the $INSTDIR directory if it doesn't contain some of your documents"
    LangString MSG_FinishUninstall ${LANG_JAPANESE} "TiMidity++ ̃ACXg[I܂B $INSTDIR Ƀt@CcĂꍇ͎蓮ō폜Ă"
# [UnInstallation]

UninstallText "This program will uninstall TiMidity++, continue ?"
ShowUninstDetails show

Section "Uninstall"

  ;RemoveDirver
;  ExecWait 'rundll32.exe setupapi,InstallHinfSection timiditydrvUninstall.NT 132 $INSTDIR\timiditydrv\timiditydrv.INF'
  ExecWait 'rundll32.exe syssetup.dll,SetupInfObjectInstallAction timiditydrvUninstall.NT 132 $INSTDIR\timiditydrv\timiditydrv.INF'
  ClearErrors
  ReadRegStr $0 HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\TiMidity++\Backup" \
       "MIDI"
  IfErrors REGDONE
  DeleteRegValue HKLM "Software\Microsoft\Windows NT\CurrentVersion\Drivers32" $0
  ;Delete /REBOOTOK "$SYSDIR\timiditydrv.dll"
REGDONE:

  Delete "$INSTDIR\COPYING.txt"
  Delete "$INSTDIR\README.ja.txt"
  Delete "$INSTDIR\README.txt"
  Delete "$INSTDIR\SETUP.ja.txt"
  Delete "$INSTDIR\SETUP.txt"
  Delete "$INSTDIR\timw32g.exe"
  Delete "$INSTDIR\twsyng.exe"
  Delete "$INSTDIR\twsynsrv.exe"
  Delete "$INSTDIR\timidity.exe"
  Delete "$INSTDIR\twsynth.bat"
  Delete "$INSTDIR\timpp32g.ini"
  Delete "$INSTDIR\timidity_output.ini"
  Delete "$INSTDIR\timidity_window.ini"

  Delete "$INSTDIR\gogo.dll"
  Delete "$INSTDIR\pa_win_wmme.dll"
  Delete "$INSTDIR\pdcurses.dll"
  Delete "$INSTDIR\vorbis.dll"
  Delete "$INSTDIR\libFLAC.dll"
  Delete "$INSTDIR\vorbisenc.dll"
  Delete "$INSTDIR\libOggFLAC.dll"
  Delete "$INSTDIR\pa_asio.dll"
  Delete "$INSTDIR\pa_win_ds.dll"
  Delete "$INSTDIR\ogg.dll"
  
  RMDir /r "$INSTDIR\SYUUHOU"
 
  RMDir /r "$INSTDIR\timiditydrv"
  
  ; Remove files and uninstaller
  Delete "$INSTDIR\uninstall.exe"
  
  RMDir "$INSTDIR"

  ; Remove icons
  ReadRegStr $0 HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\TiMidity++\Backup" \
      "Shortcuts"
  Delete "$0\TiMidity++\timw32g.lnk"
  Delete "$0\TiMidity++\twsyng.lnk"
  Delete "$0\TiMidity++\License.lnk"
  Delete "$0\TiMidity++\Uninstall TiMidity++.lnk"
  RMDir  "$0\TiMidity++"
  SetShellVarContext current
  Delete "$QUICKLAUNCH\timw32g.lnk"
  Delete "$QUICKLAUNCH\twsyng.lnk"
  
  ; Remove registry keys
  DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\TiMidity++"
  DeleteRegKey HKLM SOFTWARE\TiMidity++

  MessageBox MB_OK "$(MSG_FinishUninstall)"

SectionEnd

#eof!
