/*
    TiMidity++ -- MIDI to WAVE converter and player
    Copyright (C) 1999-2002 Masanao Izumo <mo@goice.co.jp>
    Copyright (C) 1995 Tuukka Toivonen <tt@cgs.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    aRts_a.c by Peter L Jones <peter@drealm.org.uk>
    based on esd_a.c

    Functions to play sound through aRts
*/

/*  tim_synth.h  this codes are imported from MT-32 Emulator source. 
    MT-32 Emulator is a "Public Domain" MIDI rendering engine. 
 */

// tim_synth.h: Definition of the tim_synth class
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_tim_synth_H__10A273B1_3878_45E8_8D47_4AF57DE9BCA6__INCLUDED_)
#define AFX_tim_synth_H__10A273B1_3878_45E8_8D47_4AF57DE9BCA6__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "ks.h"
#include "ksproxy.h"
#include "dmusics.h"
#include "SynthTIM.h"
#include "MidiEvent.h"

typedef IUnknown *PUNKNOWN;
typedef void *PVOID;

/*
#define STATIC_CLSID_TIMEMU\
    0x0F91475EL, 0xD875, 0x4EC9, 0xBE, 0x50, 0xBF, 0xD1, 0xE9, 0x1D, 0xAF, 0x53
DEFINE_GUIDSTRUCT("{0F91475E-D875-4EC9-BE50-BFD1E91DAF53}", CLSID_TIMEMU);
#define CLSID_TIMEMU DEFINE_GUIDNAMED(CLSID_TIMEMU)
*/

#include "resource.h"       // main symbols

/////////////////////////////////////////////////////////////////////////////
// tim_synth

class tim_synth : 
	public IDispatchImpl<Itim_synth, &IID_Itim_synth, &LIBID_TIM_DRVLib>, 
	public ISupportErrorInfo,
	public CComObjectRoot,
	public CComCoClass<tim_synth,&CLSID_tim_synth>,
	public IDirectMusicSynth,
	public IKsControl
{
private:
	BOOL enabled;
	LPDMUS_PORTPARAMS pSynthParams;
	int dwUsageCount;
	IDirectMusicSynthSink *pSink;
	IReferenceClock  *pClock;
	bool status;

	KSIDENTIFIER SynthProperties[10];

	CSynthTIM *myTIM;

	CMidiEvent * RecordPoint;
	CMidiEvent * PlayPoint;

public:
	tim_synth();
	~tim_synth() {
		if(myTIM != NULL) {
			myTIM->Close();
			delete myTIM;
		}
	}

// Itim_synth
public:

BEGIN_COM_MAP(tim_synth)
	COM_INTERFACE_ENTRY(IDispatch)
	COM_INTERFACE_ENTRY(Itim_synth)
	COM_INTERFACE_ENTRY(ISupportErrorInfo)
//END_COM_MAP() 
{NULL, 0, 0}}; return _entries;}

//DECLARE_NOT_AGGREGATABLE(tim_synth) 
// Remove the comment from the line above if you don't want your object to 
// support aggregation. 

DECLARE_REGISTRY_RESOURCEID(IDR_tim_synth)
// ISupportsErrorInfo
	STDMETHOD(InterfaceSupportsErrorInfo)(REFIID riid);

    /* IUnknown */
    STDMETHOD(QueryInterface)       (THIS_ REFIID, LPVOID FAR *);
    STDMETHOD_(ULONG,AddRef)        (THIS);
    STDMETHOD_(ULONG,Release)       (THIS);

    /* IDirectMusicSynth */
    STDMETHOD(Open)                 (THIS_ LPDMUS_PORTPARAMS pPortParams);
    STDMETHOD(Close)                (THIS);
    STDMETHOD(SetNumChannelGroups)  (THIS_ DWORD dwGroups);
    STDMETHOD(Download)             (THIS_ LPHANDLE phDownload, 
                                           LPVOID pvData, 
                                           LPBOOL pbFree );
    STDMETHOD(Unload)               (THIS_ HANDLE hDownload, 
                                           HRESULT ( CALLBACK *lpFreeHandle)(HANDLE,HANDLE), 
                                           HANDLE hUserData ); 
    STDMETHOD(PlayBuffer)           (THIS_ REFERENCE_TIME rt, 
                                           LPBYTE pbBuffer, 
                                           DWORD cbBuffer);
    STDMETHOD(GetRunningStats)      (THIS_ LPDMUS_SYNTHSTATS pStats);
    STDMETHOD(GetPortCaps)          (THIS_ LPDMUS_PORTCAPS pCaps);
    STDMETHOD(SetMasterClock)       (THIS_ IReferenceClock *pClock);
    STDMETHOD(GetLatencyClock)      (THIS_ IReferenceClock **ppClock);
    STDMETHOD(Activate)             (THIS_ BOOL fEnable);
    STDMETHOD(SetSynthSink)         (THIS_ IDirectMusicSynthSink *pSynthSink);
    STDMETHOD(Render)               (THIS_ short *pBuffer, 
                                           DWORD dwLength, 
                                           LONGLONG llPosition);
    STDMETHOD(SetChannelPriority)   (THIS_ DWORD dwChannelGroup,
                                           DWORD dwChannel,
                                           DWORD dwPriority);
    STDMETHOD(GetChannelPriority)   (THIS_ DWORD dwChannelGroup,
                                           DWORD dwChannel,
                                           LPDWORD pdwPriority);
    STDMETHOD(GetFormat)            (THIS_ LPWAVEFORMATEX pWaveFormatEx,
                                           LPDWORD pdwWaveFormatExSize);
    STDMETHOD(GetAppend)            (THIS_ DWORD* pdwAppend);
    
	/* IKsControl */

	STDMETHOD(KsProperty)			(THIS_ IN PKSPROPERTY Property,
										IN ULONG PropertyLength,
										IN OUT LPVOID PropertyData,
										IN ULONG DataLength,
										OUT ULONG* BytesReturned
									);
    STDMETHOD(KsMethod)				(THIS_ IN PKSMETHOD Method,
										IN ULONG MethodLength,
										IN OUT LPVOID MethodData,
										IN ULONG DataLength,
										OUT ULONG* BytesReturned
									);
    STDMETHOD(KsEvent)				(THIS_ IN PKSEVENT Event OPTIONAL,
										IN ULONG EventLength,
										IN OUT LPVOID EventData,
										IN ULONG DataLength,
										OUT ULONG* BytesReturned
									);
};

#endif // !defined(AFX_tim_synth_H__10A273B1_3878_45E8_8D47_4AF57DE9BCA6__INCLUDED_)
