/*
    TiMidity++ -- MIDI to WAVE converter and player
    Copyright (C) 1999-2002 Masanao Izumo <mo@goice.co.jp>
    Copyright (C) 1995 Tuukka Toivonen <tt@cgs.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    aRts_a.c by Peter L Jones <peter@drealm.org.uk>
    based on esd_a.c

    Functions to play sound through aRts
*/
/*  SynthClassFactory.cpp  this codes are imported from MT-32 Emulator source. 
    MT-32 Emulator is a "Public Domain" MIDI rendering engine. 
 */

// SynthClassFactory.cpp : Implementation of CTimiditydrvApp and DLL registration.

#include "stdafx.h"
#include "timiditydrv.h"
#include "SynthClassFactory.h"
#include "tim_synth.h"

/////////////////////////////////////////////////////////////////////////////
//

STDMETHODIMP SynthClassFactory::InterfaceSupportsErrorInfo(REFIID riid)
{
	static const IID* arr[] = 
	{
		&IID_ISynthClassFactory,
	};

	for (int i=0;i<sizeof(arr)/sizeof(arr[0]);i++)
	{
		if (InlineIsEqualGUID(*arr[i],riid))
			return S_OK;
	}
	return S_FALSE;
}

HRESULT SynthClassFactory::QueryInterface(THIS_ REFIID Interface , LPVOID FAR * Object) {
   if (IsEqualGUID(Interface, IID_IUnknown))
   {
		*Object = (PVOID)(IClassFactory *)this;
   } 
   else /*if (IsEqualGUID(Interface, IID_IDirectMusicSynth))*/
   {
		*Object = (PVOID)(IClassFactory *)this;
   }
  /* } else {
	   *Object = NULL;
   }*/

   if (*Object) {
	   ((IUnknown *)(*Object))->AddRef();
	   return S_OK;
   }
   return 0xC000000DL;
}

ULONG SynthClassFactory::AddRef(THIS) {
	dwUsageCount++;
	return dwUsageCount;
}

ULONG SynthClassFactory::Release(THIS) {
	dwUsageCount--;

	if(dwUsageCount == 0) {
		delete this;
	}
	return dwUsageCount;
}

HRESULT STDMETHODCALLTYPE SynthClassFactory::CreateInstance(IUnknown __RPC_FAR *pUnkOuter, REFIID riid, void __RPC_FAR *__RPC_FAR *ppvObject){
	tim_synth *Obj = new tim_synth();
	if(FAILED(Obj->QueryInterface(riid, ppvObject))) {
		delete Obj;
		*ppvObject = NULL;
		return E_NOINTERFACE;
	}
	return NO_ERROR;
}

long __stdcall SynthClassFactory::LockServer(int) {
	return S_OK;
}

HRESULT SynthClassFactory::GetTypeInfoCount(UINT *pctinfo) {
	if (pctinfo == NULL) {
		return E_INVALIDARG;
	}
	*pctinfo = 1;
	return NOERROR;


}