/*
    TiMidity++ -- MIDI to WAVE converter and player
    Copyright (C) 1999-2002 Masanao Izumo <mo@goice.co.jp>
    Copyright (C) 1995 Tuukka Toivonen <tt@cgs.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    aRts_a.c by Peter L Jones <peter@drealm.org.uk>
    based on esd_a.c

    Functions to play sound through aRts
*/
/*  SynthClassFactory.h  this codes are imported from MT-32 Emulator source. 
    MT-32 Emulator is a "Public Domain" MIDI rendering engine. 
 */
 
 // SynthClassFactory.h: Definition of the SynthClassFactory class
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_SYNTHCLASSFACTORY_H__EF681790_7C08_4EE7_BBA0_71227EEC5976__INCLUDED_)
#define AFX_SYNTHCLASSFACTORY_H__EF681790_7C08_4EE7_BBA0_71227EEC5976__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "resource.h"       // main symbols
#include "unknwn.h"

/////////////////////////////////////////////////////////////////////////////
// SynthClassFactory

class SynthClassFactory : 
	public IDispatchImpl<ISynthClassFactory, &IID_ISynthClassFactory, &LIBID_TIM_DRVLib>, 
	public ISupportErrorInfo,
	public CComObjectRoot,
	public CComCoClass<SynthClassFactory,&CLSID_SynthClassFactory>,
	public IClassFactory
{
private:
	int dwUsageCount;
public:
	SynthClassFactory() {
		dwUsageCount = 0;
		}
BEGIN_COM_MAP(SynthClassFactory)
//DEL 	COM_INTERFACE_ENTRY(IDispatch)
	COM_INTERFACE_ENTRY(ISynthClassFactory)
	COM_INTERFACE_ENTRY(ISupportErrorInfo)
//END_COM_MAP()
// Itim_synth
COM_INTERFACE_ENTRY2(IDispatch, ISynthClassFactory)
{NULL, 0, 0}}; return _entries;}
//DECLARE_NOT_AGGREGATABLE(SynthClassFactory) 

DECLARE_REGISTRY_RESOURCEID(IDR_SynthClassFactory)
// ISupportsErrorInfo
	STDMETHOD(InterfaceSupportsErrorInfo)(REFIID riid);

// ISynthClassFactory
public:
	STDMETHOD(GetTypeInfoCount)     (THIS_ UINT FAR* pctinfo);

    STDMETHOD(QueryInterface)       (THIS_ REFIID, LPVOID FAR *);
    STDMETHOD_(ULONG,AddRef)        (THIS);
    STDMETHOD_(ULONG,Release)       (THIS);

	HRESULT STDMETHODCALLTYPE CreateInstance(IUnknown __RPC_FAR *pUnkOuter, REFIID riid, void __RPC_FAR *__RPC_FAR *ppvObject);
	long __stdcall LockServer(int);
};

#endif // !defined(AFX_SYNTHCLASSFACTORY_H__EF681790_7C08_4EE7_BBA0_71227EEC5976__INCLUDED_)
