/*
 * copyright postclass.jp 
 */
package jp.postclass.commons.http.filter.trimWhitespaces;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

/**
 * o͂ɗߍServletResponse.
 * 
 * @author ryo
 */
public class ByteArrayServletResponse implements HttpServletResponse {

    private final HttpServletResponse originalResponse;
    private final ByteArrayServletOutputStream out =
            new ByteArrayServletOutputStream();

    /**
     * @throws IOException
     * @see javax.servlet.ServletResponse#flushBuffer()
     */
    public void flushBuffer() throws IOException {
        return;
    }

    /**
     * 
     * @see javax.servlet.ServletResponse#reset()
     */
    public void reset() {
        return;
    }

    /**
     * 
     * @see javax.servlet.ServletResponse#resetBuffer()
     */
    public void resetBuffer() {
        return;
    }


    /* *****************************  ***************************** */

    /**
     * @param resOrg
     */
    public ByteArrayServletResponse(final HttpServletResponse resOrg) {
        this.originalResponse = resOrg;
    }

    /**
     * @param arg0
     * @see javax.servlet.http.HttpServletResponse#addCookie(javax.servlet.http.Cookie)
     */
    public void addCookie(final Cookie arg0) {
        this.originalResponse.addCookie(arg0);
    }

    /**
     * @param arg0
     * @param arg1
     * @see javax.servlet.http.HttpServletResponse#addDateHeader(java.lang.String,
     *      long)
     */
    public void addDateHeader(final String arg0, final long arg1) {
        this.originalResponse.addDateHeader(arg0, arg1);
    }

    /**
     * @param arg0
     * @param arg1
     * @see javax.servlet.http.HttpServletResponse#addHeader(java.lang.String,
     *      java.lang.String)
     */
    public void addHeader(final String arg0, final String arg1) {
        this.originalResponse.addHeader(arg0, arg1);
    }


    /**
     * @param arg0
     * @param arg1
     * @see javax.servlet.http.HttpServletResponse#addIntHeader(java.lang.String,
     *      int)
     */
    public void addIntHeader(final String arg0, final int arg1) {
        this.originalResponse.addIntHeader(arg0, arg1);
    }

    /**
     * @param arg0
     * @return
     * @see javax.servlet.http.HttpServletResponse#containsHeader(java.lang.String)
     */
    public boolean containsHeader(final String arg0) {
        return this.originalResponse.containsHeader(arg0);
    }

    /**
     * @param arg0
     * @return
     * @deprecated
     * @see javax.servlet.http.HttpServletResponse#encodeRedirectUrl(java.lang.String)
     */
    @Deprecated
    public String encodeRedirectUrl(final String arg0) {
        return this.originalResponse.encodeRedirectUrl(arg0);
    }

    /**
     * @param arg0
     * @return
     * @see javax.servlet.http.HttpServletResponse#encodeRedirectURL(java.lang.String)
     */
    public String encodeRedirectURL(final String arg0) {
        return this.originalResponse.encodeRedirectURL(arg0);
    }

    /**
     * @param arg0
     * @return
     * @deprecated
     * @see javax.servlet.http.HttpServletResponse#encodeUrl(java.lang.String)
     */
    @Deprecated
    public String encodeUrl(final String arg0) {
        return this.originalResponse.encodeUrl(arg0);
    }

    /**
     * @param arg0
     * @return
     * @see javax.servlet.http.HttpServletResponse#encodeURL(java.lang.String)
     */
    public String encodeURL(final String arg0) {
        return this.originalResponse.encodeURL(arg0);
    }


    /**
     * @return
     * @see javax.servlet.ServletResponse#getBufferSize()
     */
    public int getBufferSize() {
        return this.originalResponse.getBufferSize();
    }

    /**
     * @return
     * @see javax.servlet.ServletResponse#getCharacterEncoding()
     */
    public String getCharacterEncoding() {
        return this.originalResponse.getCharacterEncoding();
    }

    /**
     * @return
     * @see javax.servlet.ServletResponse#getContentType()
     */
    public String getContentType() {
        return this.originalResponse.getContentType();
    }

    /**
     * @return
     * @see javax.servlet.ServletResponse#getLocale()
     */
    public Locale getLocale() {
        return this.originalResponse.getLocale();
    }


    /**
     * @return
     * @throws IOException
     * @see javax.servlet.ServletResponse#getOutputStream()
     */
    public ServletOutputStream getOutputStream() throws IOException {
        return this.out;
    }

    /**
     * @return
     * @throws IOException
     * @see javax.servlet.ServletResponse#getWriter()
     */
    public PrintWriter getWriter() throws IOException {
        return this.out.getWriter();
    }

    /**
     * @return
     * @see javax.servlet.ServletResponse#isCommitted()
     */
    public boolean isCommitted() {
        return this.originalResponse.isCommitted();
    }

    /* *****************************  ***************************** */

    /**
     * @param arg0
     * @throws IOException
     * @see javax.servlet.http.HttpServletResponse#sendError(int)
     */
    public void sendError(final int arg0) throws IOException {
        this.originalResponse.sendError(arg0);
    }

    /**
     * @param arg0
     * @param arg1
     * @throws IOException
     * @see javax.servlet.http.HttpServletResponse#sendError(int,
     *      java.lang.String)
     */
    public void sendError(final int arg0, final String arg1) throws IOException {
        this.originalResponse.sendError(arg0, arg1);
    }

    /**
     * @param arg0
     * @throws IOException
     * @see javax.servlet.http.HttpServletResponse#sendRedirect(java.lang.String)
     */
    public void sendRedirect(final String arg0) throws IOException {
        this.originalResponse.sendRedirect(arg0);
    }

    /**
     * @param arg0
     * @see javax.servlet.ServletResponse#setBufferSize(int)
     */
    public void setBufferSize(final int arg0) {
        this.originalResponse.setBufferSize(arg0);
    }

    /**
     * @param arg0
     * @see javax.servlet.ServletResponse#setCharacterEncoding(java.lang.String)
     */
    public void setCharacterEncoding(final String arg0) {
        this.originalResponse.setCharacterEncoding(arg0);
    }

    /**
     * @param arg0
     * @see javax.servlet.ServletResponse#setContentLength(int)
     */
    public void setContentLength(final int arg0) {
        this.originalResponse.setContentLength(arg0);
    }

    /**
     * @param arg0
     * @see javax.servlet.ServletResponse#setContentType(java.lang.String)
     */
    public void setContentType(final String arg0) {
        this.originalResponse.setContentType(arg0);
    }

    /**
     * @param arg0
     * @param arg1
     * @see javax.servlet.http.HttpServletResponse#setDateHeader(java.lang.String,
     *      long)
     */
    public void setDateHeader(final String arg0, final long arg1) {
        this.originalResponse.setDateHeader(arg0, arg1);
    }

    /**
     * @param arg0
     * @param arg1
     * @see javax.servlet.http.HttpServletResponse#setHeader(java.lang.String,
     *      java.lang.String)
     */
    public void setHeader(final String arg0, final String arg1) {
        this.originalResponse.setHeader(arg0, arg1);
    }

    /**
     * @param arg0
     * @param arg1
     * @see javax.servlet.http.HttpServletResponse#setIntHeader(java.lang.String,
     *      int)
     */
    public void setIntHeader(final String arg0, final int arg1) {
        this.originalResponse.setIntHeader(arg0, arg1);
    }

    /**
     * @param arg0
     * @see javax.servlet.ServletResponse#setLocale(java.util.Locale)
     */
    public void setLocale(final Locale arg0) {
        this.originalResponse.setLocale(arg0);
    }

    /**
     * @param arg0
     * @see javax.servlet.http.HttpServletResponse#setStatus(int)
     */
    public void setStatus(final int arg0) {
        this.originalResponse.setStatus(arg0);
    }

    /**
     * @param arg0
     * @param arg1
     * @deprecated
     * @see javax.servlet.http.HttpServletResponse#setStatus(int,
     *      java.lang.String)
     */
    @Deprecated
    public void setStatus(final int arg0, final String arg1) {
        this.originalResponse.setStatus(arg0, arg1);
    }


}
