/*
 * copyright postclass.jp 
 */
package jp.postclass.commons.http.filter.trimWhitespaces;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

import jp.postclass.commons.utils.UtilsForTag;

/**
 * 󔒂tB^[.
 * 
 * @author ryo
 */
public class TrimWhitespacesFilter implements Filter {

    private boolean trimNewline;

    /**
     * .
     */
    public void init(final FilterConfig config) throws ServletException {
        final String trimNewline = config.getInitParameter("trimNewline");
        if (trimNewline != null && !trimNewline.isEmpty()) {
            this.trimNewline = Boolean.valueOf(trimNewline);
        }
    }

    /**
     * I.
     */
    public void destroy() {
    }

    /**
     * tB^[s܂.
     */
    public void doFilter(final ServletRequest servletRequest,
                         final ServletResponse servletResponse,
                         final FilterChain chain)
            throws IOException, ServletException {

        final SelectableServletResponse selectableResponse =
                new SelectableServletResponse(
                        (HttpServletResponse) servletResponse);
        try {

            chain.doFilter(servletRequest, selectableResponse);

            if (selectableResponse.getResponse() instanceof ByteArrayServletResponse) {

                final ByteArrayServletOutputStream impl =
                        (ByteArrayServletOutputStream) selectableResponse.getOutputStream();

                impl.getWriter().flush();
                impl.getOut().flush();

                final String outputtedString = impl.getOut().toString();
                servletResponse.getWriter().print(
                        UtilsForTag.trimWhiteSpacesAndNewline(
                                outputtedString,
                                this.trimNewline));
            }

        } finally {
            final ByteArrayServletOutputStream impl =
                    (ByteArrayServletOutputStream) selectableResponse.getPoolableResponse().getOutputStream();

            try {
                impl.getWriter().close();
            } catch (final Exception e) {
                e.printStackTrace();
            }

            try {
                impl.getOut().close();
            } catch (final Exception e) {
                e.printStackTrace();
            }
        }
    }


}
