/*
 * copyright postclass.jp 
 */
package jp.postclass.commons.http.filter.trimWhitespaces;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Locale;

import javax.servlet.ServletOutputStream;

/**
 * o͂ɗߍServletOutputStream.
 * 
 * @author ryo
 */
public class ByteArrayServletOutputStream extends ServletOutputStream {

    private final OutputStream out = new ByteArrayOutputStream();
    private final PrintWriter writer = new PrintWriter(this.out);

    /**
     * @throws IOException
     * @see java.io.OutputStream#close()
     */
    @Override
    public void close() throws IOException {
        return;
    }

    /**
     * @throws IOException
     * @see java.io.OutputStream#flush()
     */
    @Override
    public void flush() throws IOException {
        return;
    }

    /* *****************************  ***************************** */

    /**
     * @return the out
     */
    public OutputStream getOut() {
        return this.out;
    }


    /**
     * @param obj
     * @return
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(final Object obj) {
        return this.out.equals(obj);
    }


    /**
     * @return
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        return this.out.hashCode();
    }

    /**
     * @return
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return this.out.toString();
    }

    /**
     * @param b
     * @param off
     * @param len
     * @throws IOException
     * @see java.io.OutputStream#write(byte[], int, int)
     */
    @Override
    public void write(final byte[] b, final int off, final int len)
            throws IOException {
        this.out.write(b, off, len);
    }

    /**
     * @param b
     * @throws IOException
     * @see java.io.OutputStream#write(byte[])
     */
    @Override
    public void write(final byte[] b) throws IOException {
        this.out.write(b);
    }

    /**
     * @param c
     * @return
     * @see java.io.PrintWriter#append(char)
     */
    public PrintWriter append(final char c) {
        return this.writer.append(c);
    }

    /**
     * @param csq
     * @param start
     * @param end
     * @return
     * @see java.io.PrintWriter#append(java.lang.CharSequence, int, int)
     */
    public PrintWriter append(final CharSequence csq,
                              final int start,
                              final int end) {
        return this.writer.append(csq, start, end);
    }

    /**
     * @param csq
     * @return
     * @see java.io.PrintWriter#append(java.lang.CharSequence)
     */
    public PrintWriter append(final CharSequence csq) {
        return this.writer.append(csq);
    }

    /**
     * @return
     * @see java.io.PrintWriter#checkError()
     */
    public boolean checkError() {
        return this.writer.checkError();
    }

    /**
     * @param l
     * @param format
     * @param args
     * @return
     * @see java.io.PrintWriter#format(java.util.Locale, java.lang.String,
     *      java.lang.Object[])
     */
    public PrintWriter format(final Locale l,
                              final String format,
                              final Object... args) {
        return this.writer.format(l, format, args);
    }

    /**
     * @param format
     * @param args
     * @return
     * @see java.io.PrintWriter#format(java.lang.String, java.lang.Object[])
     */
    public PrintWriter format(final String format, final Object... args) {
        return this.writer.format(format, args);
    }

    /**
     * @param b
     * @see java.io.PrintWriter#print(boolean)
     */
    @Override
    public void print(final boolean b) {
        this.writer.print(b);
    }

    /**
     * @param c
     * @see java.io.PrintWriter#print(char)
     */
    @Override
    public void print(final char c) {
        this.writer.print(c);
    }

    /**
     * @param s
     * @see java.io.PrintWriter#print(char[])
     */
    public void print(final char[] s) {
        this.writer.print(s);
    }

    /**
     * @param d
     * @see java.io.PrintWriter#print(double)
     */
    @Override
    public void print(final double d) {
        this.writer.print(d);
    }

    /**
     * @param f
     * @see java.io.PrintWriter#print(float)
     */
    @Override
    public void print(final float f) {
        this.writer.print(f);
    }

    /**
     * @param i
     * @see java.io.PrintWriter#print(int)
     */
    @Override
    public void print(final int i) {
        this.writer.print(i);
    }

    /**
     * @param l
     * @see java.io.PrintWriter#print(long)
     */
    @Override
    public void print(final long l) {
        this.writer.print(l);
    }

    /**
     * @param obj
     * @see java.io.PrintWriter#print(java.lang.Object)
     */
    public void print(final Object obj) {
        this.writer.print(obj);
    }

    /**
     * @param s
     * @see java.io.PrintWriter#print(java.lang.String)
     */
    @Override
    public void print(final String s) {
        this.writer.print(s);
    }

    /**
     * @param l
     * @param format
     * @param args
     * @return
     * @see java.io.PrintWriter#printf(java.util.Locale, java.lang.String,
     *      java.lang.Object[])
     */
    public PrintWriter printf(final Locale l,
                              final String format,
                              final Object... args) {
        return this.writer.printf(l, format, args);
    }

    /**
     * @param format
     * @param args
     * @return
     * @see java.io.PrintWriter#printf(java.lang.String, java.lang.Object[])
     */
    public PrintWriter printf(final String format, final Object... args) {
        return this.writer.printf(format, args);
    }

    /**
     * 
     * @see java.io.PrintWriter#println()
     */
    @Override
    public void println() {
        this.writer.println();
    }

    /**
     * @param x
     * @see java.io.PrintWriter#println(boolean)
     */
    @Override
    public void println(final boolean x) {
        this.writer.println(x);
    }

    /**
     * @param x
     * @see java.io.PrintWriter#println(char)
     */
    @Override
    public void println(final char x) {
        this.writer.println(x);
    }

    /**
     * @param x
     * @see java.io.PrintWriter#println(char[])
     */
    public void println(final char[] x) {
        this.writer.println(x);
    }

    /**
     * @param x
     * @see java.io.PrintWriter#println(double)
     */
    @Override
    public void println(final double x) {
        this.writer.println(x);
    }

    /**
     * @param x
     * @see java.io.PrintWriter#println(float)
     */
    @Override
    public void println(final float x) {
        this.writer.println(x);
    }

    /**
     * @param x
     * @see java.io.PrintWriter#println(int)
     */
    @Override
    public void println(final int x) {
        this.writer.println(x);
    }

    /**
     * @param x
     * @see java.io.PrintWriter#println(long)
     */
    @Override
    public void println(final long x) {
        this.writer.println(x);
    }

    /**
     * @param x
     * @see java.io.PrintWriter#println(java.lang.Object)
     */
    public void println(final Object x) {
        this.writer.println(x);
    }

    /**
     * @param x
     * @see java.io.PrintWriter#println(java.lang.String)
     */
    @Override
    public void println(final String x) {
        this.writer.println(x);
    }

    /**
     * @param buf
     * @param off
     * @param len
     * @see java.io.PrintWriter#write(char[], int, int)
     */
    public void write(final char[] buf, final int off, final int len) {
        this.writer.write(buf, off, len);
    }

    /**
     * @param buf
     * @see java.io.PrintWriter#write(char[])
     */
    public void write(final char[] buf) {
        this.writer.write(buf);
    }

    /**
     * @param c
     * @see java.io.PrintWriter#write(int)
     */
    @Override
    public void write(final int c) {
        this.writer.write(c);
    }

    /**
     * @param s
     * @param off
     * @param len
     * @see java.io.PrintWriter#write(java.lang.String, int, int)
     */
    public void write(final String s, final int off, final int len) {
        this.writer.write(s, off, len);
    }

    /**
     * @param s
     * @see java.io.PrintWriter#write(java.lang.String)
     */
    public void write(final String s) {
        this.writer.write(s);
    }

    /**
     * @return the writer
     */
    public PrintWriter getWriter() {
        return this.writer;
    }


}
