/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ErrorService;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;

public class URLOpener {
    private URL url;
    private URLConnection connection = null;
    private boolean timedOut = false;

    public URLOpener(URL url) {
        this.url = url;
    }

    public synchronized URLConnection connect(int timeout) throws IOException {
        Thread t = new Thread((Runnable)new URLOpenerThread(), "URLOpener");
        t.start();
        Assert.that(this.connection == null, "Connection already established w.o. lock.");
        try {
            this.wait(timeout);
        }
        catch (InterruptedException e) {
            if (this.connection == null) {
                this.timedOut = true;
            } else {
                URLOpener.close(this.connection);
            }
            throw new IOException();
        }
        if (this.connection != null) {
            return this.connection;
        }
        this.timedOut = true;
        throw new IOException();
    }

    private static void close(URLConnection conn) {
        if (conn instanceof HttpURLConnection) {
            ((HttpURLConnection)conn).disconnect();
        }
    }

    private class URLOpenerThread
    implements Runnable {
        private URLOpenerThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                URLConnection conn = null;
                try {
                    conn = URLOpener.this.url.openConnection();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                URLOpener uRLOpener = URLOpener.this;
                synchronized (uRLOpener) {
                    if (URLOpener.this.timedOut && conn != null) {
                        URLOpener.close(conn);
                    } else {
                        URLOpener.this.connection = conn;
                        URLOpener.this.notify();
                    }
                }
            }
            catch (Throwable t) {
                ErrorService.error(t);
            }
        }
    }
}

