/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.util.TrieEdge;
import com.limegroup.gnutella.util.UnmodifiableIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;

final class TrieNode {
    private Object value = null;
    private Vector children = new Vector(0);

    public TrieNode() {
    }

    public TrieNode(Object value) {
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    private final TrieEdge get(int i) {
        return (TrieEdge)this.children.get(i);
    }

    private final int search(char c, boolean exact) {
        int low = 0;
        int high = this.children.size() - 1;
        while (low <= high) {
            int middle = (low + high) / 2;
            char cmiddle = this.get(middle).getLabelStart();
            if (cmiddle < c) {
                low = middle + 1;
                continue;
            }
            if (c < cmiddle) {
                high = middle - 1;
                continue;
            }
            return middle;
        }
        if (exact) {
            return -1;
        }
        return high;
    }

    public TrieEdge get(char labelStart) {
        int i = this.search(labelStart, true);
        if (i < 0) {
            return null;
        }
        TrieEdge ret = this.get(i);
        Assert.that(ret.getLabelStart() == labelStart);
        return ret;
    }

    public void put(String label, TrieNode child) {
        char labelStart = label.charAt(0);
        int i = this.search(labelStart, false);
        if (i >= 0) {
            Assert.that(this.get(i).getLabelStart() != labelStart, "Precondition of TrieNode.put violated.");
        }
        this.children.add(i + 1, new TrieEdge(label, child));
    }

    public boolean remove(char labelStart) {
        int i = this.search(labelStart, true);
        if (i == -1) {
            return false;
        }
        Assert.that(this.get(i).getLabelStart() == labelStart);
        this.children.remove(i);
        return true;
    }

    public void trim() {
        this.children.trimToSize();
    }

    public Iterator childrenForward() {
        return new ChildrenForwardIterator();
    }

    public Iterator labelsForward() {
        return new LabelForwardIterator();
    }

    public String toString() {
        Object val = this.getValue();
        if (val == null) {
            return "NULL";
        }
        return val.toString();
    }

    private class LabelForwardIterator
    extends UnmodifiableIterator {
        int i = 0;

        private LabelForwardIterator() {
        }

        public boolean hasNext() {
            return this.i < TrieNode.this.children.size();
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            TrieEdge edge = TrieNode.this.get(this.i);
            ++this.i;
            return edge.getLabel();
        }
    }

    private class ChildrenForwardIterator
    extends UnmodifiableIterator {
        int i = 0;

        private ChildrenForwardIterator() {
        }

        public boolean hasNext() {
            return this.i < TrieNode.this.children.size();
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            TrieEdge edge = TrieNode.this.get(this.i);
            ++this.i;
            return edge.getChild();
        }
    }
}

