/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class ThreadWorkGroup {
    private List _tasks = new Vector();
    private List _workers = new Vector();
    private final CleanUpInterface _cleaner;
    private boolean _stopped = false;

    public ThreadWorkGroup(WorkerInterface[] workers, CleanUpInterface cleaner) throws IllegalArgumentException {
        for (int i = 0; i < workers.length; ++i) {
            this.addWorker(workers[i]);
        }
        if (this._workers.size() != workers.length) {
            throw new IllegalArgumentException("Invalid workers input!");
        }
        this._cleaner = cleaner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(Object[] input) {
        List list = this._tasks;
        synchronized (list) {
            this._tasks.add(input);
            this._tasks.notify();
        }
    }

    public synchronized void addWorker(WorkerInterface worker) {
        if (worker != null && this.isActive()) {
            WorkerThread workerThread = new WorkerThread(worker);
            this._workers.add(workerThread);
            workerThread.start();
        }
    }

    public boolean isActive() {
        return !this._stopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean stop(int waitTime) throws InterruptedException {
        this._stopped = true;
        boolean retVal = true;
        List list = this._workers;
        synchronized (list) {
            Iterator workers = this._workers.iterator();
            while (workers.hasNext()) {
                ((Thread)workers.next()).interrupt();
            }
            workers = this._workers.iterator();
            while (workers.hasNext()) {
                ((Thread)workers.next()).join(waitTime);
            }
            workers = this._workers.iterator();
            while (workers.hasNext() && retVal) {
                if (!((Thread)workers.next()).isAlive()) continue;
                retVal = false;
            }
            this._workers.clear();
        }
        return retVal;
    }

    private class WorkerThread
    extends Thread {
        private final WorkerInterface _worker;

        public WorkerThread(WorkerInterface worker) {
            super("WorkerThread");
            this._worker = worker;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (ThreadWorkGroup.this.isActive()) {
                try {
                    Object[] workInput = null;
                    List list = ThreadWorkGroup.this._tasks;
                    synchronized (list) {
                        while (ThreadWorkGroup.this._tasks.isEmpty()) {
                            ThreadWorkGroup.this._tasks.wait();
                        }
                        workInput = (Object[])ThreadWorkGroup.this._tasks.remove(0);
                    }
                    if (this._worker.checkInput(workInput)) {
                        this._worker.run();
                    }
                    if (ThreadWorkGroup.this._cleaner == null) continue;
                    ThreadWorkGroup.this._cleaner.cleanUp(workInput);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public static interface CleanUpInterface {
        public void cleanUp(Object[] var1);
    }

    public static interface WorkerInterface
    extends Runnable {
        public boolean checkInput(Object[] var1);

        public void run();
    }
}

