/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.settings.ConnectionSettings;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;

public final class NetworkUtils {
    private NetworkUtils() {
    }

    public static boolean isValidPort(int port) {
        if ((port & 0xFFFF0000) != 0) {
            return false;
        }
        return port != 0;
    }

    public static boolean isValidAddress(byte[] addr) {
        return addr[0] != 0 || addr[1] != 0 || addr[2] != 0 || addr[3] != 0;
    }

    public static boolean isValidAddress(InetAddress addr) {
        return NetworkUtils.isValidAddress(addr.getAddress());
    }

    public static boolean isLocalAddress(InetAddress addr) {
        try {
            InetAddress address = InetAddress.getLocalHost();
            byte[] byteAddress = addr.getAddress();
            return address.equals(addr) || byteAddress[0] == 127;
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    public static boolean isCloseIP(byte[] addr0, byte[] addr1) {
        return addr0[0] == addr1[0];
    }

    public static boolean isVeryCloseIP(byte[] addr0, byte[] addr1) {
        if (NetworkUtils.isPrivateAddress(addr0)) {
            return false;
        }
        return addr0[0] == addr1[0] && addr0[1] == addr1[1];
    }

    public static boolean isVeryCloseIP(byte[] addr) {
        return NetworkUtils.isVeryCloseIP(RouterService.getAddress(), addr);
    }

    public static boolean isPrivate() {
        return NetworkUtils.isPrivateAddress(RouterService.getAddress());
    }

    public static boolean isPrivateAddress(byte[] address) {
        if (!ConnectionSettings.LOCAL_IS_PRIVATE.getValue()) {
            return false;
        }
        if (address[0] == 10) {
            return true;
        }
        if (address[0] == 127) {
            return true;
        }
        if (address[0] == -84 && address[1] >= 16 && address[1] <= 31) {
            return true;
        }
        if (address[0] == -64 && address[1] == -88) {
            return true;
        }
        if (address[0] == -87 && address[1] == -2) {
            return true;
        }
        return address[0] == 0;
    }

    public static boolean isPrivateAddress(String address) throws UnknownHostException {
        return NetworkUtils.isPrivateAddress(InetAddress.getByName(address).getAddress());
    }

    public static final String ip2string(byte[] ip) {
        return NetworkUtils.ip2string(ip, 0);
    }

    public static final String ip2string(byte[] ip, int offset) {
        StringBuffer sbuf = new StringBuffer(16);
        sbuf.append(ByteOrder.ubyte2int(ip[offset]));
        sbuf.append('.');
        sbuf.append(ByteOrder.ubyte2int(ip[offset + 1]));
        sbuf.append('.');
        sbuf.append(ByteOrder.ubyte2int(ip[offset + 2]));
        sbuf.append('.');
        sbuf.append(ByteOrder.ubyte2int(ip[offset + 3]));
        return sbuf.toString();
    }

    public static boolean isMe(String host, int port) {
        byte[] cIP;
        try {
            cIP = InetAddress.getByName(host).getAddress();
        }
        catch (IOException e) {
            return false;
        }
        if (cIP[0] == 127) {
            return port == RouterService.getPort();
        }
        byte[] managerIP = RouterService.getAddress();
        return port == RouterService.getPort() && Arrays.equals(cIP, managerIP);
    }
}

