/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.ByteOrder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class COBSUtil {
    public static byte[] cobsEncode(byte[] src) throws IOException {
        int srcLen = src.length;
        int code = 1;
        ByteArrayOutputStream sink = new ByteArrayOutputStream();
        ByteArrayOutputStream temp = new ByteArrayOutputStream();
        for (int currIndex = 0; currIndex < srcLen; ++currIndex) {
            if (src[currIndex] == 0) {
                sink.write(code);
                sink.write(temp.toByteArray());
                temp.reset();
                code = 1;
                continue;
            }
            temp.write(src[currIndex]);
            if (++code != 255) continue;
            sink.write(code);
            sink.write(temp.toByteArray());
            temp.reset();
            code = 1;
        }
        sink.write(code);
        sink.write(temp.toByteArray());
        return sink.toByteArray();
    }

    public static byte[] cobsDecode(byte[] src) throws IOException {
        int srcLen = src.length;
        int currIndex = 0;
        int code = 0;
        ByteArrayOutputStream sink = new ByteArrayOutputStream();
        while (currIndex < srcLen) {
            if (currIndex + ((code = ByteOrder.ubyte2int(src[currIndex++])) - 2) >= srcLen) {
                throw new IOException();
            }
            for (int i = 1; i < code; ++i) {
                sink.write(src[currIndex++]);
            }
            if (code >= 255) continue;
            sink.write(0);
        }
        return sink.toByteArray();
    }
}

