/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.limegroup.gnutella.AlternateLocation;
import com.limegroup.gnutella.AlternateLocationCollection;
import com.limegroup.gnutella.AlternateLocationCollector;
import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.BandwidthTrackerImpl;
import com.limegroup.gnutella.ByteReader;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HTTPMessage;
import com.limegroup.gnutella.http.HTTPRequestMethod;
import com.limegroup.gnutella.http.HTTPUtils;
import com.limegroup.gnutella.http.ProblemReadingHeaderException;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.statistics.BandwidthStat;
import com.limegroup.gnutella.uploader.BrowseHostUploadState;
import com.limegroup.gnutella.uploader.FileNotFoundUploadState;
import com.limegroup.gnutella.uploader.FreeloaderUploadState;
import com.limegroup.gnutella.uploader.FreeloaderUploadingException;
import com.limegroup.gnutella.uploader.LimitReachedUploadState;
import com.limegroup.gnutella.uploader.MalformedRequestState;
import com.limegroup.gnutella.uploader.NormalUploadState;
import com.limegroup.gnutella.uploader.PushProxyUploadState;
import com.limegroup.gnutella.uploader.QueuedUploadState;
import com.limegroup.gnutella.uploader.StalledUploadWatchdog;
import com.limegroup.gnutella.uploader.UnavailableRangeUploadState;
import com.limegroup.gnutella.uploader.UpdateFileState;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.NetworkUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.StringTokenizer;

public final class HTTPUploader
implements Uploader {
    private OutputStream _ostream;
    private InputStream _fis;
    private Socket _socket;
    private int _totalAmountRead;
    private int _amountRead;
    private int _amountRequested;
    private int _uploadBegin;
    private int _uploadEnd;
    private int _fileSize;
    private final int _index;
    private String _userAgent;
    private boolean _headersParsed;
    private final String _fileName;
    private final String _hostName;
    private int _stateNum = 0;
    private int _lastTransferStateNum;
    private HTTPMessage _state;
    private boolean _chatEnabled;
    private boolean _browseEnabled;
    private int _gnutellaPort;
    private boolean _supportsQueueing = false;
    private final StalledUploadWatchdog STALLED_WATCHDOG;
    private URN _requestedURN;
    private FileDesc _fileDesc;
    private boolean _clientAcceptsXGnutellaQueryreplies = false;
    private InetAddress _nodeAddress = null;
    private int _nodePort = -1;
    private Map _parameters = null;
    private BandwidthTrackerImpl bandwidthTracker = null;
    private AlternateLocationCollection _alternateLocationCollection;
    private HTTPRequestMethod _method;
    private static final boolean RECORD_STATS = !CommonUtils.isJava118();
    private final boolean debugOn = false;

    public HTTPUploader(HTTPRequestMethod method, String fileName, Socket socket, int index, Map params, StalledUploadWatchdog dog) {
        this.STALLED_WATCHDOG = dog;
        this._socket = socket;
        this._hostName = this._socket.getInetAddress().getHostAddress();
        this._fileName = fileName;
        this._index = index;
        this.reinitialize(method, params);
    }

    public void reinitialize(HTTPRequestMethod method, Map params) {
        this._method = method;
        this._amountRequested = 0;
        this._uploadBegin = 0;
        this._uploadEnd = 0;
        this._headersParsed = false;
        this._stateNum = 0;
        this._state = null;
        this._gnutellaPort = 0;
        this._supportsQueueing = false;
        this._requestedURN = null;
        this._clientAcceptsXGnutellaQueryreplies = false;
        this._alternateLocationCollection = null;
        this._parameters = params;
        if (this.bandwidthTracker == null) {
            this.bandwidthTracker = new BandwidthTrackerImpl();
            this._totalAmountRead = 0;
            this._amountRead = 0;
        } else {
            this._totalAmountRead += this._amountRead;
            this._amountRead = 0;
        }
    }

    public void setFileDesc(FileDesc fd) throws IOException {
        this._fileDesc = fd;
        this._fileSize = (int)fd.getSize();
        if (this._fis != null) {
            try {
                this._fis.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this._fis = this._fileDesc.createInputStream();
    }

    public void initializeStreams() throws IOException {
        this._ostream = this._socket.getOutputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeResponse() throws IOException {
        try {
            try {
                this._method.writeHttpResponse(this._state, this._ostream);
            }
            catch (IOException e) {
                if (this._amountRead < this._amountRequested) {
                    throw e;
                }
                Object var3_2 = null;
                if (this._alternateLocationCollection == null) return;
                if (this._fileDesc == null) return;
                this._fileDesc.addAlternateLocationCollection(this._alternateLocationCollection);
                return;
            }
            Object var3_1 = null;
            if (this._alternateLocationCollection == null) return;
            if (this._fileDesc == null) return;
            this._fileDesc.addAlternateLocationCollection(this._alternateLocationCollection);
            return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (this._alternateLocationCollection == null) throw throwable;
            if (this._fileDesc == null) throw throwable;
            this._fileDesc.addAlternateLocationCollection(this._alternateLocationCollection);
            throw throwable;
        }
    }

    public void stop() {
        try {
            if (this._ostream != null) {
                this._ostream.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            if (this._fis != null) {
                this._fis.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            if (this._socket != null) {
                this._socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void closeFileStreams() {
        try {
            if (this._fis != null) {
                this._fis.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setState(int state) {
        this._stateNum = state;
        switch (state) {
            case 3: {
                this._state = new NormalUploadState(this, this.STALLED_WATCHDOG);
                break;
            }
            case 9: {
                int pos = RouterService.getUploadManager().positionInQueue(this._socket);
                this._state = new QueuedUploadState(pos, this._fileDesc);
                break;
            }
            case 2: {
                this._state = new LimitReachedUploadState(this._fileDesc);
                break;
            }
            case 1: {
                this._state = new FreeloaderUploadState();
                break;
            }
            case 8: {
                this._state = new BrowseHostUploadState(this);
                break;
            }
            case 12: {
                this._state = new PushProxyUploadState(this);
                break;
            }
            case 10: {
                this._state = new UpdateFileState(this);
                break;
            }
            case 7: {
                this._state = new FileNotFoundUploadState();
                break;
            }
            case 11: {
                this._state = new MalformedRequestState();
                break;
            }
            case 13: {
                this._state = new UnavailableRangeUploadState(this._fileDesc);
                break;
            }
            case 0: 
            case 4: 
            case 5: {
                this._state = null;
                break;
            }
            default: {
                Assert.that(false, "Invalid state: " + state);
            }
        }
        switch (state) {
            case 0: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                this._lastTransferStateNum = state;
            }
        }
        RouterService.getCallback().uploaderStateChanged(this);
    }

    OutputStream getOutputStream() {
        return this._ostream;
    }

    InputStream getInputStream() {
        return this._fis;
    }

    public boolean getCloseConnection() {
        Assert.that(this._state != null);
        return this._state.getCloseConnection();
    }

    public HTTPRequestMethod getMethod() {
        return this._method;
    }

    public int getQueuePosition() {
        if (this._lastTransferStateNum != 9 || this._stateNum == 5) {
            return -1;
        }
        return RouterService.getUploadManager().positionInQueue(this._socket);
    }

    void setAmountUploaded(int amount) {
        int newData = amount - this._amountRead;
        if (RECORD_STATS && newData > 0) {
            BandwidthStat.HTTP_BODY_UPSTREAM_BANDWIDTH.addData(newData);
        }
        this._amountRead = amount;
    }

    public boolean isInactive() {
        switch (this._stateNum) {
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    Map getParameters() {
        return this._parameters;
    }

    public int getUploadBegin() {
        return this._uploadBegin;
    }

    public int getUploadEnd() {
        return this._uploadEnd;
    }

    public int getFileSize() {
        return this._fileSize;
    }

    public int getAmountRequested() {
        return this._amountRequested;
    }

    public int getIndex() {
        return this._index;
    }

    public String getFileName() {
        return this._fileName;
    }

    public int getState() {
        return this._stateNum;
    }

    public int getLastTransferState() {
        return this._lastTransferStateNum;
    }

    public String getHost() {
        return this._hostName;
    }

    public boolean isChatEnabled() {
        return this._chatEnabled;
    }

    public boolean isBrowseHostEnabled() {
        return this._browseEnabled;
    }

    public int getGnutellaPort() {
        return this._gnutellaPort;
    }

    public String getUserAgent() {
        return this._userAgent;
    }

    public boolean isHeaderParsed() {
        return this._headersParsed;
    }

    public boolean supportsQueueing() {
        return this._supportsQueueing && this.isValidQueueingAgent();
    }

    private boolean isValidQueueingAgent() {
        if (this._userAgent == null) {
            return true;
        }
        return !this._userAgent.startsWith("Morpheus 3.0.2");
    }

    public InetAddress getNodeAddress() {
        return this._nodeAddress;
    }

    public int getNodePort() {
        return this._nodePort;
    }

    public int amountUploaded() {
        return this._amountRead;
    }

    public int getTotalAmountUploaded() {
        return this._totalAmountRead + this._amountRead;
    }

    public FileDesc getFileDesc() {
        return this._fileDesc;
    }

    boolean getClientAcceptsXGnutellaQueryreplies() {
        return this._clientAcceptsXGnutellaQueryreplies;
    }

    public URN getRequestedURN() {
        return this._requestedURN;
    }

    public void readHeader(InputStream iStream) throws IOException {
        this._uploadBegin = 0;
        this._uploadEnd = 0;
        this._clientAcceptsXGnutellaQueryreplies = false;
        ByteReader br = new ByteReader(iStream);
        try {
            try {
                String str;
                while ((str = br.readLine()) != null && !str.equals("")) {
                    if (RECORD_STATS) {
                        BandwidthStat.HTTP_HEADER_DOWNSTREAM_BANDWIDTH.addData(str.length());
                    }
                    this.debug("HTTPUploader.readHeader(): str = " + str);
                    if (!this.readChatHeader(str) && !this.readRangeHeader(str) && !this.readUserAgentHeader(str) && !this.readContentURNHeader(str) && !this.readAltLocationHeader(str) && !this.readAcceptHeader(str) && !this.readQueueVersion(str) && !this.readNodeHeader(str)) continue;
                }
                Object var6_5 = null;
                if (this._uploadEnd <= 0 || this._uploadEnd <= this._uploadBegin || this._uploadEnd > this._fileSize) {
                    this._uploadEnd = this._fileSize;
                }
                this._amountRequested = this._uploadEnd - this._uploadBegin;
                this._headersParsed = true;
            }
            catch (ProblemReadingHeaderException prhe) {
                String str;
                while ((str = br.readLine()) != null && !str.equals("")) {
                }
                throw prhe;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (this._uploadEnd <= 0 || this._uploadEnd <= this._uploadBegin || this._uploadEnd > this._fileSize) {
                this._uploadEnd = this._fileSize;
            }
            this._amountRequested = this._uploadEnd - this._uploadBegin;
            this._headersParsed = true;
            throw throwable;
        }
    }

    private boolean readChatHeader(String str) throws IOException {
        int port;
        String sub;
        if (str.toUpperCase().indexOf("CHAT:") == -1) {
            return false;
        }
        try {
            sub = str.substring(5);
        }
        catch (IndexOutOfBoundsException e) {
            throw new ProblemReadingHeaderException();
        }
        sub = sub.trim();
        int colon = sub.indexOf(":");
        String host = sub.substring(0, colon);
        host = host.trim();
        String sport = sub.substring(colon + 1);
        sport = sport.trim();
        try {
            port = Integer.parseInt(sport);
        }
        catch (NumberFormatException e) {
            throw new ProblemReadingHeaderException();
        }
        this._chatEnabled = true;
        this._browseEnabled = true;
        this._gnutellaPort = port;
        return true;
    }

    private boolean readRangeHeader(String str) throws IOException {
        String second;
        String first;
        char c;
        String sub;
        if (this.indexOfIgnoreCase(str, "Range:") == -1) {
            return false;
        }
        try {
            int i = str.indexOf("bytes");
            if (i < 0) {
                throw new ProblemReadingHeaderException("bytes not present in range");
            }
            sub = str.substring(i += 6);
        }
        catch (IndexOutOfBoundsException e) {
            throw new ProblemReadingHeaderException();
        }
        sub = sub.trim();
        try {
            c = sub.charAt(0);
        }
        catch (IndexOutOfBoundsException e) {
            throw new ProblemReadingHeaderException();
        }
        if (c == '-') {
            String second2;
            try {
                second2 = sub.substring(1);
            }
            catch (IndexOutOfBoundsException e) {
                throw new ProblemReadingHeaderException();
            }
            second2 = second2.trim();
            try {
                this._uploadBegin = Math.max(0, this._fileSize - Integer.parseInt(second2));
                this._uploadEnd = this._fileSize;
            }
            catch (NumberFormatException e) {
                throw new ProblemReadingHeaderException();
            }
        }
        int dash = sub.indexOf("-");
        try {
            first = sub.substring(0, dash);
        }
        catch (IndexOutOfBoundsException e) {
            throw new ProblemReadingHeaderException();
        }
        first = first.trim();
        try {
            this._uploadBegin = Integer.parseInt(first);
        }
        catch (NumberFormatException e) {
            throw new ProblemReadingHeaderException();
        }
        try {
            second = sub.substring(dash + 1);
        }
        catch (IndexOutOfBoundsException e) {
            throw new ProblemReadingHeaderException();
        }
        second = second.trim();
        if (!second.equals("")) {
            try {
                this._uploadEnd = Integer.parseInt(second) + 1;
            }
            catch (NumberFormatException e) {
                throw new ProblemReadingHeaderException();
            }
        }
        return true;
    }

    private boolean readUserAgentHeader(String str) throws FreeloaderUploadingException {
        if (this.indexOfIgnoreCase(str, "User-Agent:") == -1) {
            return false;
        }
        if (!(SharingSettings.ALLOW_BROWSER.getValue() || this._stateNum == 8 || this._stateNum == 12 || this._fileName.toUpperCase().startsWith("LIMEWIRE") || str.indexOf("Mozilla") == -1 && str.indexOf("DA") == -1 && str.indexOf("Download") == -1 && str.indexOf("FlashGet") == -1 && str.indexOf("GetRight") == -1 && str.indexOf("Go!Zilla") == -1 && str.indexOf("Inet") == -1 && str.indexOf("MIIxpc") == -1 && str.indexOf("MSProxy") == -1 && str.indexOf("Mass") == -1 && str.indexOf("MyGetRight") == -1 && str.indexOf("NetAnts") == -1 && str.indexOf("NetZip") == -1 && str.indexOf("RealDownload") == -1 && str.indexOf("SmartDownload") == -1 && str.indexOf("Teleport") == -1 && str.indexOf("WebDownloader") == -1)) {
            throw new FreeloaderUploadingException();
        }
        this._userAgent = str.substring(11).trim();
        return true;
    }

    private boolean readContentURNHeader(String str) {
        if (!HTTPHeaderName.GNUTELLA_CONTENT_URN.matchesStartOfString(str)) {
            return false;
        }
        this._requestedURN = HTTPUploader.parseContentUrn(str);
        return true;
    }

    private boolean readAltLocationHeader(String str) {
        if (!HTTPHeaderName.ALT_LOCATION.matchesStartOfString(str)) {
            return false;
        }
        if (this._alternateLocationCollection == null && this._fileDesc != null) {
            this._alternateLocationCollection = AlternateLocationCollection.createCollection(this._fileDesc.getSHA1Urn());
        }
        if (this._alternateLocationCollection != null) {
            HTTPUploader.parseAlternateLocations(str, this._alternateLocationCollection);
        }
        return true;
    }

    private boolean readAcceptHeader(String str) {
        if (this.indexOfIgnoreCase(str, "accept:") == -1) {
            return false;
        }
        if (this.indexOfIgnoreCase(str, "application/x-gnutella-packets") != -1) {
            this._clientAcceptsXGnutellaQueryreplies = true;
        }
        return true;
    }

    private boolean readQueueVersion(String str) {
        if (!HTTPHeaderName.QUEUE_HEADER.matchesStartOfString(str)) {
            return false;
        }
        this._supportsQueueing = true;
        return true;
    }

    private boolean readNodeHeader(String str) {
        if (this.indexOfIgnoreCase(str, "X-Node") == -1) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(HTTPUtils.extractHeaderValue(str), ":");
        InetAddress tempAddr = null;
        int tempPort = -1;
        if (st.countTokens() == 2) {
            try {
                tempAddr = InetAddress.getByName(st.nextToken().trim());
                tempPort = Integer.parseInt(st.nextToken().trim());
                if (NetworkUtils.isValidPort(tempPort)) {
                    this._nodeAddress = tempAddr;
                    this._nodePort = tempPort;
                }
            }
            catch (UnknownHostException badHost) {
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return true;
    }

    private static URN parseContentUrn(String contentUrnStr) {
        String urnStr = HTTPUtils.extractHeaderValue(contentUrnStr);
        if (urnStr == null) {
            return URN.INVALID;
        }
        try {
            return URN.createSHA1Urn(urnStr);
        }
        catch (IOException e) {
            return URN.INVALID;
        }
    }

    private static void parseAlternateLocations(String altHeader, AlternateLocationCollector alc) {
        String alternateLocations = HTTPUtils.extractHeaderValue(altHeader);
        if (alternateLocations == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(alternateLocations, ",");
        while (st.hasMoreTokens()) {
            try {
                AlternateLocation al = AlternateLocation.createAlternateLocation(st.nextToken().trim());
                URN sha1 = al.getSHA1Urn();
                if (!sha1.equals(alc.getSHA1Urn())) continue;
                alc.addAlternateLocation(al);
            }
            catch (IOException e) {}
        }
    }

    private int indexOfIgnoreCase(String str, String section) {
        String aaa = str.toLowerCase();
        String bbb = section.toLowerCase();
        return aaa.indexOf(bbb);
    }

    public void measureBandwidth() {
        this.bandwidthTracker.measureBandwidth(this.getTotalAmountUploaded());
    }

    public float getMeasuredBandwidth() {
        float retVal = 0.0f;
        try {
            retVal = this.bandwidthTracker.getMeasuredBandwidth();
        }
        catch (InsufficientDataException ide) {
            retVal = 0.0f;
        }
        return retVal;
    }

    public float getAverageBandwidth() {
        return this.bandwidthTracker.getAverageBandwidth();
    }

    private void debug(String out) {
    }

    public String toString() {
        return "<" + this._hostName + ":" + this._index + ">";
    }
}

