/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.settings;

import com.limegroup.gnutella.settings.Setting;
import com.limegroup.gnutella.util.StringUtils;
import java.util.Properties;

public class StringArraySetting
extends Setting {
    private String[] value;

    StringArraySetting(Properties defaultProps, Properties props, String key, String[] defaultValue) {
        super(defaultProps, props, key, StringArraySetting.decode(defaultValue));
    }

    public String[] getValue() {
        return this.value;
    }

    public void setValue(String[] value) {
        super.setValue(StringArraySetting.decode(value));
    }

    protected void loadValue(String sValue) {
        this.value = StringArraySetting.encode(sValue);
    }

    private static final String[] encode(String src) {
        if (src == null || src.length() == 0) {
            return new String[0];
        }
        return StringUtils.split(src, ";");
    }

    private static final String decode(String[] src) {
        if (src == null || src.length == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < src.length; ++i) {
            buffer.append(src[i]);
            if (i >= src.length - 1) continue;
            buffer.append(';');
        }
        return buffer.toString();
    }
}

