/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.settings;

import com.limegroup.gnutella.settings.Setting;
import java.awt.Color;
import java.util.Properties;

public final class ColorSetting
extends Setting {
    private Color value;

    static ColorSetting createColorSetting(Properties defaultProps, Properties props, String key, Color defaultColor) {
        return new ColorSetting(defaultProps, props, key, ColorSetting.formatColor(defaultColor));
    }

    private ColorSetting(Properties defaultProps, Properties props, String key, String value) {
        super(defaultProps, props, key, value);
    }

    public Color getValue() {
        return this.value;
    }

    public void setValue(Color value) {
        super.setValue(ColorSetting.formatColor(value));
        this.value = value;
    }

    protected void loadValue(String sValue) {
        sValue = sValue.trim();
        try {
            int r = Integer.parseInt(sValue.substring(1, 3), 16);
            int g = Integer.parseInt(sValue.substring(3, 5), 16);
            int b = Integer.parseInt(sValue.substring(5, 7), 16);
            this.value = new Color(r, g, b);
        }
        catch (NumberFormatException nfe) {
            this.revertToDefault();
        }
    }

    private static String formatColor(Color color) {
        String red = Integer.toHexString(color.getRed());
        String green = Integer.toHexString(color.getGreen());
        String blue = Integer.toHexString(color.getBlue());
        if (red.length() == 1) {
            red = "0" + red;
        }
        if (green.length() == 1) {
            green = "0" + green;
        }
        if (blue.length() == 1) {
            blue = "0" + blue;
        }
        return "#" + red + green + blue;
    }
}

