/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.search;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.search.QueryHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class QueryDispatcher
implements Runnable {
    private final Map QUERIES = new HashMap();
    private final List NEW_QUERIES = Collections.synchronizedList(new LinkedList());
    private static volatile boolean _done = true;
    private static final QueryDispatcher INSTANCE = new QueryDispatcher();

    public static QueryDispatcher instance() {
        return INSTANCE;
    }

    private QueryDispatcher() {
    }

    public void start() {
        Thread dispatcher = new Thread((Runnable)this, "QueryDispatcher");
        dispatcher.setDaemon(true);
        dispatcher.start();
    }

    public void addQuery(QueryHandler handler) {
        handler.sendQuery();
        this.NEW_QUERIES.add(handler);
    }

    public void removeReplyHandler(ReplyHandler handler) {
        if (!handler.isSupernodeClientConnection()) {
            return;
        }
        QueryDispatcher.removeFromCollection(this.NEW_QUERIES, handler);
        QueryDispatcher.removeFromMap(this.QUERIES, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLeafResultsForQuery(GUID queryGUID, int numResults) {
        Map map = this.QUERIES;
        synchronized (map) {
            QueryHandler qh = (QueryHandler)this.QUERIES.get(queryGUID);
            if (qh != null) {
                qh.updateLeafResults(numResults);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeFromCollection(Collection coll, ReplyHandler handler) {
        LinkedList<QueryHandler> toRemove = new LinkedList<QueryHandler>();
        Collection collection = coll;
        synchronized (collection) {
            Iterator iter = coll.iterator();
            while (iter.hasNext()) {
                QueryHandler qh = (QueryHandler)iter.next();
                ReplyHandler rh = qh.getReplyHandler();
                if (handler != rh) continue;
                toRemove.add(qh);
            }
            coll.removeAll(toRemove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeFromMap(Map map, ReplyHandler handler) {
        LinkedList<QueryHandler> toRemove = new LinkedList<QueryHandler>();
        Map map2 = map;
        synchronized (map2) {
            QueryHandler qh;
            Iterator iter = map.entrySet().iterator();
            while (iter.hasNext()) {
                qh = (QueryHandler)iter.next().getValue();
                if (qh.getReplyHandler() != handler) continue;
                toRemove.add(qh);
            }
            iter = toRemove.iterator();
            while (iter.hasNext()) {
                qh = (QueryHandler)((Object)iter.next());
                map.remove(new GUID(qh.getGUID()));
            }
        }
    }

    public void run() {
        try {
            while (true) {
                Thread.sleep(400L);
                this.processQueries();
            }
        }
        catch (Throwable t) {
            ErrorService.error(t);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processQueries() {
        QueryHandler qh;
        Iterator<Object> iter;
        Map map;
        if (!_done) {
            return;
        }
        _done = false;
        List list = this.NEW_QUERIES;
        synchronized (list) {
            map = this.QUERIES;
            synchronized (map) {
                iter = this.NEW_QUERIES.iterator();
                while (iter.hasNext()) {
                    qh = (QueryHandler)iter.next();
                    this.QUERIES.put(new GUID(qh.getGUID()), qh);
                }
            }
            this.NEW_QUERIES.clear();
        }
        LinkedList<QueryHandler> expiredQueries = new LinkedList<QueryHandler>();
        map = this.QUERIES;
        synchronized (map) {
            iter = this.QUERIES.entrySet().iterator();
            while (iter.hasNext()) {
                QueryHandler handler = (QueryHandler)((Map.Entry)iter.next()).getValue();
                handler.sendQuery();
                if (!handler.hasEnoughResults()) continue;
                expiredQueries.add(handler);
            }
            iter = expiredQueries.iterator();
            while (iter.hasNext()) {
                qh = (QueryHandler)iter.next();
                this.QUERIES.remove(new GUID(qh.getGUID()));
            }
        }
        _done = true;
    }
}

