/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.routing;

import com.limegroup.gnutella.util.StringUtils;
import java.util.ArrayList;

public class HashFunction {
    private static final int A_INT = 1327217884;

    private static int hashFast(int x, byte bits) {
        long prod = (long)x * 1327217884L;
        long ret = prod << 32;
        return (int)(ret >>>= 32 + (32 - bits));
    }

    public static int hash(String x, byte bits) {
        return HashFunction.hash(x, 0, x.length(), bits);
    }

    public static int hash(String x, int start, int end, byte bits) {
        int xor = 0;
        int j = 0;
        for (int i = start; i < end; ++i) {
            int b = Character.toLowerCase(x.charAt(i)) & 0xFF;
            xor ^= (b <<= j * 8);
            j = (j + 1) % 4;
        }
        return HashFunction.hashFast(xor, bits);
    }

    public static String[] keywords(String query) {
        return StringUtils.split(query.toLowerCase(), " -._+/*()\\");
    }

    public static int keywordStart(String query, int i) {
        String DELIMETERS = " -._+/*()\\";
        while (i < query.length()) {
            char c = query.charAt(i);
            if (" -._+/*()\\".indexOf(c) < 0) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int keywordEnd(String query, int i) {
        String DELIMETERS = " -._+/*()\\";
        while (i < query.length()) {
            char c = query.charAt(i);
            if (" -._+/*()\\".indexOf(c) >= 0) {
                return i;
            }
            ++i;
        }
        return query.length();
    }

    public static String[] getPrefixes(String[] words) {
        ArrayList<String> l = new ArrayList<String>();
        for (int i = 0; i < words.length; ++i) {
            l.add(words[i]);
            int len = words[i].length();
            if (len <= 4) continue;
            l.add(words[i].substring(0, len - 1));
            l.add(words[i].substring(0, len - 2));
        }
        String[] retArray = new String[l.size()];
        for (int i = 0; i < l.size(); ++i) {
            retArray[i] = (String)l.get(i);
        }
        return retArray;
    }
}

