/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.mp3;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.mp3.MP3Info;
import com.limegroup.gnutella.util.NameValue;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class ID3Reader {
    private static final String schemaURI = "http://www.limewire.com/schemas/audio.xsd";
    private static final String KEY_PREFIX = "audios__audio__";
    private static final String TRACK_KEY = "audios__audio__track__";
    private static final String ARTIST_KEY = "audios__audio__artist__";
    private static final String ALBUM_KEY = "audios__audio__album__";
    private static final String TITLE_KEY = "audios__audio__title__";
    private static final String GENRE_KEY = "audios__audio__genre__";
    private static final String YEAR_KEY = "audios__audio__year__";
    private static final String COMMENTS_KEY = "audios__audio__comments__";
    private static final String BITRATE_KEY = "audios__audio__bitrate__";
    private static final String SECONDS_KEY = "audios__audio__seconds__";

    private ID3Reader() {
    }

    public static boolean isCorrupted(LimeXMLDocument doc) {
        if (!schemaURI.equals(doc.getSchemaURI())) {
            return false;
        }
        Set existing = doc.getNameValueSet();
        Iterator i = existing.iterator();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!name.equals(ALBUM_KEY) && !name.equals(ARTIST_KEY) || value.length() != 30 || value.charAt(29) == ' ' || value.charAt(28) != ' ') continue;
            return true;
        }
        return false;
    }

    public static LimeXMLDocument fixCorruption(LimeXMLDocument oldDoc) {
        Set existing = oldDoc.getNameValueSet();
        ArrayList<NameValue> info = new ArrayList<NameValue>(existing.size());
        Iterator i = existing.iterator();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            if ((name.equals(ALBUM_KEY) || name.equals(ARTIST_KEY)) && value.length() == 30 && value.charAt(29) != ' ' && value.charAt(28) == ' ') {
                value = value.substring(0, 29).trim();
            }
            info.add(new NameValue(name, value));
        }
        return new LimeXMLDocument(info, oldDoc.getSchemaURI());
    }

    public static String readDocument(File file, boolean solo) throws IOException {
        String genre;
        Object[] info = ID3Reader.parseFile(file);
        String title = (String)info[0];
        String artist = (String)info[1];
        String album = (String)info[2];
        String year = (String)info[3];
        String comment = (String)info[5];
        short track = (Short)info[4];
        short gen = (Short)info[6];
        int bitrate = (Integer)info[7];
        int seconds = (Integer)info[8];
        StringBuffer strB = new StringBuffer();
        if (solo) {
            ID3Reader.appendStrings("<audios noNamespaceSchemaLocation=\"", schemaURI, strB);
            strB.append("><audio ");
            String filename = file.getCanonicalPath();
            ID3Reader.appendStrings(" identifier=\"", filename, strB);
        }
        if (!title.equals("")) {
            ID3Reader.appendStrings(" title=\"", title, strB);
        }
        if (!artist.equals("")) {
            ID3Reader.appendStrings(" artist=\"", artist, strB);
        }
        if (!album.equals("")) {
            ID3Reader.appendStrings(" album=\"", album, strB);
        }
        if (track > 0) {
            ID3Reader.appendStrings(" track=\"", "" + track, strB);
        }
        if (!(genre = ID3Reader.getGenreString(gen)).equals("")) {
            ID3Reader.appendStrings(" genre=\"", genre, strB);
        }
        if (!year.equals("")) {
            ID3Reader.appendStrings(" year=\"", year, strB);
        }
        if (!comment.equals("")) {
            ID3Reader.appendStrings(" comments=\"", comment, strB);
        }
        if (bitrate > 0) {
            ID3Reader.appendStrings(" bitrate=\"", "" + bitrate, strB);
        }
        if (seconds > 0) {
            ID3Reader.appendStrings(" seconds=\"", "" + seconds, strB);
        }
        if (solo) {
            strB.append("/>");
            strB.append("</audios>");
        }
        return strB.toString();
    }

    public static LimeXMLDocument readDocument(File file) throws IOException {
        Object[] info = ID3Reader.parseFile(file);
        short track = (Short)info[4];
        short gen = (Short)info[6];
        int bitrate = (Integer)info[7];
        int seconds = (Integer)info[8];
        String genre = ID3Reader.getGenreString(gen);
        ArrayList<NameValue> nameValList = new ArrayList<NameValue>();
        if (!((String)info[0]).equals("")) {
            nameValList.add(new NameValue(TITLE_KEY, info[0]));
        }
        if (!((String)info[1]).equals("")) {
            nameValList.add(new NameValue(ARTIST_KEY, info[1]));
        }
        if (!((String)info[2]).equals("")) {
            nameValList.add(new NameValue(ALBUM_KEY, info[2]));
        }
        if (!((String)info[3]).equals("")) {
            nameValList.add(new NameValue(YEAR_KEY, info[3]));
        }
        if (!((String)info[5]).equals("")) {
            nameValList.add(new NameValue(COMMENTS_KEY, info[5]));
        }
        if (track > 0) {
            nameValList.add(new NameValue(TRACK_KEY, "" + track));
        }
        if (!genre.equals("")) {
            nameValList.add(new NameValue(GENRE_KEY, genre));
        }
        if (bitrate > 0) {
            nameValList.add(new NameValue(BITRATE_KEY, "" + bitrate));
        }
        if (seconds > 0) {
            nameValList.add(new NameValue(SECONDS_KEY, "" + seconds));
        }
        return new LimeXMLDocument(nameValList, schemaURI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object[] parseFile(File file) throws IOException {
        Object[] retObjs = new Object[9];
        retObjs[0] = "";
        retObjs[1] = "";
        retObjs[2] = "";
        retObjs[3] = "";
        retObjs[5] = "";
        retObjs[4] = new Short(-1);
        retObjs[6] = new Short(-1);
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "r");
            long length = randomAccessFile.length();
            if (length >= 128L) {
                randomAccessFile.seek(length - 128L);
                byte[] buffer = new byte[30];
                randomAccessFile.readFully(buffer, 0, 3);
                String tag = new String(buffer, 0, 3);
                if (tag.equals("TAG")) {
                    int commentLength;
                    randomAccessFile.readFully(buffer, 0, 30);
                    retObjs[0] = new String(buffer, 0, ID3Reader.getTrimmedLength(buffer, 30));
                    randomAccessFile.readFully(buffer, 0, 30);
                    retObjs[1] = new String(buffer, 0, ID3Reader.getTrimmedLength(buffer, 30));
                    randomAccessFile.readFully(buffer, 0, 30);
                    retObjs[2] = new String(buffer, 0, ID3Reader.getTrimmedLength(buffer, 30));
                    randomAccessFile.readFully(buffer, 0, 4);
                    retObjs[3] = new String(buffer, 0, ID3Reader.getTrimmedLength(buffer, 4));
                    randomAccessFile.readFully(buffer, 0, 30);
                    if (buffer[28] == 0) {
                        retObjs[4] = new Short((short)ByteOrder.ubyte2int(buffer[29]));
                        commentLength = 28;
                    } else {
                        retObjs[4] = new Short(0);
                        commentLength = 3;
                    }
                    retObjs[5] = new String(buffer, 0, ID3Reader.getTrimmedLength(buffer, commentLength));
                    randomAccessFile.readFully(buffer, 0, 1);
                    retObjs[6] = new Short((short)ByteOrder.ubyte2int(buffer[0]));
                }
            }
            MP3Info mp3Info = new MP3Info(file.getCanonicalPath());
            retObjs[7] = new Integer(mp3Info.getBitRate());
            retObjs[8] = new Integer((int)mp3Info.getLengthInSeconds());
        }
        finally {
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
        }
        return retObjs;
    }

    private static void appendStrings(String key, String value, StringBuffer appendTo) {
        appendTo.append(key);
        appendTo.append(value);
        appendTo.append("\"");
    }

    private static int getTrimmedLength(byte[] bytes, int includedLength) {
        int i;
        for (i = includedLength - 1; i >= 0 && (bytes[i] == 0 || bytes[i] == 32); --i) {
        }
        for (int j = 0; j <= i; ++j) {
            if (bytes[j] != 0) continue;
            bytes[j] = 32;
        }
        return i + 1;
    }

    public static String getGenreString(short genre) {
        switch (genre) {
            case 0: {
                return "Blues";
            }
            case 1: {
                return "Classic Rock";
            }
            case 2: {
                return "Country";
            }
            case 3: {
                return "Dance";
            }
            case 4: {
                return "Disco";
            }
            case 5: {
                return "Funk";
            }
            case 6: {
                return "Grunge";
            }
            case 7: {
                return "Hip-Hop";
            }
            case 8: {
                return "Jazz";
            }
            case 9: {
                return "Metal";
            }
            case 10: {
                return "New Age";
            }
            case 11: {
                return "Oldies";
            }
            case 12: {
                return "Other";
            }
            case 13: {
                return "Pop";
            }
            case 14: {
                return "R &amp; B";
            }
            case 15: {
                return "Rap";
            }
            case 16: {
                return "Reggae";
            }
            case 17: {
                return "Rock";
            }
            case 18: {
                return "Techno";
            }
            case 19: {
                return "Industrial";
            }
            case 20: {
                return "Alternative";
            }
            case 21: {
                return "Ska";
            }
            case 22: {
                return "Death Metal";
            }
            case 23: {
                return "Pranks";
            }
            case 24: {
                return "Soundtrack";
            }
            case 25: {
                return "Euro-Techno";
            }
            case 26: {
                return "Ambient";
            }
            case 27: {
                return "Trip-Hop";
            }
            case 28: {
                return "Vocal";
            }
            case 29: {
                return "Jazz+Funk";
            }
            case 30: {
                return "Fusion";
            }
            case 31: {
                return "Trance";
            }
            case 32: {
                return "Classical";
            }
            case 33: {
                return "Instrumental";
            }
            case 34: {
                return "Acid";
            }
            case 35: {
                return "House";
            }
            case 36: {
                return "Game";
            }
            case 37: {
                return "Sound Clip";
            }
            case 38: {
                return "Gospel";
            }
            case 39: {
                return "Noise";
            }
            case 40: {
                return "AlternRock";
            }
            case 41: {
                return "Bass";
            }
            case 42: {
                return "Soul";
            }
            case 43: {
                return "Punk";
            }
            case 44: {
                return "Space";
            }
            case 45: {
                return "Meditative";
            }
            case 46: {
                return "Instrumental Pop";
            }
            case 47: {
                return "Instrumental Rock";
            }
            case 48: {
                return "Ethnic";
            }
            case 49: {
                return "Gothic";
            }
            case 50: {
                return "Darkwave";
            }
            case 51: {
                return "Techno-Industrial";
            }
            case 52: {
                return "Electronic";
            }
            case 53: {
                return "Pop-Folk";
            }
            case 54: {
                return "Eurodance";
            }
            case 55: {
                return "Dream";
            }
            case 56: {
                return "Southern Rock";
            }
            case 57: {
                return "Comedy";
            }
            case 58: {
                return "Cult";
            }
            case 59: {
                return "Gangsta";
            }
            case 60: {
                return "Top 40";
            }
            case 61: {
                return "Christian Rap";
            }
            case 62: {
                return "Pop/Funk";
            }
            case 63: {
                return "Jungle";
            }
            case 64: {
                return "Native American";
            }
            case 65: {
                return "Cabaret";
            }
            case 66: {
                return "New Wave";
            }
            case 67: {
                return "Psychadelic";
            }
            case 68: {
                return "Rave";
            }
            case 69: {
                return "Showtunes";
            }
            case 70: {
                return "Trailer";
            }
            case 71: {
                return "Lo-Fi";
            }
            case 72: {
                return "Tribal";
            }
            case 73: {
                return "Acid Punk";
            }
            case 74: {
                return "Acid Jazz";
            }
            case 75: {
                return "Polka";
            }
            case 76: {
                return "Retro";
            }
            case 77: {
                return "Musical";
            }
            case 78: {
                return "Rock &amp; Roll";
            }
            case 79: {
                return "Hard Rock";
            }
            case 80: {
                return "Folk";
            }
            case 81: {
                return "Folk-Rock";
            }
            case 82: {
                return "National Folk";
            }
            case 83: {
                return "Swing";
            }
            case 84: {
                return "Fast Fusion";
            }
            case 85: {
                return "Bebob";
            }
            case 86: {
                return "Latin";
            }
            case 87: {
                return "Revival";
            }
            case 88: {
                return "Celtic";
            }
            case 89: {
                return "Bluegrass";
            }
            case 90: {
                return "Avantgarde";
            }
            case 91: {
                return "Gothic Rock";
            }
            case 92: {
                return "Progressive Rock";
            }
            case 93: {
                return "Psychedelic Rock";
            }
            case 94: {
                return "Symphonic Rock";
            }
            case 95: {
                return "Slow Rock";
            }
            case 96: {
                return "Big Band";
            }
            case 97: {
                return "Chorus";
            }
            case 98: {
                return "Easy Listening";
            }
            case 99: {
                return "Acoustic";
            }
            case 100: {
                return "Humour";
            }
            case 101: {
                return "Speech";
            }
            case 102: {
                return "Chanson";
            }
            case 103: {
                return "Opera";
            }
            case 104: {
                return "Chamber Music";
            }
            case 105: {
                return "Sonata";
            }
            case 106: {
                return "Symphony";
            }
            case 107: {
                return "Booty Bass";
            }
            case 108: {
                return "Primus";
            }
            case 109: {
                return "Porn Groove";
            }
            case 110: {
                return "Satire";
            }
            case 111: {
                return "Slow Jam";
            }
            case 112: {
                return "Club";
            }
            case 113: {
                return "Tango";
            }
            case 114: {
                return "Samba";
            }
            case 115: {
                return "Folklore";
            }
            case 116: {
                return "Ballad";
            }
            case 117: {
                return "Power Ballad";
            }
            case 118: {
                return "Rhythmic Soul";
            }
            case 119: {
                return "Freestyle";
            }
            case 120: {
                return "Duet";
            }
            case 121: {
                return "Punk Rock";
            }
            case 122: {
                return "Drum Solo";
            }
            case 123: {
                return "A capella";
            }
            case 124: {
                return "Euro-House";
            }
            case 125: {
                return "Dance Hall";
            }
        }
        return "";
    }
}

