/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.PushProxyInterface;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.messages.BadGGEPBlockException;
import com.limegroup.gnutella.messages.BadGGEPPropertyException;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.GGEP;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.statistics.DroppedSentMessageStatHandler;
import com.limegroup.gnutella.statistics.ReceivedErrorStat;
import com.limegroup.gnutella.statistics.SentMessageStatHandler;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.util.NetworkUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class QueryReply
extends Message
implements Serializable {
    public static final int XML_MAX_SIZE = 32768;
    public static final int COMMON_PAYLOAD_LEN = 4;
    private byte[] _payload;
    private volatile boolean _parsed = false;
    private volatile Response[] _responses = null;
    private volatile String _vendor = null;
    private volatile int _pushFlag = -1;
    private volatile int _busyFlag = -1;
    private volatile int _uploadedFlag = -1;
    private volatile int _measuredSpeedFlag = -1;
    private volatile int _supportsChat = -1;
    private volatile int _supportsBrowseHost = 0;
    private volatile int _replyToMulticast = 0;
    private static final int TRUE = 1;
    private static final int FALSE = 0;
    private static final int UNDEFINED = -1;
    private static final byte PUSH_MASK = 1;
    private static final byte BUSY_MASK = 4;
    private static final byte UPLOADED_MASK = 8;
    private static final byte SPEED_MASK = 16;
    private static final byte GGEP_MASK = 32;
    private static final byte CHAT_MASK = 1;
    private byte[] _xmlBytes = new byte[0];
    private byte[] _address = new byte[4];
    private Set _proxies;
    private static final GGEPUtil _ggepUtil = new GGEPUtil();
    public static final boolean debugOn = false;

    public QueryReply(byte[] guid, byte ttl, int port, byte[] ip, long speed, Response[] responses, byte[] clientGUID, boolean isMulticastReply) {
        this(guid, ttl, port, ip, speed, responses, clientGUID, DataUtils.EMPTY_BYTE_ARRAY, false, false, false, false, false, false, true, isMulticastReply, DataUtils.EMPTY_SET);
    }

    public QueryReply(byte[] guid, byte ttl, int port, byte[] ip, long speed, Response[] responses, byte[] clientGUID, boolean needsPush, boolean isBusy, boolean finishedUpload, boolean measuredSpeed, boolean supportsChat, boolean isMulticastReply) {
        this(guid, ttl, port, ip, speed, responses, clientGUID, DataUtils.EMPTY_BYTE_ARRAY, true, needsPush, isBusy, finishedUpload, measuredSpeed, supportsChat, true, isMulticastReply, DataUtils.EMPTY_SET);
    }

    public QueryReply(byte[] guid, byte ttl, int port, byte[] ip, long speed, Response[] responses, byte[] clientGUID, byte[] xmlBytes, boolean needsPush, boolean isBusy, boolean finishedUpload, boolean measuredSpeed, boolean supportsChat, boolean isMulticastReply) throws IllegalArgumentException {
        this(guid, ttl, port, ip, speed, responses, clientGUID, xmlBytes, needsPush, isBusy, finishedUpload, measuredSpeed, supportsChat, isMulticastReply, DataUtils.EMPTY_SET);
    }

    public QueryReply(byte[] guid, byte ttl, int port, byte[] ip, long speed, Response[] responses, byte[] clientGUID, byte[] xmlBytes, boolean needsPush, boolean isBusy, boolean finishedUpload, boolean measuredSpeed, boolean supportsChat, boolean isMulticastReply, Set proxies) throws IllegalArgumentException {
        this(guid, ttl, port, ip, speed, responses, clientGUID, xmlBytes, true, needsPush, isBusy, finishedUpload, measuredSpeed, supportsChat, true, isMulticastReply, proxies);
        if (xmlBytes.length > 32768) {
            throw new IllegalArgumentException("XML bytes too big: " + xmlBytes.length);
        }
        this._xmlBytes = xmlBytes;
    }

    public QueryReply(byte[] guid, byte ttl, byte hops, byte[] payload) throws BadPacketException {
        super(guid, (byte)-127, ttl, hops, payload.length);
        this._payload = payload;
        if (!NetworkUtils.isValidPort(this.getPort())) {
            if (RECORD_STATS) {
                ReceivedErrorStat.REPLY_INVALID_PORT.incrementStat();
            }
            throw new BadPacketException("invalid port");
        }
        if ((this.getSpeed() & 0xFFFFFFFF00000000L) != 0L) {
            if (RECORD_STATS) {
                ReceivedErrorStat.REPLY_INVALID_SPEED.incrementStat();
            }
            throw new BadPacketException("invalid speed: " + this.getSpeed());
        }
        this.setAddress();
    }

    public QueryReply(byte[] guid, QueryReply reply) {
        super(guid, (byte)-127, reply.getTTL(), reply.getHops(), reply.getLength());
        this._payload = reply._payload;
        this.setAddress();
    }

    private QueryReply(byte[] guid, byte ttl, int port, byte[] ip, long speed, Response[] responses, byte[] clientGUID, byte[] xmlBytes, boolean includeQHD, boolean needsPush, boolean isBusy, boolean finishedUpload, boolean measuredSpeed, boolean supportsChat, boolean supportsBH, boolean isMulticastReply, Set proxies) {
        super(guid, (byte)-127, ttl, (byte)0, 0, 16);
        if (xmlBytes.length > 32768) {
            return;
        }
        int n = responses.length;
        if (!NetworkUtils.isValidPort(port)) {
            throw new IllegalArgumentException("invalid port: " + port);
        }
        if (ip.length != 4) {
            throw new IllegalArgumentException("invalid ip length: " + ip.length);
        }
        if ((speed & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalArgumentException("invalid speed: " + speed);
        }
        if (n >= 256) {
            throw new IllegalArgumentException("invalid num responses: " + n);
        }
        this._proxies = proxies;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            baos.write(n);
            ByteOrder.short2leb((short)port, baos);
            baos.write(ip, 0, ip.length);
            ByteOrder.int2leb((int)speed, baos);
            for (int left = n; left > 0; --left) {
                Response r = responses[n - left];
                r.writeToStream(baos);
            }
            if (includeQHD) {
                baos.write(65);
                baos.write(67);
                baos.write(81);
                baos.write(76);
                baos.write(4);
                int ggepLen = _ggepUtil.getQRGGEP(false, false, DataUtils.EMPTY_SET).length;
                byte flags = (byte)((needsPush && !isMulticastReply ? 1 : 0) | 4 | 8 | 0x10 | 0x20);
                byte controls = (byte)(1 | (isBusy && !isMulticastReply ? 4 : 0) | (finishedUpload ? 8 : 0) | (measuredSpeed || isMulticastReply ? 16 : 0) | (supportsBH || isMulticastReply ? 32 : (ggepLen > 0 ? 32 : 0)));
                baos.write(flags);
                baos.write(controls);
                int xmlSize = xmlBytes.length + 1;
                if (xmlSize > 32768) {
                    xmlSize = 32768;
                }
                ByteOrder.short2leb((short)xmlSize, baos);
                int chatSupport = supportsChat ? 1 : 0;
                baos.write(chatSupport);
                byte[] ggepBytes = _ggepUtil.getQRGGEP(supportsBH, isMulticastReply, this._proxies);
                baos.write(ggepBytes, 0, ggepBytes.length);
                baos.write(xmlBytes, 0, xmlBytes.length);
                baos.write(0);
            }
            baos.write(clientGUID, 0, 16);
            this._payload = baos.toByteArray();
            this.updateLength(this._payload.length);
        }
        catch (IOException reallyBad) {
            ErrorService.error(reallyBad);
        }
        this.setAddress();
    }

    private void setAddress() {
        this._address[0] = this._payload[3];
        this._address[1] = this._payload[4];
        this._address[2] = this._payload[5];
        this._address[3] = this._payload[6];
    }

    public void setGUID(GUID guid) {
        super.setGUID(guid);
    }

    public void writePayload(OutputStream out) throws IOException {
        out.write(this._payload);
        if (RECORD_STATS) {
            SentMessageStatHandler.TCP_QUERY_REPLIES.addMessage(this);
        }
    }

    public byte[] getXMLBytes() {
        this.parseResults();
        return this._xmlBytes;
    }

    public short getResultCount() {
        return (short)ByteOrder.ubyte2int(this._payload[0]);
    }

    public int getPort() {
        return ByteOrder.ubytes2int(ByteOrder.leb2short(this._payload, 1));
    }

    public String getIP() {
        return NetworkUtils.ip2string(this._address);
    }

    public byte[] getIPBytes() {
        return this._address;
    }

    public long getSpeed() {
        return ByteOrder.ubytes2long(ByteOrder.leb2int(this._payload, 7));
    }

    public Iterator getResults() throws BadPacketException {
        this.parseResults();
        if (this._responses == null) {
            throw new BadPacketException();
        }
        List<Response> list = Arrays.asList(this._responses);
        return list.iterator();
    }

    public List getResultsAsList() throws BadPacketException {
        this.parseResults();
        if (this._responses == null) {
            throw new BadPacketException("results are null");
        }
        List<Response> list = Arrays.asList(this._responses);
        return list;
    }

    public String getVendor() throws BadPacketException {
        this.parseResults();
        if (this._vendor == null) {
            throw new BadPacketException();
        }
        return this._vendor;
    }

    public boolean getNeedsPush() throws BadPacketException {
        this.parseResults();
        switch (this._pushFlag) {
            case -1: {
                throw new BadPacketException();
            }
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        Assert.that(false, "Bad value for push flag: " + this._pushFlag);
        return false;
    }

    public boolean getIsBusy() throws BadPacketException {
        this.parseResults();
        switch (this._busyFlag) {
            case -1: {
                throw new BadPacketException();
            }
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        Assert.that(false, "Bad value for busy flag: " + this._pushFlag);
        return false;
    }

    public boolean getHadSuccessfulUpload() throws BadPacketException {
        this.parseResults();
        switch (this._uploadedFlag) {
            case -1: {
                throw new BadPacketException();
            }
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        Assert.that(false, "Bad value for uploaded flag: " + this._pushFlag);
        return false;
    }

    public boolean getIsMeasuredSpeed() throws BadPacketException {
        this.parseResults();
        switch (this._measuredSpeedFlag) {
            case -1: {
                throw new BadPacketException();
            }
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        Assert.that(false, "Bad value for measured speed flag: " + this._pushFlag);
        return false;
    }

    public boolean getSupportsChat() throws BadPacketException {
        this.parseResults();
        switch (this._supportsChat) {
            case -1: {
                throw new BadPacketException();
            }
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        Assert.that(false, "Bad value for supportsChat: " + this._supportsChat);
        return false;
    }

    public boolean getSupportsBrowseHost() throws BadPacketException {
        this.parseResults();
        switch (this._supportsBrowseHost) {
            case -1: {
                throw new BadPacketException();
            }
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        Assert.that(false, "Bad value for supportsBrowseHost: " + this._supportsBrowseHost);
        return false;
    }

    public boolean isReplyToMulticastQuery() throws BadPacketException {
        this.parseResults();
        switch (this._replyToMulticast) {
            case -1: {
                throw new BadPacketException();
            }
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        Assert.that(false, "Bad value for replyToMulticast: " + this._replyToMulticast);
        return false;
    }

    public Set getPushProxies() {
        this.parseResults();
        return this._proxies;
    }

    private void parseResults() {
        if (this._parsed) {
            return;
        }
        this.parseResults2();
        this._parsed = true;
    }

    private void parseResults2() {
        int left;
        int i = 11;
        Response[] responses = new Response[left];
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(this._payload, i, this._payload.length - i);
            for (left = this.getResultCount(); left > 0; --left) {
                Response r;
                responses[responses.length - left] = r = Response.createFromStream(bais);
                i += r.getLength();
            }
            this._responses = responses;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return;
        }
        catch (IOException e) {
            return;
        }
        try {
            int privateLength;
            if (i >= this._payload.length - 16) {
                throw new BadPacketException("No QHD");
            }
            String vendorT = null;
            int pushFlagT = -1;
            int busyFlagT = -1;
            int uploadedFlagT = -1;
            int measuredSpeedFlagT = -1;
            int supportsChatT = -1;
            int supportsBrowseHostT = -1;
            int replyToMulticastT = -1;
            Set proxies = null;
            try {
                vendorT = new String(this._payload, i, 4, "ISO-8859-1");
                Assert.that(vendorT.length() == 4, "Vendor length wrong.  Wrong character encoding?");
            }
            catch (UnsupportedEncodingException e) {
                Assert.that(false, "No support for ISO-8859-1 encoding");
            }
            int length = ByteOrder.ubyte2int(this._payload[i += 4]);
            if (length <= 0) {
                throw new BadPacketException("Common payload length zero.");
            }
            if (++i + length > this._payload.length - 16) {
                throw new BadPacketException("Common payload length imprecise!");
            }
            if (length > 1) {
                byte control = this._payload[i];
                byte flags = this._payload[i + 1];
                if ((flags & 1) != 0) {
                    int n = pushFlagT = (control & 1) == 1 ? 1 : 0;
                }
                if ((control & 4) != 0) {
                    int n = busyFlagT = (flags & 4) != 0 ? 1 : 0;
                }
                if ((control & 8) != 0) {
                    int n = uploadedFlagT = (flags & 8) != 0 ? 1 : 0;
                }
                if ((control & 0x10) != 0) {
                    int n = measuredSpeedFlagT = (flags & 0x10) != 0 ? 1 : 0;
                }
                if ((control & 0x20) != 0 && (flags & 0x20) != 0) {
                    int magicIndex;
                    for (magicIndex = i + 2; this._payload[magicIndex] != -61 && magicIndex < this._payload.length; ++magicIndex) {
                    }
                    GGEP[] ggepBlocks = null;
                    try {
                        ggepBlocks = GGEP.read(this._payload, magicIndex);
                        if (_ggepUtil.allowsBrowseHost(ggepBlocks)) {
                            supportsBrowseHostT = 1;
                        }
                        replyToMulticastT = _ggepUtil.replyToMulticastQuery(ggepBlocks) ? 1 : 0;
                        proxies = _ggepUtil.getPushProxies(ggepBlocks);
                    }
                    catch (BadGGEPBlockException ignored) {
                        // empty catch block
                    }
                }
                i += 2;
            }
            if (length > 2) {
                int b;
                int temp;
                int a;
                int xmlSize;
                if ((xmlSize = (a = (temp = ByteOrder.ubyte2int(this._payload[i++]))) | (b = (temp = ByteOrder.ubyte2int(this._payload[i++])) << 8)) > 1) {
                    int xmlInPayloadIndex = this._payload.length - 16 - xmlSize;
                    this._xmlBytes = new byte[xmlSize - 1];
                    System.arraycopy(this._payload, xmlInPayloadIndex, this._xmlBytes, 0, xmlSize - 1);
                } else {
                    this._xmlBytes = DataUtils.EMPTY_BYTE_ARRAY;
                }
            }
            if ((privateLength = this._payload.length - i) > 0 && (vendorT.equals("LIME") || vendorT.equals("RAZA"))) {
                byte privateFlags = this._payload[i];
                int n = supportsChatT = (privateFlags & 1) != 0 ? 1 : 0;
            }
            if (i > this._payload.length - 16) {
                throw new BadPacketException("Common payload length too large.");
            }
            Assert.that(vendorT != null);
            this._vendor = vendorT.toUpperCase(Locale.US);
            this._pushFlag = pushFlagT;
            this._busyFlag = busyFlagT;
            this._uploadedFlag = uploadedFlagT;
            this._measuredSpeedFlag = measuredSpeedFlagT;
            this._supportsChat = supportsChatT;
            this._supportsBrowseHost = supportsBrowseHostT;
            this._replyToMulticast = replyToMulticastT;
            this._proxies = proxies == null ? DataUtils.EMPTY_SET : proxies;
            QueryReply.debug("QR.parseResults2(): returning w/o exception.");
        }
        catch (BadPacketException e) {
            QueryReply.debug("QR.parseResults2(): bpe = " + e);
            return;
        }
        catch (IndexOutOfBoundsException e) {
            QueryReply.debug("QR.parseResults2(): index exception = " + e);
            return;
        }
    }

    public byte[] getClientGUID() {
        byte[] result = new byte[16];
        int length = super.getLength();
        System.arraycopy(this._payload, length - 16, result, 0, 16);
        return result;
    }

    public Message stripExtendedPayload() {
        return this;
    }

    public String toString() {
        return "QueryReply::\r\n" + this.getResultCount() + " hits\r\n" + super.toString() + "\r\n" + "ip: " + this.getIP() + "\r\n";
    }

    public RemoteFileDesc[] toRemoteFileDescArray() throws BadPacketException {
        List responses = null;
        try {
            responses = this.getResultsAsList();
        }
        catch (BadPacketException bpe) {
            QueryReply.debug(bpe);
            throw bpe;
        }
        RemoteFileDesc[] retArray = new RemoteFileDesc[responses.size()];
        Iterator respIter = responses.iterator();
        int index = 0;
        String ip = this.getIP();
        int port = this.getPort();
        int qual = this.calculateQualityOfService(!RouterService.acceptedIncomingConnection());
        long speed = this.getSpeed();
        byte[] clientGUID = this.getClientGUID();
        boolean supportsChat = false;
        boolean supportsBrowseHost = false;
        boolean isReplyToMulticast = false;
        try {
            isReplyToMulticast = this.isReplyToMulticastQuery();
            supportsChat = this.getSupportsChat();
            supportsBrowseHost = this.getSupportsBrowseHost();
        }
        catch (BadPacketException ignored) {
            // empty catch block
        }
        while (respIter.hasNext()) {
            Response currResp = (Response)respIter.next();
            retArray[index++] = new RemoteFileDesc(ip, port, currResp.getIndex(), currResp.getName(), (int)currResp.getSize(), clientGUID, (int)speed, supportsChat, qual, supportsBrowseHost, currResp.getDocument(), currResp.getUrns(), isReplyToMulticast, this.getNeedsPush(), this.getVendor(), System.currentTimeMillis(), this._proxies);
        }
        return retArray;
    }

    public int calculateQualityOfService(boolean iFirewalled) {
        int heFirewalled;
        boolean isMCastReply;
        int busy;
        boolean YES = true;
        boolean MAYBE = false;
        int NO = -1;
        try {
            busy = this.getIsBusy() ? 1 : -1;
        }
        catch (BadPacketException e) {
            busy = 0;
        }
        try {
            isMCastReply = this.isReplyToMulticastQuery();
        }
        catch (BadPacketException e) {
            isMCastReply = false;
        }
        if (isMCastReply) {
            iFirewalled = false;
            heFirewalled = -1;
        } else if (NetworkUtils.isPrivateAddress(this.getIPBytes())) {
            heFirewalled = 1;
        } else {
            try {
                heFirewalled = this.getNeedsPush() ? 1 : -1;
            }
            catch (BadPacketException e) {
                heFirewalled = 0;
            }
        }
        boolean hasPushProxies = false;
        if (this.getPushProxies() != null && this.getPushProxies().size() > 1) {
            hasPushProxies = true;
        }
        if (Arrays.equals(this._address, RouterService.getAddress())) {
            return 3;
        }
        if (isMCastReply) {
            return 4;
        }
        if (iFirewalled && heFirewalled == 1) {
            return -1;
        }
        if (busy == 0 || heFirewalled == 0) {
            return 0;
        }
        if (busy == 1) {
            Assert.that(heFirewalled == -1 || !iFirewalled);
            if (heFirewalled == 1) {
                return 0;
            }
            return 1;
        }
        if (busy == -1) {
            Assert.that(heFirewalled == -1 || !iFirewalled);
            if (heFirewalled == 1 && !hasPushProxies) {
                return 2;
            }
            return 3;
        }
        Assert.that(false, "Unexpected case!");
        return -1;
    }

    public static boolean isFirewalledQuality(int quality) {
        return quality == 0 || quality == 2;
    }

    public void recordDrop() {
        if (RECORD_STATS) {
            DroppedSentMessageStatHandler.TCP_QUERY_REPLIES.addMessage(this);
        }
    }

    public static void debug(String out) {
    }

    public static void debug(Exception e) {
    }

    public static class IPPortCombo {
        private int _port;
        private InetAddress _addr;
        public static final String DELIM = ":";

        public static IPPortCombo getCombo(byte[] fromNetwork) throws IllegalArgumentException {
            if (fromNetwork.length != 6) {
                throw new IllegalArgumentException("Weird Input");
            }
            String host = NetworkUtils.ip2string(fromNetwork, 0);
            int port = ByteOrder.ubytes2int(ByteOrder.leb2short(fromNetwork, 4));
            try {
                return new IPPortCombo(host, port);
            }
            catch (UnknownHostException uhe) {
                throw new IllegalArgumentException("Unknown Host");
            }
        }

        public IPPortCombo(String hostAddress, int port) throws UnknownHostException, IllegalArgumentException {
            if (hostAddress.equals("0.0.0.0")) {
                throw new IllegalArgumentException("Host is bad: 0.0.0.0");
            }
            this._addr = InetAddress.getByName(hostAddress);
            if (!NetworkUtils.isValidPort(port)) {
                throw new IllegalArgumentException("Bad Port");
            }
            this._port = port;
        }

        public int getPort() {
            return this._port;
        }

        public InetAddress getAddress() {
            return this._addr;
        }

        public byte[] toBytes() {
            byte[] retVal = new byte[6];
            for (int i = 0; i < 4; ++i) {
                retVal[i] = this._addr.getAddress()[i];
            }
            ByteOrder.short2leb((short)this._port, retVal, 4);
            return retVal;
        }

        public boolean equals(Object other) {
            if (other instanceof IPPortCombo) {
                IPPortCombo combo = (IPPortCombo)other;
                return this._addr.equals(combo._addr) && this._port == combo._port;
            }
            return false;
        }

        public int hashCode() {
            return this._addr.hashCode() * this._port;
        }
    }

    public static class PushProxyContainer
    implements PushProxyInterface {
        IPPortCombo _combo;

        public PushProxyContainer(String hostAddress, int port) throws UnknownHostException {
            this._combo = new IPPortCombo(hostAddress, port);
        }

        public PushProxyContainer(byte[] fromNetwork) throws IllegalArgumentException {
            this._combo = IPPortCombo.getCombo(fromNetwork);
        }

        public int getPushProxyPort() {
            return this._combo.getPort();
        }

        public InetAddress getPushProxyAddress() {
            return this._combo.getAddress();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof PushProxyContainer) {
                PushProxyContainer iface = (PushProxyContainer)other;
                return this._combo.equals(iface._combo);
            }
            return false;
        }

        public int hashCode() {
            return this._combo.hashCode() * 17;
        }
    }

    static class GGEPUtil {
        private final byte[] _standardGGEP;
        private final byte[] _bhGGEP;
        private final byte[] _mcGGEP;
        private final byte[] _comboGGEP;

        public GGEPUtil() {
            ByteArrayOutputStream oStream = new ByteArrayOutputStream();
            try {
                GGEP standard = new GGEP(false);
                standard.write(oStream);
            }
            catch (IOException writeError) {
                // empty catch block
            }
            this._standardGGEP = oStream.toByteArray();
            oStream.reset();
            try {
                GGEP bhost = new GGEP(false);
                bhost.put("BH");
                bhost.write(oStream);
            }
            catch (IOException writeError) {
                // empty catch block
            }
            this._bhGGEP = oStream.toByteArray();
            Assert.that(this._bhGGEP != null);
            oStream.reset();
            try {
                GGEP mcast = new GGEP(false);
                mcast.put("MCAST");
                mcast.write(oStream);
            }
            catch (IOException writeError) {
                // empty catch block
            }
            this._mcGGEP = oStream.toByteArray();
            Assert.that(this._mcGGEP != null);
            oStream.reset();
            try {
                GGEP combo = new GGEP(false);
                combo.put("MCAST");
                combo.put("BH");
                combo.write(oStream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this._comboGGEP = oStream.toByteArray();
            Assert.that(this._comboGGEP != null);
        }

        public byte[] getQRGGEP(boolean supportsBH, boolean isMulticastResponse, Set proxies) {
            byte[] retGGEPBlock = this._standardGGEP;
            if (proxies != null && proxies.size() > 0) {
                int MAX_PROXIES = 4;
                GGEP retGGEP = new GGEP();
                if (supportsBH) {
                    retGGEP.put("BH");
                }
                if (isMulticastResponse) {
                    retGGEP.put("MCAST");
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                int numWritten = 0;
                Iterator iter = proxies.iterator();
                while (iter.hasNext() && numWritten < 4) {
                    PushProxyInterface ppi = (PushProxyInterface)iter.next();
                    String host = ppi.getPushProxyAddress().getHostAddress();
                    int port = ppi.getPushProxyPort();
                    try {
                        IPPortCombo combo = new IPPortCombo(host, port);
                        baos.write(combo.toBytes());
                        ++numWritten;
                    }
                    catch (UnknownHostException bad) {
                    }
                    catch (IOException terrible) {
                        ErrorService.error(terrible);
                    }
                }
                try {
                    if (numWritten > 0) {
                        retGGEP.put("PUSH", baos.toByteArray());
                    }
                    baos.reset();
                    retGGEP.write(baos);
                    retGGEPBlock = baos.toByteArray();
                }
                catch (IOException terrible) {
                    ErrorService.error(terrible);
                }
            } else if (supportsBH && isMulticastResponse) {
                retGGEPBlock = this._comboGGEP;
            } else if (supportsBH) {
                retGGEPBlock = this._bhGGEP;
            } else if (isMulticastResponse) {
                retGGEPBlock = this._mcGGEP;
            }
            return retGGEPBlock;
        }

        public boolean allowsBrowseHost(GGEP[] ggeps) {
            boolean retBool = false;
            for (int i = 0; ggeps != null && i < ggeps.length && !retBool; ++i) {
                Set headers = ggeps[i].getHeaders();
                retBool = headers.contains("BH");
            }
            return retBool;
        }

        public boolean replyToMulticastQuery(GGEP[] ggeps) {
            boolean retBool = false;
            for (int i = 0; ggeps != null && i < ggeps.length && !retBool; ++i) {
                Set headers = ggeps[i].getHeaders();
                retBool = headers.contains("MCAST");
            }
            return retBool;
        }

        public Set getPushProxies(GGEP[] ggeps) {
            HashSet<PushProxyContainer> proxies = new HashSet<PushProxyContainer>();
            for (int i = 0; ggeps != null && i < ggeps.length; ++i) {
                Set headers = ggeps[i].getHeaders();
                if (!headers.contains("PUSH")) continue;
                byte[] proxyBytes = null;
                try {
                    proxyBytes = ggeps[i].getBytes("PUSH");
                }
                catch (BadGGEPPropertyException bad) {
                    ErrorService.error(bad);
                    continue;
                }
                ByteArrayInputStream bais = new ByteArrayInputStream(proxyBytes);
                while (bais.available() > 0) {
                    byte[] combo = new byte[6];
                    if (bais.read(combo, 0, combo.length) != combo.length) continue;
                    try {
                        proxies.add(new PushProxyContainer(combo));
                    }
                    catch (IllegalArgumentException malformedPair) {}
                }
            }
            return proxies;
        }
    }
}

