/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.http;

import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.statistics.BandwidthStat;
import com.limegroup.gnutella.util.CommonUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public final class HTTPUtils {
    private static final String CRLF = "\r\n";
    private static final String COLON_SPACE = ": ";
    private static final String COLON = ":";

    private HTTPUtils() {
    }

    public static void writeHeader(HTTPHeaderName name, HTTPHeaderValue value, OutputStream os) throws IOException {
        if (name == null) {
            throw new NullPointerException("null name in writing http header");
        }
        if (value == null) {
            throw new NullPointerException("null value in writing http header: " + name);
        }
        if (os == null) {
            throw new NullPointerException("null os in writing http header: " + name);
        }
        String header = HTTPUtils.createHeader(name, value);
        os.write(header.getBytes());
        if (!CommonUtils.isJava118()) {
            BandwidthStat.HTTP_HEADER_UPSTREAM_BANDWIDTH.addData(header.length());
        }
    }

    public static void writeHeader(HTTPHeaderName name, HTTPHeaderValue value, Writer out) throws IOException {
        if (name == null) {
            throw new NullPointerException("null name in writing http header");
        }
        if (value == null) {
            throw new NullPointerException("null value in writing http header: " + name);
        }
        if (out == null) {
            throw new NullPointerException("null os in writing http header: " + name);
        }
        String header = HTTPUtils.createHeader(name, value);
        out.write(header);
        if (!CommonUtils.isJava118()) {
            BandwidthStat.HTTP_HEADER_UPSTREAM_BANDWIDTH.addData(header.length());
        }
    }

    private static String createHeader(HTTPHeaderName name, HTTPHeaderValue value) throws IOException {
        if (name == null || value == null) {
            throw new NullPointerException("null value in creating http header");
        }
        String nameStr = name.httpStringValue();
        String valueStr = value.httpStringValue();
        if (nameStr == null || valueStr == null) {
            throw new NullPointerException("null value in creating http header");
        }
        StringBuffer sb = new StringBuffer();
        sb.append(nameStr);
        sb.append(COLON_SPACE);
        sb.append(valueStr);
        sb.append(CRLF);
        return sb.toString();
    }

    public static String extractHeaderValue(String header) {
        int index = header.indexOf(COLON);
        if (index <= 0) {
            return null;
        }
        return header.substring(index + 1).trim();
    }
}

