/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.handshaking;

import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.handshaking.AuthenticationHandshakeResponder;
import com.limegroup.gnutella.handshaking.HandshakeResponse;
import com.limegroup.gnutella.handshaking.HeaderNames;
import com.limegroup.gnutella.handshaking.UltrapeerHeaders;
import com.limegroup.gnutella.util.NetworkUtils;
import java.io.IOException;
import java.util.Properties;

public class UltrapeerHandshakeResponder
extends AuthenticationHandshakeResponder {
    private final ConnectionManager _manager = RouterService.getConnectionManager();

    public UltrapeerHandshakeResponder(String host) {
        super(RouterService.getConnectionManager(), host);
    }

    protected HandshakeResponse respondUnauthenticated(HandshakeResponse response, boolean outgoing) throws IOException {
        if (outgoing) {
            return this.respondToOutgoing(response);
        }
        return this.respondToIncoming(response);
    }

    private HandshakeResponse respondToOutgoing(HandshakeResponse response) {
        if (!this._manager.allowConnection(response)) {
            return HandshakeResponse.createRejectOutgoingResponse();
        }
        Properties ret = new Properties();
        if (response.hasLeafGuidance() && this.isNotBearshare(response) && this._manager.allowLeafDemotion()) {
            ret.put("X-Ultrapeer", "False");
        }
        if (response.isDeflateAccepted()) {
            ret.put(HeaderNames.CONTENT_ENCODING, HeaderNames.DEFLATE_VALUE);
        }
        return HandshakeResponse.createAcceptOutgoingResponse(ret);
    }

    private HandshakeResponse respondToIncoming(HandshakeResponse response) {
        if (response.isCrawler()) {
            return HandshakeResponse.createCrawlerResponse();
        }
        UltrapeerHeaders ret = new UltrapeerHeaders(this.getRemoteIP());
        ret.put("X-Ultrapeer-Needed", new Boolean(this._manager.supernodeNeeded()).toString());
        ret.put("Listen-IP", NetworkUtils.ip2string(RouterService.getAddress()) + ":" + RouterService.getPort());
        if (this.reject(response)) {
            return HandshakeResponse.createRejectIncomingResponse();
        }
        if (response.isDeflateAccepted()) {
            ret.put(HeaderNames.CONTENT_ENCODING, HeaderNames.DEFLATE_VALUE);
        }
        return HandshakeResponse.createAcceptIncomingResponse(ret);
    }

    private boolean isNotBearshare(HandshakeResponse headers) {
        String userAgent = headers.getUserAgent();
        if (userAgent == null) {
            return true;
        }
        return !userAgent.startsWith("BearShare");
    }

    private boolean reject(HandshakeResponse response) {
        boolean allowedNow = this._manager.allowConnection(response);
        if (allowedNow) {
            return false;
        }
        boolean allowedAsLeaf = this._manager.allowConnectionAsLeaf(response);
        return !response.isUltrapeer() || !allowedAsLeaf;
    }
}

