/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.handshaking;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.handshaking.AuthenticationHandshakeResponder;
import com.limegroup.gnutella.handshaking.HandshakeResponse;
import com.limegroup.gnutella.handshaking.HeaderNames;
import com.limegroup.gnutella.handshaking.LeafHeaders;
import java.io.IOException;
import java.util.Properties;

public final class LeafHandshakeResponder
extends AuthenticationHandshakeResponder {
    public LeafHandshakeResponder(String host) {
        super(RouterService.getConnectionManager(), host);
    }

    protected HandshakeResponse respondUnauthenticated(HandshakeResponse response, boolean outgoing) throws IOException {
        if (outgoing) {
            return this.respondToOutgoing(response);
        }
        return this.respondToIncoming(response);
    }

    private HandshakeResponse respondToOutgoing(HandshakeResponse response) {
        if (response.isLeaf()) {
            return HandshakeResponse.createLeafRejectOutgoingResponse();
        }
        if (!response.isGoodUltrapeer()) {
            return HandshakeResponse.createLeafRejectOutgoingResponse();
        }
        Properties ret = new Properties();
        if (response.isDeflateAccepted()) {
            ret.put(HeaderNames.CONTENT_ENCODING, HeaderNames.DEFLATE_VALUE);
        }
        return HandshakeResponse.createAcceptOutgoingResponse(ret);
    }

    private HandshakeResponse respondToIncoming(HandshakeResponse hr) {
        LeafHeaders ret = new LeafHeaders(this.getRemoteIP());
        if (RouterService.isShieldedLeaf()) {
            return HandshakeResponse.createLeafRejectIncomingResponse();
        }
        if (hr.isDeflateAccepted()) {
            ret.put(HeaderNames.CONTENT_ENCODING, HeaderNames.DEFLATE_VALUE);
        }
        return HandshakeResponse.createAcceptIncomingResponse(ret);
    }
}

