/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.handshaking;

import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.handshaking.HeaderNames;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.util.CommonUtils;
import java.util.Properties;

public abstract class DefaultHeaders
extends Properties {
    private static final String QUERY_ROUTING_VERSION = "0.1";

    protected DefaultHeaders(String remoteIP) {
        this.put("Listen-IP", "");
        if (remoteIP != null) {
            this.put("Remote-IP", remoteIP);
        }
        DefaultHeaders.addCommonHeaders(this);
    }

    public String getProperty(String key, String defaultValue) {
        if (key.equals("Listen-IP")) {
            Endpoint e = new Endpoint(RouterService.getAddress(), RouterService.getPort());
            return e.getHostname() + ":" + e.getPort();
        }
        return super.getProperty(key, defaultValue);
    }

    public String getProperty(String key) {
        if (key.equals("Listen-IP")) {
            Endpoint e = new Endpoint(RouterService.getAddress(), RouterService.getPort());
            return e.getHostname() + ":" + e.getPort();
        }
        return super.getProperty(key);
    }

    private static void addCommonHeaders(Properties props) {
        props.put("X-Query-Routing", QUERY_ROUTING_VERSION);
        props.put("User-Agent", CommonUtils.getHttpServer());
        props.put("GGEP", "0.5");
        props.put("X-Guess", QUERY_ROUTING_VERSION);
        props.put("Vendor-Message", QUERY_ROUTING_VERSION);
        props.put("X-Degree", Integer.toString(ConnectionManager.ULTRAPEER_CONNECTIONS));
        props.put("X-Ultrapeer-Query-Routing", QUERY_ROUTING_VERSION);
        props.put("X-Max-TTL", "3");
        props.put("X-Dynamic-Querying", QUERY_ROUTING_VERSION);
        if (ConnectionSettings.ACCEPT_DEFLATE.getValue()) {
            props.put(HeaderNames.ACCEPT_ENCODING, HeaderNames.DEFLATE_VALUE);
        }
        props.put("Pong-Caching", QUERY_ROUTING_VERSION);
    }
}

