/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.filters;

import com.limegroup.gnutella.filters.AllowFilter;
import com.limegroup.gnutella.filters.CompositeFilter;
import com.limegroup.gnutella.filters.DuplicateFilter;
import com.limegroup.gnutella.filters.GUIDFilter;
import com.limegroup.gnutella.filters.GreedyQueryFilter;
import com.limegroup.gnutella.filters.KeywordFilter;
import com.limegroup.gnutella.filters.RequeryFilter;
import com.limegroup.gnutella.filters.SpamReplyFilter;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.settings.FilterSettings;
import java.util.Vector;

public abstract class SpamFilter {
    public static SpamFilter newPersonalFilter() {
        Vector<SpamFilter> buf = new Vector<SpamFilter>();
        String[] badWords = FilterSettings.BANNED_WORDS.getValue();
        boolean filterAdult = FilterSettings.FILTER_ADULT.getValue();
        boolean filterVbs = true;
        boolean filterHtml = true;
        if (badWords.length != 0 || filterAdult || filterVbs || filterHtml) {
            KeywordFilter kf = new KeywordFilter();
            kf.disallow("     ");
            kf.disallow("!!_YEEHAA");
            kf.disallow("!!_GONZALES");
            kf.disallow("a_must_have");
            kf.disallow("have)");
            if (filterAdult) {
                kf.disallowAdult();
            }
            if (filterVbs) {
                kf.disallowVbs();
            }
            if (filterHtml) {
                kf.disallowHtml();
            }
            buf.add(kf);
        }
        SpamReplyFilter spf = new SpamReplyFilter();
        buf.add(spf);
        return SpamFilter.compose(buf);
    }

    public static SpamFilter newRouteFilter() {
        Vector<SpamFilter> buf = new Vector<SpamFilter>();
        buf.add(new RequeryFilter());
        buf.add(new GUIDFilter());
        if (FilterSettings.FILTER_DUPLICATES.getValue()) {
            buf.add(new DuplicateFilter());
        }
        if (FilterSettings.FILTER_GREEDY_QUERIES.getValue()) {
            buf.add(new GreedyQueryFilter());
        }
        return SpamFilter.compose(buf);
    }

    private static SpamFilter compose(Vector filters) {
        if (filters.size() == 0) {
            return new AllowFilter();
        }
        if (filters.size() == 1) {
            return (SpamFilter)filters.get(0);
        }
        Object[] delegates = new SpamFilter[filters.size()];
        filters.copyInto(delegates);
        return new CompositeFilter((SpamFilter[])delegates);
    }

    public abstract boolean allow(Message var1);
}

