/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.filters;

import com.limegroup.gnutella.filters.SpamFilter;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.QueryRequest;

public class BearShareFilter
extends SpamFilter {
    final int MAX_HIGHBITS = 20;

    public boolean allow(Message m) {
        if (!(m instanceof QueryRequest)) {
            return true;
        }
        if (m.getHops() + m.getTTL() <= 2) {
            return true;
        }
        QueryRequest qReq = (QueryRequest)m;
        String query = qReq.getQuery();
        byte[] queryBytes = query.getBytes();
        int rawQueryLength = qReq.getQuery().length();
        if (rawQueryLength < 20) {
            return true;
        }
        int highbits = 0;
        for (int i = 0; i < rawQueryLength; ++i) {
            byte currByte = queryBytes[i];
            if ((currByte & 0x80) == 0) continue;
            ++highbits;
        }
        return highbits < 20;
    }
}

