/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.AlternateLocation;
import com.limegroup.gnutella.AlternateLocationCollection;
import com.limegroup.gnutella.AlternateLocationCollector;
import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.BandwidthTracker;
import com.limegroup.gnutella.BandwidthTrackerImpl;
import com.limegroup.gnutella.ByteReader;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.downloader.CantConnectException;
import com.limegroup.gnutella.downloader.FileIncompleteException;
import com.limegroup.gnutella.downloader.FileNotFoundException;
import com.limegroup.gnutella.downloader.Interval;
import com.limegroup.gnutella.downloader.NoHTTPOKException;
import com.limegroup.gnutella.downloader.NotSharingException;
import com.limegroup.gnutella.downloader.QueuedException;
import com.limegroup.gnutella.downloader.RangeNotAvailableException;
import com.limegroup.gnutella.downloader.ReaderIsNullException;
import com.limegroup.gnutella.downloader.TryAgainLaterException;
import com.limegroup.gnutella.downloader.UnknownCodeException;
import com.limegroup.gnutella.downloader.VerifyingFile;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPUtils;
import com.limegroup.gnutella.http.ProblemReadingHeaderException;
import com.limegroup.gnutella.settings.ChatSettings;
import com.limegroup.gnutella.settings.UploadSettings;
import com.limegroup.gnutella.statistics.BandwidthStat;
import com.limegroup.gnutella.statistics.NumericalDownloadStat;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.Sockets;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class HTTPDownloader
implements BandwidthTracker {
    public static final int BUF_LENGTH = 1024;
    private static int MIN_PARTIAL_FILE_BYTES = 0x100000;
    private RemoteFileDesc _rfd;
    private boolean _isPush;
    private long _index;
    private String _filename;
    private byte[] _guid;
    private volatile int _totalAmountRead;
    private volatile int _amountRead;
    private volatile int _amountToRead;
    private int _initialReadingPoint;
    private ByteReader _byteReader;
    private Socket _socket;
    private File _incompleteFile;
    private boolean _outIsCorrupted;
    private final AlternateLocationCollection _alternateLocationsReceived;
    private final AlternateLocationCollection _alternateLocationsToSend;
    private int _port;
    private String _host;
    private boolean _chatEnabled = false;
    private boolean _browseEnabled = false;
    private String _server = "";
    private BandwidthTrackerImpl bandwidthTracker = new BandwidthTrackerImpl();

    public HTTPDownloader(RemoteFileDesc rfd, File incompleteFile, AlternateLocationCollection alts) {
        this(null, rfd, incompleteFile, alts);
        this._isPush = false;
    }

    public HTTPDownloader(Socket socket, RemoteFileDesc rfd, File incompleteFile, AlternateLocationCollection alts) {
        if (rfd == null) {
            throw new NullPointerException("null rfd");
        }
        this._isPush = true;
        this._rfd = rfd;
        this._socket = socket;
        this._incompleteFile = incompleteFile;
        this._filename = rfd.getFileName();
        this._index = rfd.getIndex();
        this._guid = rfd.getClientGUID();
        this._amountToRead = rfd.getSize();
        this._port = rfd.getPort();
        this._host = rfd.getHost();
        this._chatEnabled = rfd.chatEnabled();
        this._browseEnabled = rfd.browseHostEnabled();
        this._alternateLocationsToSend = alts;
        this._alternateLocationsReceived = alts == null ? null : AlternateLocationCollection.createCollection(alts.getSHA1Urn());
        this._amountRead = 0;
        this._totalAmountRead = 0;
    }

    public AlternateLocationCollection getAlternateLocations() {
        return this._alternateLocationsReceived;
    }

    public void connectTCP(int timeout) throws IOException {
        InputStream istream = null;
        try {
            if (this._socket == null) {
                long curTime = System.currentTimeMillis();
                this._socket = Sockets.connect(this._host, this._port, timeout);
                NumericalDownloadStat.TCP_CONNECT_TIME.addData((int)(System.currentTimeMillis() - curTime));
            }
            Sockets.setKeepAlive(this._socket, true);
            istream = this._socket.getInputStream();
        }
        catch (IOException e) {
            throw new CantConnectException();
        }
        this._socket.setSoTimeout(8000);
        this._byteReader = new ByteReader(istream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectHTTP(int start, int stop, boolean supportQueueing) throws IOException, TryAgainLaterException, FileNotFoundException, NotSharingException, QueuedException, RangeNotAvailableException, ProblemReadingHeaderException, UnknownCodeException {
        URN sha1;
        this._amountToRead = stop - start;
        this._totalAmountRead += this._amountRead;
        this._amountRead = 0;
        this._initialReadingPoint = start;
        OutputStream os = this._socket.getOutputStream();
        OutputStreamWriter osw = new OutputStreamWriter(os);
        BufferedWriter out = new BufferedWriter(osw);
        String startRange = String.valueOf(this._initialReadingPoint);
        out.write("GET " + this._rfd.getUrl().getFile() + " HTTP/1.1\r\n");
        out.write("HOST: " + this._host + ":" + this._port + "\r\n");
        out.write("User-Agent: " + CommonUtils.getHttpServer() + "\r\n");
        if (supportQueueing) {
            out.write("X-Queue: 0.1\r\n");
        }
        AlternateLocationCollection alts = null;
        if (this._alternateLocationsToSend != null) {
            alts = AlternateLocationCollection.createCollection(this._alternateLocationsToSend.getSHA1Urn());
            AlternateLocationCollection alternateLocationCollection = this._alternateLocationsToSend;
            synchronized (alternateLocationCollection) {
                alts.addAlternateLocationCollection(this._alternateLocationsToSend);
            }
        }
        if (this._rfd.getSHA1Urn() != null && UploadSettings.ALLOW_PARTIAL_SHARING.getValue() && !this._outIsCorrupted && RouterService.acceptedIncomingConnection() && this._incompleteFile.length() > (long)MIN_PARTIAL_FILE_BYTES) {
            if (alts == null) {
                alts = AlternateLocationCollection.createCollection(this._rfd.getSHA1Urn());
            }
            AlternateLocation al = AlternateLocation.createAlternateLocation(alts.getSHA1Urn());
            alts.addAlternateLocation(al);
        }
        if ((sha1 = this._rfd.getSHA1Urn()) != null) {
            HTTPUtils.writeHeader(HTTPHeaderName.GNUTELLA_CONTENT_URN, (HTTPHeaderValue)sha1, out);
        }
        if (alts != null && alts.getNumberOfAlternateLocations() > 0) {
            HTTPUtils.writeHeader(HTTPHeaderName.ALT_LOCATION, (HTTPHeaderValue)alts, out);
        }
        out.write("Range: bytes=" + startRange + "-" + (stop - 1) + "\r\n");
        if (ChatSettings.CHAT_ENABLED.getValue()) {
            int port = RouterService.getPort();
            String host = NetworkUtils.ip2string(RouterService.getAddress());
            out.write("Chat: " + host + ":" + port + "\r\n");
        }
        out.write("\r\n");
        out.flush();
        this.readHeaders();
    }

    private void readHeaders() throws IOException {
        if (this._byteReader == null) {
            throw new ReaderIsNullException();
        }
        String str = this._byteReader.readLine();
        if (str == null || str.equals("")) {
            throw new IOException();
        }
        if (!CommonUtils.isJava118()) {
            BandwidthStat.HTTP_HEADER_DOWNSTREAM_BANDWIDTH.addData(str.length());
        }
        int code = HTTPDownloader.parseHTTPCode(str, this._rfd);
        int[] refQueueInfo = new int[]{-1, -1, -1};
        while ((str = this._byteReader.readLine()) != null && !str.equals("")) {
            if (!CommonUtils.isJava118()) {
                BandwidthStat.HTTP_HEADER_DOWNSTREAM_BANDWIDTH.addData(str.length());
            }
            if (str.toUpperCase().startsWith("CONTENT-RANGE:")) {
                int startOffset = HTTPDownloader.parseContentRangeStart(str);
                if (startOffset == this._initialReadingPoint) continue;
                throw new ProblemReadingHeaderException("Unexpected start offset; too dumb to recover");
            }
            if (HTTPHeaderName.ALT_LOCATION.matchesStartOfString(str)) {
                HTTPDownloader.readAlternateLocations(str, this._alternateLocationsReceived);
                continue;
            }
            if (HTTPHeaderName.QUEUE.matchesStartOfString(str)) {
                this.parseQueueHeaders(str, refQueueInfo);
                continue;
            }
            if (HTTPHeaderName.SERVER.matchesStartOfString(str)) {
                this._server = HTTPDownloader.readServer(str);
                continue;
            }
            if (!HTTPHeaderName.AVAILABLE_RANGES.matchesStartOfString(str)) continue;
            HTTPDownloader.parseAvailableRangesHeader(str, this._rfd);
        }
        if (code < 200 || code >= 300) {
            if (code == 404) {
                throw new FileNotFoundException();
            }
            if (code == 410) {
                throw new NotSharingException();
            }
            if (code == 416) {
                throw new RangeNotAvailableException();
            }
            if (code == 503) {
                int min = refQueueInfo[0];
                int max = refQueueInfo[1];
                int pos = refQueueInfo[2];
                if (min != -1 && max != -1 && pos != -1) {
                    throw new QueuedException(min, max, pos);
                }
                if (this._rfd.isPartialSource()) {
                    throw new RangeNotAvailableException();
                }
                throw new TryAgainLaterException();
            }
            throw new UnknownCodeException(code);
        }
    }

    private static void readAlternateLocations(String altHeader, AlternateLocationCollector alc) {
        String alternateLocations = HTTPUtils.extractHeaderValue(altHeader);
        if (alternateLocations == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(alternateLocations, ",");
        while (st.hasMoreTokens()) {
            try {
                AlternateLocation al = AlternateLocation.createAlternateLocation(st.nextToken().trim());
                URN alSha1 = al.getSHA1Urn();
                if (alSha1 == null) continue;
                if (alc == null) {
                    alc = AlternateLocationCollection.createCollection(alSha1);
                }
                if (!alSha1.equals(alc.getSHA1Urn())) continue;
                alc.addAlternateLocation(al);
            }
            catch (IOException e) {}
        }
    }

    public static String readServer(String serverHeader) {
        int colon = serverHeader.indexOf(58);
        if (colon != -1 && colon < serverHeader.length() - 1) {
            return serverHeader.substring(colon + 1).trim();
        }
        return "";
    }

    private static int parseHTTPCode(String str, RemoteFileDesc rfd) throws IOException {
        StringTokenizer tokenizer = new StringTokenizer(str, " ");
        if (!tokenizer.hasMoreTokens()) {
            throw new NoHTTPOKException();
        }
        String token = tokenizer.nextToken();
        if (token.toUpperCase().indexOf("HTTP") < 0) {
            throw new NoHTTPOKException();
        }
        rfd.setHTTP11(token.indexOf("1.1") > 0);
        if (!tokenizer.hasMoreTokens()) {
            throw new NoHTTPOKException();
        }
        token = tokenizer.nextToken();
        String num = token.trim();
        try {
            return Integer.parseInt(num);
        }
        catch (NumberFormatException e) {
            throw new ProblemReadingHeaderException();
        }
    }

    private void parseQueueHeaders(String str, int[] refQueueInfo) {
        if (str == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(str, " ,:=");
        if (!tokenizer.hasMoreTokens()) {
            return;
        }
        String token = tokenizer.nextToken();
        if (!token.equalsIgnoreCase("X-Queue")) {
            return;
        }
        while (tokenizer.hasMoreTokens()) {
            token = tokenizer.nextToken();
            try {
                String value;
                if (token.equalsIgnoreCase("pollMin")) {
                    value = tokenizer.nextToken();
                    refQueueInfo[0] = Integer.parseInt(value);
                    continue;
                }
                if (token.equalsIgnoreCase("pollMax")) {
                    value = tokenizer.nextToken();
                    refQueueInfo[1] = Integer.parseInt(value);
                    continue;
                }
                if (!token.equalsIgnoreCase("position")) continue;
                value = tokenizer.nextToken();
                refQueueInfo[2] = Integer.parseInt(value);
            }
            catch (NumberFormatException nfx) {
                Arrays.fill(refQueueInfo, -1);
            }
            catch (NoSuchElementException nsex) {
                Arrays.fill(refQueueInfo, -1);
            }
        }
    }

    private static int parseContentRangeStart(String str) throws IOException {
        int numAfterSlash;
        int numBeforeSlash;
        int numBeforeDash;
        try {
            int start = str.indexOf("bytes") + 6;
            int slash = str.indexOf(47);
            if (str.substring(start, slash).equals("*")) {
                return 0;
            }
            int dash = str.lastIndexOf("-");
            numBeforeDash = Integer.parseInt(str.substring(start, dash));
            numBeforeSlash = Integer.parseInt(str.substring(dash + 1, slash));
            if (str.substring(slash + 1).equals("*")) {
                return numBeforeDash;
            }
            numAfterSlash = Integer.parseInt(str.substring(slash + 1));
        }
        catch (IndexOutOfBoundsException e) {
            throw new ProblemReadingHeaderException();
        }
        catch (NumberFormatException e) {
            throw new ProblemReadingHeaderException();
        }
        if (numBeforeSlash == numAfterSlash) {
            --numBeforeDash;
            --numBeforeSlash;
        }
        return numBeforeDash;
    }

    private static void parseAvailableRangesHeader(String line, RemoteFileDesc rfd) throws IOException {
        int stop;
        ArrayList<Interval> availableRanges = new ArrayList<Interval>();
        line = line.toLowerCase();
        int start = line.indexOf("bytes") + 6;
        while (start != -1 && start < line.length() && (stop = line.indexOf(45, start)) != -1) {
            Interval interval = null;
            try {
                int low = Integer.parseInt(line.substring(start, stop).trim());
                start = stop + 1;
                stop = line.indexOf(44, start);
                if (stop == -1) {
                    stop = line.length();
                }
                int high = Integer.parseInt(line.substring(start, stop).trim());
                interval = new Interval(low, high);
                start = stop + 1;
            }
            catch (NumberFormatException e) {
                throw new ProblemReadingHeaderException();
            }
            availableRanges.add(interval);
        }
        rfd.setAvailableRanges(availableRanges);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDownload(VerifyingFile commonOutFile) throws IOException {
        this._socket.setSoTimeout(0);
        long currPos = this._initialReadingPoint;
        try {
            int atr;
            int c = -1;
            byte[] buf = new byte[1024];
            while (this._amountRead < (atr = this._amountToRead)) {
                int left = atr - this._amountRead;
                Assert.that(left > 0);
                c = this._byteReader.read(buf, 0, Math.min(1024, left));
                if (c == -1) break;
                if (!CommonUtils.isJava118()) {
                    BandwidthStat.HTTP_BODY_DOWNSTREAM_BANDWIDTH.addData(c);
                }
                commonOutFile.writeBlock(currPos, c, buf);
                this._outIsCorrupted = commonOutFile.isCorrupted();
                currPos += (long)c;
                this._amountRead += c;
            }
            if (this._amountRead < this._amountToRead) {
                throw new FileIncompleteException();
            }
        }
        finally {
            if (!this.isHTTP11()) {
                this._byteReader.close();
            }
        }
    }

    public void stop() {
        if (this._byteReader != null) {
            this._byteReader.close();
        }
        try {
            if (this._socket != null) {
                this._socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void stopAt(int stop) {
        this._amountToRead = stop - this._initialReadingPoint;
    }

    public int getInitialReadingPoint() {
        return this._initialReadingPoint;
    }

    public int getAmountRead() {
        return this._amountRead;
    }

    public int getTotalAmountRead() {
        return this._totalAmountRead + this._amountRead;
    }

    public int getAmountToRead() {
        return this._amountToRead;
    }

    public InetAddress getInetAddress() {
        return this._socket.getInetAddress();
    }

    public boolean chatEnabled() {
        return this._chatEnabled;
    }

    public boolean browseEnabled() {
        return this._browseEnabled;
    }

    public String getVendor() {
        return this._server;
    }

    public long getIndex() {
        return this._index;
    }

    public String getFileName() {
        return this._filename;
    }

    public byte[] getGUID() {
        return this._guid;
    }

    public int getPort() {
        return this._port;
    }

    public RemoteFileDesc getRemoteFileDesc() {
        return this._rfd;
    }

    public boolean isPush() {
        return this._isPush;
    }

    public boolean isHTTP11() {
        return this._rfd.isHTTP11();
    }

    public void measureBandwidth() {
        this.bandwidthTracker.measureBandwidth(this.getTotalAmountRead());
    }

    public float getMeasuredBandwidth() throws InsufficientDataException {
        return this.bandwidthTracker.getMeasuredBandwidth();
    }

    public float getAverageBandwidth() {
        return this.bandwidthTracker.getAverageBandwidth();
    }

    public String toString() {
        return "<" + this._host + ":" + this._port + ", " + this.getFileName() + ">";
    }

    private HTTPDownloader(String str) {
        ByteArrayInputStream stream = new ByteArrayInputStream(str.getBytes());
        this._byteReader = new ByteReader(stream);
        this._alternateLocationsReceived = null;
        this._alternateLocationsToSend = null;
        this._rfd = new RemoteFileDesc("127.0.0.1", 1, 0L, "a", 0, new byte[16], 0, false, 0, false, null, null, false, false, "", 0L, null);
    }
}

