/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.browser;

import com.limegroup.gnutella.util.CommonUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.StringTokenizer;

public class HTTPHandler {
    private static final String ROOT = "root/";
    private Socket _socket;
    private OutputStream _ostream;
    private boolean _inErrorState;
    private String _line;

    public static HTTPHandler create(Socket socket, String line) {
        HTTPHandler handler = new HTTPHandler(socket, line);
        handler.handle();
        return handler;
    }

    public HTTPHandler(Socket socket, String line) {
        this._socket = socket;
        this._line = line;
        this._inErrorState = false;
    }

    public void handle() {
        this.setupIO();
        String rpath = this.getRelativePath(this._line);
        int rloc = rpath.indexOf("?");
        File apath = rloc > 0 ? new File(ROOT, rpath.substring(0, rloc)) : new File(ROOT, rpath);
        this.processRequest(apath, rpath);
    }

    private void setupIO() {
        try {
            this._ostream = this._socket.getOutputStream();
        }
        catch (IOException e) {
            this._inErrorState = true;
        }
    }

    private String getRelativePath(String line) {
        StringTokenizer st = new StringTokenizer(line);
        String path = null;
        if (st.hasMoreTokens()) {
            path = st.nextToken();
        } else {
            this._inErrorState = true;
        }
        return path;
    }

    private void processRequest(File apath, String rpath) {
        String rbase = rpath;
        int rloc = rbase.indexOf("?");
        if (rloc > 0) {
            rbase = rbase.substring(0, rloc);
        }
        if (!apath.exists()) {
            this._inErrorState = true;
        }
        if (!apath.canRead()) {
            this._inErrorState = true;
        }
        if (this._inErrorState) {
            this.writeError();
        } else if (apath.isFile()) {
            this.uploadFile(apath);
        } else if (apath.isDirectory()) {
            // empty if block
        }
    }

    public void uploadFile(File apath) {
        int length = (int)apath.length();
        byte[] content = new byte[length];
        try {
            this.writeHeader(length, this.getMimeType(apath.toString()));
            FileInputStream in = new FileInputStream(apath);
            in.read(content);
            in.close();
            this._ostream.write(content);
        }
        catch (IOException e) {
            this._inErrorState = true;
        }
        try {
            this._ostream.close();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private String getMimeType(String filename) {
        if (filename.endsWith(".gif")) {
            return "image/gif";
        }
        if (filename.endsWith(".img")) {
            return "image/gif";
        }
        if (filename.endsWith(".js")) {
            return "application/x-javascript";
        }
        return "text/html";
    }

    private void writeHeader(int length, String mimeType) throws IOException {
        String str = "HTTP/1.1 200 OK \r\n";
        this._ostream.write(str.getBytes());
        str = "Server: " + CommonUtils.getVendor() + "\r\n";
        this._ostream.write(str.getBytes());
        str = "Content-type:" + mimeType + "\r\n";
        this._ostream.write(str.getBytes());
        str = "Content-length:" + length + "\r\n";
        this._ostream.write(str.getBytes());
        str = "\r\n";
        this._ostream.write(str.getBytes());
    }

    public void writeError() {
        try {
            String str = "HTTP/1.1 404 Not Found\r\n";
            this._ostream.write(str.getBytes());
            this._ostream.flush();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this._ostream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

