/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.browser;

import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.ByteReader;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.browser.MagnetOptions;
import com.limegroup.gnutella.downloader.AlreadyDownloadingException;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.URLDecoder;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

public class ExternalControl {
    private static final String LOCALHOST = "127.0.0.1";
    private static final String HTTP = "http://";
    private static boolean initialized = false;
    private static String enqueuedRequest = null;

    public static void handleMagnetRequest(String arg) {
        ActivityCallback callback = RouterService.getCallback();
        if (RouterService.getNumInitializedConnections() <= 0) {
            RouterService.connect();
        }
        callback.restoreApplication();
        callback.showDownloads();
        MagnetOptions[] options = ExternalControl.parseMagnet(arg);
        if (options == null) {
            return;
        }
        for (int i = 0; i < options.length; ++i) {
            URN urn = null;
            if (options[i].xt != null && options[i].xt.length() > 0) {
                try {
                    urn = URN.createSHA1Urn(options[i].xt);
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            String[] defaultURLs = null;
            ArrayList<String> urls = new ArrayList<String>();
            if (options[i].xs != null && options[i].xs.startsWith(HTTP)) {
                urls.add(options[i].xs);
            }
            if (options[i].as != null && options[i].as.startsWith(HTTP)) {
                urls.add(options[i].as);
            }
            if (urls.size() > 0) {
                defaultURLs = new String[urls.size()];
                defaultURLs = urls.toArray(defaultURLs);
            }
            try {
                RouterService.download(urn, options[i].kt, options[i].dn, defaultURLs);
                continue;
            }
            catch (AlreadyDownloadingException a) {
                continue;
            }
            catch (IllegalArgumentException il) {
                // empty catch block
            }
        }
    }

    public static void fireMagnet(Socket socket) {
        Thread.currentThread().setName("IncomingMagnetThread");
        try {
            if (!LOCALHOST.equals(socket.getInetAddress().getHostAddress())) {
                return;
            }
            socket.setSoTimeout(8000);
            ByteReader br = new ByteReader(socket.getInputStream());
            String line = br.readLine();
            socket.setSoTimeout(0);
            BufferedOutputStream out = new BufferedOutputStream(socket.getOutputStream());
            String s = CommonUtils.getUserName() + "\r\n";
            byte[] bytes = s.getBytes();
            out.write(bytes);
            out.flush();
            ExternalControl.handleMagnetRequest(line);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static MagnetOptions[] parseMagnet(String arg) {
        MagnetOptions[] ret = null;
        HashMap<Integer, MagnetOptions> options = new HashMap<Integer, MagnetOptions>();
        if (arg.startsWith("'")) {
            arg = arg.substring(1);
        }
        if (arg.endsWith("'")) {
            arg = arg.substring(0, arg.length() - 1);
        }
        if (!arg.startsWith("magnet:?")) {
            return ret;
        }
        arg = arg.substring(8);
        StringTokenizer st = new StringTokenizer(arg, "&");
        while (st.hasMoreTokens()) {
            int index;
            String cmdstr;
            String keystr;
            block17: {
                keystr = st.nextToken();
                keystr = keystr.trim();
                int start = keystr.indexOf("=") + 1;
                cmdstr = keystr.substring(start);
                keystr = keystr.substring(0, start - 1);
                cmdstr = URLDecoder.decode(cmdstr);
                int periodLoc = keystr.indexOf(".");
                if (periodLoc > 0) {
                    try {
                        index = Integer.parseInt(keystr.substring(periodLoc + 1));
                        break block17;
                    }
                    catch (NumberFormatException e) {
                        continue;
                    }
                }
                index = 0;
            }
            Integer iIndex = new Integer(index);
            MagnetOptions curOptions = (MagnetOptions)options.get(iIndex);
            if (curOptions == null) {
                curOptions = new MagnetOptions();
            }
            if (keystr.startsWith("xt")) {
                curOptions.xt = cmdstr;
            } else if (keystr.startsWith("dn")) {
                curOptions.dn = cmdstr;
            } else if (keystr.startsWith("kt")) {
                curOptions.kt = cmdstr;
            } else if (keystr.startsWith("xs")) {
                curOptions.xs = cmdstr;
            } else if (keystr.startsWith("as")) {
                curOptions.as = cmdstr;
            }
            options.put(iIndex, curOptions);
        }
        ret = new MagnetOptions[options.size()];
        ret = options.values().toArray(ret);
        return ret;
    }
}

