/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.bootstrap;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.HostCatcher;
import com.limegroup.gnutella.bootstrap.BootstrapServer;
import com.limegroup.gnutella.bootstrap.DefaultBootstrapServers;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.Random12;
import com.limegroup.gnutella.util.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class BootstrapServerManager {
    private static final int ENDPOINTS_TO_ADD = 10;
    private static final int MAX_BOOTSTRAP_SERVERS = 200;
    public static int MAX_HOSTS_PER_REQUEST = 20;
    public static int UPDATE_DELAY_MSEC = 3600000;
    private final List SERVERS = new ArrayList();
    private BootstrapServer _lastConnectable;
    private final HostCatcher CATCHER;
    private Random12 _rand = new Random12();
    private boolean _hostFetchInProgress = false;

    public BootstrapServerManager(HostCatcher catcher) {
        this.CATCHER = catcher;
    }

    public synchronized void addBootstrapServer(BootstrapServer server) {
        if (server == null) {
            throw new NullPointerException("null bootstrap server not allowed");
        }
        if (!this.SERVERS.contains(server)) {
            this.SERVERS.add(server);
        }
        if (this.SERVERS.size() > 200) {
            this.SERVERS.remove(this.randomServer());
        }
    }

    public synchronized Iterator getBootstrapServers() {
        return this.SERVERS.iterator();
    }

    public synchronized void fetchBootstrapServersAsync() {
        if (!ConnectionSettings.USE_GWEBCACHE.getValue()) {
            return;
        }
        this.addDefaultsIfNeeded();
        this.requestAsync(new UrlfileRequest(), "GWebCache urlfile");
    }

    public synchronized void fetchEndpointsAsync() {
        if (!ConnectionSettings.USE_GWEBCACHE.getValue()) {
            return;
        }
        this.addDefaultsIfNeeded();
        if (!this._hostFetchInProgress) {
            this._hostFetchInProgress = true;
            this.requestAsync(new HostfileRequest(), "GWebCache hostfile");
        }
    }

    public synchronized void sendUpdatesAsync(Endpoint myIP) {
        if (myIP == null) {
            throw new NullPointerException("cannot accept null update IP");
        }
        this.addDefaultsIfNeeded();
        if (!myIP.isPrivateAddress()) {
            this.requestAsync(new UpdateRequest(myIP), "GWebCache update");
        }
    }

    private void addDefaultsIfNeeded() {
        if (this.SERVERS.size() > 0) {
            return;
        }
        DefaultBootstrapServers.addDefaults(this);
    }

    private void requestAsync(final GWebCacheRequest request, String threadName) {
        if (request == null) {
            throw new NullPointerException("asynchronous request to null cache");
        }
        Thread runner = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    BootstrapServerManager.this.requestBlocking(request);
                }
                catch (Throwable e) {
                    ErrorService.error(e);
                }
                finally {
                    request.done();
                }
            }
        };
        runner.setName(threadName);
        runner.setDaemon(true);
        runner.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestBlocking(GWebCacheRequest request) {
        if (request == null) {
            throw new NullPointerException("blocking request to null cache");
        }
        for (int i = 0; request.needsMoreData() && i < MAX_HOSTS_PER_REQUEST; ++i) {
            BootstrapServer e;
            BootstrapServerManager bootstrapServerManager = this;
            synchronized (bootstrapServerManager) {
                if (this.SERVERS.size() == 0) {
                    break;
                }
                e = (BootstrapServer)this.SERVERS.get(this.randomServer());
            }
            this.requestFromOneHost(request, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void requestFromOneHost(GWebCacheRequest request, BootstrapServer server) {
        BufferedReader in;
        block16: {
            String line;
            if (request == null) {
                throw new NullPointerException("null cache in request to one host");
            }
            if (server == null) {
                throw new NullPointerException("null server in request to one host");
            }
            in = null;
            URL url = new URL(server.getURL().toString() + "?client=" + "ACQL" + "&version=" + URLEncoder.encode(CommonUtils.getLimeWireVersion()) + "&" + request.parameters());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setUseCaches(false);
            connection.setRequestProperty("User-Agent", CommonUtils.getHttpServer());
            connection.setRequestProperty(HTTPHeaderName.CONNECTION.httpStringValue(), "close");
            try {
                in = new BufferedReader(new InputStreamReader(connection.getInputStream(), "ISO-8859-1"));
            }
            catch (NullPointerException e) {
                throw new IOException("null .getInputStream()");
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IOException("aiioe");
            }
            boolean firstLine = true;
            boolean errors = false;
            while ((line = in.readLine()) != null) {
                if (firstLine && StringUtils.startsWithIgnoreCase(line, "ERROR")) {
                    request.handleError(server);
                    errors = true;
                } else {
                    request.handleResponseData(server, line);
                }
                firstLine = false;
            }
            if (errors) break block16;
            this._lastConnectable = server;
        }
        Object var10_12 = null;
        if (in == null) return;
        try {
            in.close();
            return;
        }
        catch (IOException e) {}
        return;
        {
            catch (IOException ioe) {
                request.handleError(server);
                Object var10_13 = null;
                if (in == null) return;
                try {
                    in.close();
                    return;
                }
                catch (IOException e) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
    }

    protected int randomServer() {
        return this._rand.nextInt(this.SERVERS.size());
    }

    protected synchronized int size() {
        return this.SERVERS.size();
    }

    private final class UpdateRequest
    extends GWebCacheRequest {
        private boolean gotResponse = false;
        private Endpoint myIP;

        protected UpdateRequest(Endpoint myIP) {
            this.myIP = myIP;
        }

        protected String parameters() {
            String urlPart = null;
            if (BootstrapServerManager.this._lastConnectable != null) {
                urlPart = "url=" + URLEncoder.encode(BootstrapServerManager.this._lastConnectable.getURL().toString());
            }
            String ipPart = null;
            if (this.myIP != null) {
                ipPart = "ip=" + this.myIP.getHostname() + ":" + this.myIP.getPort();
            }
            if (urlPart == null && ipPart == null) {
                return "";
            }
            if (urlPart != null && ipPart == null) {
                return urlPart;
            }
            if (urlPart == null && ipPart != null) {
                return ipPart;
            }
            Assert.that(urlPart != null && ipPart != null);
            return ipPart + "&" + urlPart;
        }

        protected void handleResponseData(BootstrapServer server, String line) {
            if (StringUtils.startsWithIgnoreCase(line, "OK")) {
                this.gotResponse = true;
            }
        }

        protected boolean needsMoreData() {
            return !this.gotResponse;
        }
    }

    private final class UrlfileRequest
    extends GWebCacheRequest {
        private int responses = 0;

        private UrlfileRequest() {
        }

        protected String parameters() {
            return "urlfile=1";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleResponseData(BootstrapServer server, String line) {
            try {
                BootstrapServer e = new BootstrapServer(line);
                BootstrapServerManager bootstrapServerManager = BootstrapServerManager.this;
                synchronized (bootstrapServerManager) {
                    BootstrapServerManager.this.addBootstrapServer(e);
                }
                ++this.responses;
            }
            catch (ParseException error) {
                this.handleError(server);
            }
        }

        protected boolean needsMoreData() {
            return this.responses < 10;
        }
    }

    private final class HostfileRequest
    extends GWebCacheRequest {
        private int responses = 0;

        private HostfileRequest() {
        }

        protected String parameters() {
            return "hostfile=1";
        }

        protected void handleResponseData(BootstrapServer server, String line) {
            try {
                Endpoint host = new Endpoint(line, true);
                BootstrapServerManager.this.CATCHER.add(host, true);
                ++this.responses;
            }
            catch (IllegalArgumentException bad) {
                this.handleError(server);
            }
        }

        protected boolean needsMoreData() {
            return this.responses < 10;
        }

        protected void done() {
            BootstrapServerManager.this._hostFetchInProgress = false;
        }
    }

    private abstract class GWebCacheRequest {
        private GWebCacheRequest() {
        }

        protected abstract String parameters();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleError(BootstrapServer server) {
            BootstrapServerManager bootstrapServerManager = BootstrapServerManager.this;
            synchronized (bootstrapServerManager) {
                BootstrapServerManager.this.SERVERS.remove(server);
                if (BootstrapServerManager.this._lastConnectable == server) {
                    BootstrapServerManager.this._lastConnectable = null;
                }
            }
        }

        protected abstract void handleResponseData(BootstrapServer var1, String var2);

        protected abstract boolean needsMoreData();

        protected void done() {
        }
    }
}

